/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings
 * Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output
 * bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145
 * (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and
 * output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Vc3Class {
    CLASS_145_8_BIT("CLASS_145_8BIT"),

    CLASS_220_8_BIT("CLASS_220_8BIT"),

    CLASS_220_10_BIT("CLASS_220_10BIT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Vc3Class(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Vc3Class corresponding to the value
     */
    public static Vc3Class fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Vc3Class.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Vc3Class}s
     */
    public static Set<Vc3Class> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
