/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vc3Settings implements SdkPojo, Serializable, ToCopyableBuilder<Vc3Settings.Builder, Vc3Settings> {
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(Vc3Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(Vc3Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(Vc3Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(Vc3Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(Vc3Settings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanTypeConversionMode").getter(getter(Vc3Settings::scanTypeConversionModeAsString))
            .setter(setter(Builder::scanTypeConversionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build())
            .build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(Vc3Settings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(Vc3Settings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final SdkField<String> VC3_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Vc3Class").getter(getter(Vc3Settings::vc3ClassAsString)).setter(setter(Builder::vc3Class))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vc3Class").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_CONTROL_FIELD,
            FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD,
            SCAN_TYPE_CONVERSION_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD, VC3_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String interlaceMode;

    private final String scanTypeConversionMode;

    private final String slowPal;

    private final String telecine;

    private final String vc3Class;

    private Vc3Settings(BuilderImpl builder) {
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
        this.vc3Class = builder.vc3Class;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Vc3FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Vc3FramerateControl
     */
    public final Vc3FramerateControl framerateControl() {
        return Vc3FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Vc3FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Vc3FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Vc3FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Vc3FramerateConversionAlgorithm
     */
    public final Vc3FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Vc3FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Vc3FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Vc3FramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
     * progressive output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link Vc3InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
     *         create a progressive output.
     * @see Vc3InterlaceMode
     */
    public final Vc3InterlaceMode interlaceMode() {
        return Vc3InterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
     * progressive output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link Vc3InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
     *         create a progressive output.
     * @see Vc3InterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link Vc3ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see Vc3ScanTypeConversionMode
     */
    public final Vc3ScanTypeConversionMode scanTypeConversionMode() {
        return Vc3ScanTypeConversionMode.fromValue(scanTypeConversionMode);
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link Vc3ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see Vc3ScanTypeConversionMode
     */
    public final String scanTypeConversionModeAsString() {
        return scanTypeConversionMode;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your
     * JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     * (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link Vc3SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set
     *         Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED),
     *         (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * @see Vc3SlowPal
     */
    public final Vc3SlowPal slowPal() {
        return Vc3SlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your
     * JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     * (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link Vc3SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set
     *         Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED),
     *         (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * @see Vc3SlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
     * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     * with the field polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link Vc3Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you
     *         keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
     *         doing anything with the field polarity to create a smoother picture.
     * @see Vc3Telecine
     */
    public final Vc3Telecine telecine() {
        return Vc3Telecine.fromValue(telecine);
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
     * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     * with the field polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link Vc3Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you
     *         keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
     *         doing anything with the field polarity to create a smoother picture.
     * @see Vc3Telecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    /**
     * Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
     * settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine
     * your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then
     * Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220)
     * gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of
     * your output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vc3Class} will
     * return {@link Vc3Class#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vc3ClassAsString}.
     * </p>
     * 
     * @return Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
     *         settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width),
     *         determine your output bitrate. For example, say that your video resolution is 1920x1080 and your
     *         framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145
     *         Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class
     *         also specifies the color bit depth of your output.
     * @see Vc3Class
     */
    public final Vc3Class vc3Class() {
        return Vc3Class.fromValue(vc3Class);
    }

    /**
     * Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
     * settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine
     * your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then
     * Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220)
     * gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of
     * your output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vc3Class} will
     * return {@link Vc3Class#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vc3ClassAsString}.
     * </p>
     * 
     * @return Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
     *         settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width),
     *         determine your output bitrate. For example, say that your video resolution is 1920x1080 and your
     *         framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145
     *         Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class
     *         also specifies the color bit depth of your output.
     * @see Vc3Class
     */
    public final String vc3ClassAsString() {
        return vc3Class;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vc3ClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vc3Settings)) {
            return false;
        }
        Vc3Settings other = (Vc3Settings) obj;
        return Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString())
                && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString())
                && Objects.equals(vc3ClassAsString(), other.vc3ClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vc3Settings").add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("InterlaceMode", interlaceModeAsString()).add("ScanTypeConversionMode", scanTypeConversionModeAsString())
                .add("SlowPal", slowPalAsString()).add("Telecine", telecineAsString()).add("Vc3Class", vc3ClassAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "ScanTypeConversionMode":
            return Optional.ofNullable(clazz.cast(scanTypeConversionModeAsString()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        case "Vc3Class":
            return Optional.ofNullable(clazz.cast(vc3ClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vc3Settings, T> g) {
        return obj -> g.apply((Vc3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vc3Settings> {
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Vc3FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Vc3FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3FramerateControl
         */
        Builder framerateControl(Vc3FramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Vc3FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Vc3FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(Vc3FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
         * progressive output.
         * 
         * @param interlaceMode
         *        Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
         *        create a progressive output.
         * @see Vc3InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3InterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
         * progressive output.
         * 
         * @param interlaceMode
         *        Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
         *        create a progressive output.
         * @see Vc3InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3InterlaceMode
         */
        Builder interlaceMode(Vc3InterlaceMode interlaceMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see Vc3ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(String scanTypeConversionMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see Vc3ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(Vc3ScanTypeConversionMode scanTypeConversionMode);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
         * In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         * (framerateDenominator) to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED),
         *        (framerateNumerator) to 25 and (framerateDenominator) to 1.
         * @see Vc3SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3SlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
         * In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         * (framerateDenominator) to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED),
         *        (framerateNumerator) to 25 and (framerateDenominator) to 1.
         * @see Vc3SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3SlowPal
         */
        Builder slowPal(Vc3SlowPal slowPal);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
         * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing
         * anything with the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture.
         *        When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to
         *        29.97 without doing anything with the field polarity to create a smoother picture.
         * @see Vc3Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3Telecine
         */
        Builder telecine(String telecine);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the
         * default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing
         * anything with the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture.
         *        When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to
         *        29.97 without doing anything with the field polarity to create a smoother picture.
         * @see Vc3Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3Telecine
         */
        Builder telecine(Vc3Telecine telecine);

        /**
         * Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
         * settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine
         * your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97.
         * Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220
         * (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color
         * bit depth of your output.
         * 
         * @param vc3Class
         *        Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with
         *        the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and
         *        width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and
         *        your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of
         *        approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately
         *        220 Mbps. VC3 class also specifies the color bit depth of your output.
         * @see Vc3Class
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3Class
         */
        Builder vc3Class(String vc3Class);

        /**
         * Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the
         * settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine
         * your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97.
         * Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220
         * (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color
         * bit depth of your output.
         * 
         * @param vc3Class
         *        Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with
         *        the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and
         *        width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and
         *        your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of
         *        approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately
         *        220 Mbps. VC3 class also specifies the color bit depth of your output.
         * @see Vc3Class
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vc3Class
         */
        Builder vc3Class(Vc3Class vc3Class);
    }

    static final class BuilderImpl implements Builder {
        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String interlaceMode;

        private String scanTypeConversionMode;

        private String slowPal;

        private String telecine;

        private String vc3Class;

        private BuilderImpl() {
        }

        private BuilderImpl(Vc3Settings model) {
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            interlaceMode(model.interlaceMode);
            scanTypeConversionMode(model.scanTypeConversionMode);
            slowPal(model.slowPal);
            telecine(model.telecine);
            vc3Class(model.vc3Class);
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Vc3FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Vc3FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(Vc3InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getScanTypeConversionMode() {
            return scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(Vc3ScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(Vc3SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getTelecine() {
            return telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(Vc3Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getVc3Class() {
            return vc3Class;
        }

        @Override
        public final Builder vc3Class(String vc3Class) {
            this.vc3Class = vc3Class;
            return this;
        }

        @Override
        public final Builder vc3Class(Vc3Class vc3Class) {
            this.vc3Class(vc3Class == null ? null : vc3Class.toString());
            return this;
        }

        public final void setVc3Class(String vc3Class) {
            this.vc3Class = vc3Class;
        }

        @Override
        public Vc3Settings build() {
            return new Vc3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
