/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * WEBVTT Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebvttDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<WebvttDestinationSettings.Builder, WebvttDestinationSettings> {
    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StylePassthrough").getter(getter(WebvttDestinationSettings::stylePassthroughAsString))
            .setter(setter(Builder::stylePassthrough))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_PASSTHROUGH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stylePassthrough;

    private WebvttDestinationSettings(BuilderImpl builder) {
        this.stylePassthrough = builder.stylePassthrough;
    }

    /**
     * Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from the
     * captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link WebvttStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from
     *         the captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output
     *         captions.
     * @see WebvttStylePassthrough
     */
    public final WebvttStylePassthrough stylePassthrough() {
        return WebvttStylePassthrough.fromValue(stylePassthrough);
    }

    /**
     * Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from the
     * captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link WebvttStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from
     *         the captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output
     *         captions.
     * @see WebvttStylePassthrough
     */
    public final String stylePassthroughAsString() {
        return stylePassthrough;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stylePassthroughAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebvttDestinationSettings)) {
            return false;
        }
        WebvttDestinationSettings other = (WebvttDestinationSettings) obj;
        return Objects.equals(stylePassthroughAsString(), other.stylePassthroughAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebvttDestinationSettings").add("StylePassthrough", stylePassthroughAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StylePassthrough":
            return Optional.ofNullable(clazz.cast(stylePassthroughAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebvttDestinationSettings, T> g) {
        return obj -> g.apply((WebvttDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebvttDestinationSettings> {
        /**
         * Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from the
         * captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output captions.
         * 
         * @param stylePassthrough
         *        Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from
         *        the captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output
         *        captions.
         * @see WebvttStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebvttStylePassthrough
         */
        Builder stylePassthrough(String stylePassthrough);

        /**
         * Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from the
         * captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output captions.
         * 
         * @param stylePassthrough
         *        Choose Enabled (ENABLED) to have MediaConvert use the font style, color, and position information from
         *        the captions source in the input. Keep the default value, Disabled (DISABLED), for simplified output
         *        captions.
         * @see WebvttStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebvttStylePassthrough
         */
        Builder stylePassthrough(WebvttStylePassthrough stylePassthrough);
    }

    static final class BuilderImpl implements Builder {
        private String stylePassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(WebvttDestinationSettings model) {
            stylePassthrough(model.stylePassthrough);
        }

        public final String getStylePassthrough() {
            return stylePassthrough;
        }

        @Override
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        public final Builder stylePassthrough(WebvttStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        public WebvttDestinationSettings build() {
            return new WebvttDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
