/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Burn-in is a captions delivery method, rather than a captions format. Burn-in writes the captions directly on your
 * video frames, replacing pixels of video content with the captions. Set up burn-in captions in the same output as your
 * video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html.
 * When you work directly in your JSON job specification, include this object and any required children when you set
 * destinationType to BURN_IN.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BurninDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<BurninDestinationSettings.Builder, BurninDestinationSettings> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Alignment").getter(getter(BurninDestinationSettings::alignmentAsString))
            .setter(setter(Builder::alignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()).build();

    private static final SdkField<String> APPLY_FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplyFontColor").getter(getter(BurninDestinationSettings::applyFontColorAsString))
            .setter(setter(Builder::applyFontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyFontColor").build()).build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(BurninDestinationSettings::backgroundColorAsString))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundColor").build()).build();

    private static final SdkField<Integer> BACKGROUND_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackgroundOpacity").getter(getter(BurninDestinationSettings::backgroundOpacity))
            .setter(setter(Builder::backgroundOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundOpacity").build()).build();

    private static final SdkField<String> FALLBACK_FONT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackFont").getter(getter(BurninDestinationSettings::fallbackFontAsString))
            .setter(setter(Builder::fallbackFont))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackFont").build()).build();

    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontColor").getter(getter(BurninDestinationSettings::fontColorAsString))
            .setter(setter(Builder::fontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontColor").build()).build();

    private static final SdkField<Integer> FONT_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FontOpacity").getter(getter(BurninDestinationSettings::fontOpacity))
            .setter(setter(Builder::fontOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontOpacity").build()).build();

    private static final SdkField<Integer> FONT_RESOLUTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FontResolution").getter(getter(BurninDestinationSettings::fontResolution))
            .setter(setter(Builder::fontResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontResolution").build()).build();

    private static final SdkField<String> FONT_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontScript").getter(getter(BurninDestinationSettings::fontScriptAsString))
            .setter(setter(Builder::fontScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontScript").build()).build();

    private static final SdkField<Integer> FONT_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FontSize").getter(getter(BurninDestinationSettings::fontSize)).setter(setter(Builder::fontSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()).build();

    private static final SdkField<String> HEX_FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HexFontColor").getter(getter(BurninDestinationSettings::hexFontColor))
            .setter(setter(Builder::hexFontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hexFontColor").build()).build();

    private static final SdkField<String> OUTLINE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutlineColor").getter(getter(BurninDestinationSettings::outlineColorAsString))
            .setter(setter(Builder::outlineColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineColor").build()).build();

    private static final SdkField<Integer> OUTLINE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OutlineSize").getter(getter(BurninDestinationSettings::outlineSize))
            .setter(setter(Builder::outlineSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineSize").build()).build();

    private static final SdkField<String> SHADOW_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShadowColor").getter(getter(BurninDestinationSettings::shadowColorAsString))
            .setter(setter(Builder::shadowColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowColor").build()).build();

    private static final SdkField<Integer> SHADOW_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShadowOpacity").getter(getter(BurninDestinationSettings::shadowOpacity))
            .setter(setter(Builder::shadowOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowOpacity").build()).build();

    private static final SdkField<Integer> SHADOW_X_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShadowXOffset").getter(getter(BurninDestinationSettings::shadowXOffset))
            .setter(setter(Builder::shadowXOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowXOffset").build()).build();

    private static final SdkField<Integer> SHADOW_Y_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShadowYOffset").getter(getter(BurninDestinationSettings::shadowYOffset))
            .setter(setter(Builder::shadowYOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowYOffset").build()).build();

    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StylePassthrough").getter(getter(BurninDestinationSettings::stylePassthroughAsString))
            .setter(setter(Builder::stylePassthrough))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()).build();

    private static final SdkField<String> TELETEXT_SPACING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeletextSpacing").getter(getter(BurninDestinationSettings::teletextSpacingAsString))
            .setter(setter(Builder::teletextSpacing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSpacing").build()).build();

    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XPosition").getter(getter(BurninDestinationSettings::xPosition)).setter(setter(Builder::xPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()).build();

    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("YPosition").getter(getter(BurninDestinationSettings::yPosition)).setter(setter(Builder::yPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD,
            APPLY_FONT_COLOR_FIELD, BACKGROUND_COLOR_FIELD, BACKGROUND_OPACITY_FIELD, FALLBACK_FONT_FIELD, FONT_COLOR_FIELD,
            FONT_OPACITY_FIELD, FONT_RESOLUTION_FIELD, FONT_SCRIPT_FIELD, FONT_SIZE_FIELD, HEX_FONT_COLOR_FIELD,
            OUTLINE_COLOR_FIELD, OUTLINE_SIZE_FIELD, SHADOW_COLOR_FIELD, SHADOW_OPACITY_FIELD, SHADOW_X_OFFSET_FIELD,
            SHADOW_Y_OFFSET_FIELD, STYLE_PASSTHROUGH_FIELD, TELETEXT_SPACING_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alignment;

    private final String applyFontColor;

    private final String backgroundColor;

    private final Integer backgroundOpacity;

    private final String fallbackFont;

    private final String fontColor;

    private final Integer fontOpacity;

    private final Integer fontResolution;

    private final String fontScript;

    private final Integer fontSize;

    private final String hexFontColor;

    private final String outlineColor;

    private final Integer outlineSize;

    private final String shadowColor;

    private final Integer shadowOpacity;

    private final Integer shadowXOffset;

    private final Integer shadowYOffset;

    private final String stylePassthrough;

    private final String teletextSpacing;

    private final Integer xPosition;

    private final Integer yPosition;

    private BurninDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.applyFontColor = builder.applyFontColor;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.fallbackFont = builder.fallbackFont;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontScript = builder.fontScript;
        this.fontSize = builder.fontSize;
        this.hexFontColor = builder.hexFontColor;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.stylePassthrough = builder.stylePassthrough;
        this.teletextSpacing = builder.teletextSpacing;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    /**
     * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will
     * placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to
     * the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the
     * font will be justified (either left or centered) relative to those coordinates.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link BurninSubtitleAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alignmentAsString}.
     * </p>
     * 
     * @return Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to
     *         centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment
     *         willalign captions to the bottom left of the output. If x and y positions are given in conjunction with
     *         the alignment parameter, the font will be justified (either left or centered) relative to those
     *         coordinates.
     * @see BurninSubtitleAlignment
     */
    public final BurninSubtitleAlignment alignment() {
        return BurninSubtitleAlignment.fromValue(alignment);
    }

    /**
     * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will
     * placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to
     * the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the
     * font will be justified (either left or centered) relative to those coordinates.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link BurninSubtitleAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alignmentAsString}.
     * </p>
     * 
     * @return Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to
     *         centered will placethe captions at the bottom center of the output. Similarly, setting a left alignment
     *         willalign captions to the bottom left of the output. If x and y positions are given in conjunction with
     *         the alignment parameter, the font will be justified (either left or centered) relative to those
     *         coordinates.
     * @see BurninSubtitleAlignment
     */
    public final String alignmentAsString() {
        return alignment;
    }

    /**
     * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set
     * to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color
     * controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies
     * to white text in your input captions. For example, if your font color setting is Yellow, and your input captions
     * have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font
     * color setting applies to all of your output captions text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyFontColor}
     * will return {@link BurninSubtitleApplyFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #applyFontColorAsString}.
     * </p>
     * 
     * @return Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color
     *         (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for
     *         additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your
     *         font color setting only applies to white text in your input captions. For example, if your font color
     *         setting is Yellow, and your input captions have red and white text, your output captions will have red
     *         and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions
     *         text.
     * @see BurninSubtitleApplyFontColor
     */
    public final BurninSubtitleApplyFontColor applyFontColor() {
        return BurninSubtitleApplyFontColor.fromValue(applyFontColor);
    }

    /**
     * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set
     * to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color
     * controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies
     * to white text in your input captions. For example, if your font color setting is Yellow, and your input captions
     * have red and white text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font
     * color setting applies to all of your output captions text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyFontColor}
     * will return {@link BurninSubtitleApplyFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #applyFontColorAsString}.
     * </p>
     * 
     * @return Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color
     *         (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for
     *         additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your
     *         font color setting only applies to white text in your input captions. For example, if your font color
     *         setting is Yellow, and your input captions have red and white text, your output captions will have red
     *         and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your output captions
     *         text.
     * @see BurninSubtitleApplyFontColor
     */
    public final String applyFontColorAsString() {
        return applyFontColor;
    }

    /**
     * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set
     * Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if
     * present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backgroundColor}
     * will return {@link BurninSubtitleBackgroundColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #backgroundColorAsString}.
     * </p>
     * 
     * @return Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank
     *         and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input
     *         captions, if present.
     * @see BurninSubtitleBackgroundColor
     */
    public final BurninSubtitleBackgroundColor backgroundColor() {
        return BurninSubtitleBackgroundColor.fromValue(backgroundColor);
    }

    /**
     * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and set
     * Style passthrough (StylePassthrough) to enabled to use the background color data from your input captions, if
     * present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backgroundColor}
     * will return {@link BurninSubtitleBackgroundColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #backgroundColorAsString}.
     * </p>
     * 
     * @return Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank
     *         and set Style passthrough (StylePassthrough) to enabled to use the background color data from your input
     *         captions, if present.
     * @see BurninSubtitleBackgroundColor
     */
    public final String backgroundColorAsString() {
        return backgroundColor;
    }

    /**
     * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255 is
     * opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the background
     * style information in your input captions to your output captions. If Style passthrough is set to disabled, leave
     * blank to use a value of 0 and remove all backgrounds from your output captions.
     * 
     * @return Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and
     *         255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the
     *         background style information in your input captions to your output captions. If Style passthrough is set
     *         to disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions.
     */
    public final Integer backgroundOpacity() {
        return backgroundOpacity;
    }

    /**
     * Specify the font that you want the service to use for your burn in captions when your input captions specify a
     * font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or
     * leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions
     * specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with
     * the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font
     * to replace all unsupported fonts from your input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackFont} will
     * return {@link BurninSubtitleFallbackFont#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fallbackFontAsString}.
     * </p>
     * 
     * @return Specify the font that you want the service to use for your burn in captions when your input captions
     *         specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match
     *         (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that
     *         your input captions specify. When there are multiple unsupported fonts in your input captions,
     *         MediaConvert matches each font with the supported font that matches best. When you explicitly choose a
     *         replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
     * @see BurninSubtitleFallbackFont
     */
    public final BurninSubtitleFallbackFont fallbackFont() {
        return BurninSubtitleFallbackFont.fromValue(fallbackFont);
    }

    /**
     * Specify the font that you want the service to use for your burn in captions when your input captions specify a
     * font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match (BEST_MATCH), or
     * leave blank, MediaConvert uses a supported font that most closely matches the font that your input captions
     * specify. When there are multiple unsupported fonts in your input captions, MediaConvert matches each font with
     * the supported font that matches best. When you explicitly choose a replacement font, MediaConvert uses that font
     * to replace all unsupported fonts from your input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackFont} will
     * return {@link BurninSubtitleFallbackFont#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fallbackFontAsString}.
     * </p>
     * 
     * @return Specify the font that you want the service to use for your burn in captions when your input captions
     *         specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match
     *         (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that
     *         your input captions specify. When there are multiple unsupported fonts in your input captions,
     *         MediaConvert matches each font with the supported font that matches best. When you explicitly choose a
     *         replacement font, MediaConvert uses that font to replace all unsupported fonts from your input.
     * @see BurninSubtitleFallbackFont
     */
    public final String fallbackFontAsString() {
        return fallbackFont;
    }

    /**
     * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style passthrough
     * (StylePassthrough) to enabled to use the font color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontColor} will
     * return {@link BurninSubtitleFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontColorAsString}.
     * </p>
     * 
     * @return Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
     *         passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if
     *         present.
     * @see BurninSubtitleFontColor
     */
    public final BurninSubtitleFontColor fontColor() {
        return BurninSubtitleFontColor.fromValue(fontColor);
    }

    /**
     * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style passthrough
     * (StylePassthrough) to enabled to use the font color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontColor} will
     * return {@link BurninSubtitleFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontColorAsString}.
     * </p>
     * 
     * @return Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
     *         passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if
     *         present.
     * @see BurninSubtitleFontColor
     */
    public final String fontColorAsString() {
        return fontColor;
    }

    /**
     * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
     * 
     * @return Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
     */
    public final Integer fontOpacity() {
        return fontOpacity;
    }

    /**
     * Specify the Font resolution (FontResolution) in DPI (dots per inch).
     * 
     * @return Specify the Font resolution (FontResolution) in DPI (dots per inch).
     */
    public final Integer fontResolution() {
        return fontResolution;
    }

    /**
     * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine
     * the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT)
     * if your input font script uses Simplified or Traditional Chinese.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontScript} will
     * return {@link FontScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fontScriptAsString}.
     * </p>
     * 
     * @return Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
     *         determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or
     *         Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
     * @see FontScript
     */
    public final FontScript fontScript() {
        return FontScript.fromValue(fontScript);
    }

    /**
     * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically determine
     * the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional Chinese (HANT)
     * if your input font script uses Simplified or Traditional Chinese.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontScript} will
     * return {@link FontScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fontScriptAsString}.
     * </p>
     * 
     * @return Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
     *         determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or
     *         Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
     * @see FontScript
     */
    public final String fontScriptAsString() {
        return fontScript;
    }

    /**
     * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for automatic
     * font size.
     * 
     * @return Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for
     *         automatic font size.
     */
    public final Integer fontSize() {
        return fontSize;
    }

    /**
     * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits,
     * representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB is a
     * red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
     * 
     * @return Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits,
     *         representing red, green, and blue, with two optional extra digits for alpha. For example a value of
     *         1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
     */
    public final String hexFontColor() {
        return hexFontColor;
    }

    /**
     * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough)
     * to enabled to use the font outline color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlineColor} will
     * return {@link BurninSubtitleOutlineColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outlineColorAsString}.
     * </p>
     * 
     * @return Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
     *         (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
     * @see BurninSubtitleOutlineColor
     */
    public final BurninSubtitleOutlineColor outlineColor() {
        return BurninSubtitleOutlineColor.fromValue(outlineColor);
    }

    /**
     * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough (StylePassthrough)
     * to enabled to use the font outline color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlineColor} will
     * return {@link BurninSubtitleOutlineColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outlineColorAsString}.
     * </p>
     * 
     * @return Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
     *         (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
     * @see BurninSubtitleOutlineColor
     */
    public final String outlineColorAsString() {
        return outlineColor;
    }

    /**
     * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style
     * passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present.
     * 
     * @return Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set
     *         Style passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if
     *         present.
     */
    public final Integer outlineSize() {
        return outlineSize;
    }

    /**
     * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style
     * passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shadowColor} will
     * return {@link BurninSubtitleShadowColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #shadowColorAsString}.
     * </p>
     * 
     * @return Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set
     *         Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if
     *         present.
     * @see BurninSubtitleShadowColor
     */
    public final BurninSubtitleShadowColor shadowColor() {
        return BurninSubtitleShadowColor.fromValue(shadowColor);
    }

    /**
     * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style
     * passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shadowColor} will
     * return {@link BurninSubtitleShadowColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #shadowColorAsString}.
     * </p>
     * 
     * @return Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set
     *         Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if
     *         present.
     * @see BurninSubtitleShadowColor
     */
    public final String shadowColorAsString() {
        return shadowColor;
    }

    /**
     * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If
     * Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass
     * through the shadow style information in your input captions to your output captions. If Style passthrough is set
     * to disabled, leave blank to use a value of 0 and remove all shadows from your output captions.
     * 
     * @return Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque.
     *         If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to
     *         pass through the shadow style information in your input captions to your output captions. If Style
     *         passthrough is set to disabled, leave blank to use a value of 0 and remove all shadows from your output
     *         captions.
     */
    public final Integer shadowOpacity() {
        return shadowOpacity;
    }

    /**
     * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result in a
     * shadow offset 2 pixels to the left.
     * 
     * @return Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would
     *         result in a shadow offset 2 pixels to the left.
     */
    public final Integer shadowXOffset() {
        return shadowXOffset;
    }

    /**
     * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a
     * shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough
     * (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present.
     * 
     * @return Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result
     *         in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style
     *         passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if
     *         present.
     */
    public final Integer shadowYOffset() {
        return shadowYOffset;
    }

    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information
     * from your input captions. MediaConvert uses default settings for any missing style and position information in
     * your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position
     * information from your input captions and use default settings: white text with black outlining, bottom-center
     * positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to
     * manually override any of the individual style and position settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link BurnInSubtitleStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
     *         information from your input captions. MediaConvert uses default settings for any missing style and
     *         position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore
     *         the style and position information from your input captions and use default settings: white text with
     *         black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to
     *         enabled or not, you can also choose to manually override any of the individual style and position
     *         settings.
     * @see BurnInSubtitleStylePassthrough
     */
    public final BurnInSubtitleStylePassthrough stylePassthrough() {
        return BurnInSubtitleStylePassthrough.fromValue(stylePassthrough);
    }

    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information
     * from your input captions. MediaConvert uses default settings for any missing style and position information in
     * your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position
     * information from your input captions and use default settings: white text with black outlining, bottom-center
     * positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to
     * manually override any of the individual style and position settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link BurnInSubtitleStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
     *         information from your input captions. MediaConvert uses default settings for any missing style and
     *         position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore
     *         the style and position information from your input captions and use default settings: white text with
     *         black outlining, bottom-center positioning, and automatic sizing. Whether you set Style passthrough to
     *         enabled or not, you can also choose to manually override any of the individual style and position
     *         settings.
     * @see BurnInSubtitleStylePassthrough
     */
    public final String stylePassthroughAsString() {
        return stylePassthrough;
    }

    /**
     * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies
     * depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions
     * file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #teletextSpacing}
     * will return {@link BurninSubtitleTeletextSpacing#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #teletextSpacingAsString}.
     * </p>
     * 
     * @return Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or
     *         varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in
     *         the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for
     *         closed captions.
     * @see BurninSubtitleTeletextSpacing
     */
    public final BurninSubtitleTeletextSpacing teletextSpacing() {
        return BurninSubtitleTeletextSpacing.fromValue(teletextSpacing);
    }

    /**
     * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies
     * depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions
     * file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #teletextSpacing}
     * will return {@link BurninSubtitleTeletextSpacing#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #teletextSpacingAsString}.
     * </p>
     * 
     * @return Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or
     *         varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in
     *         the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for
     *         closed captions.
     * @see BurninSubtitleTeletextSpacing
     */
    public final String teletextSpacingAsString() {
        return teletextSpacing;
    }

    /**
     * Specify the horizontal position (XPosition) of the captions, relative to the left side of the output in pixels. A
     * value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit
     * x_position is provided, the horizontal caption position will be determined by the alignment parameter.
     * 
     * @return Specify the horizontal position (XPosition) of the captions, relative to the left side of the output in
     *         pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no
     *         explicit x_position is provided, the horizontal caption position will be determined by the alignment
     *         parameter.
     */
    public final Integer xPosition() {
        return xPosition;
    }

    /**
     * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A value
     * of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is
     * provided, the caption will be positioned towards the bottom of the output.
     * 
     * @return Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A
     *         value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit
     *         y_position is provided, the caption will be positioned towards the bottom of the output.
     */
    public final Integer yPosition() {
        return yPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyFontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackFontAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(fontScriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(hexFontColor());
        hashCode = 31 * hashCode + Objects.hashCode(outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(stylePassthroughAsString());
        hashCode = 31 * hashCode + Objects.hashCode(teletextSpacingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(yPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurninDestinationSettings)) {
            return false;
        }
        BurninDestinationSettings other = (BurninDestinationSettings) obj;
        return Objects.equals(alignmentAsString(), other.alignmentAsString())
                && Objects.equals(applyFontColorAsString(), other.applyFontColorAsString())
                && Objects.equals(backgroundColorAsString(), other.backgroundColorAsString())
                && Objects.equals(backgroundOpacity(), other.backgroundOpacity())
                && Objects.equals(fallbackFontAsString(), other.fallbackFontAsString())
                && Objects.equals(fontColorAsString(), other.fontColorAsString())
                && Objects.equals(fontOpacity(), other.fontOpacity()) && Objects.equals(fontResolution(), other.fontResolution())
                && Objects.equals(fontScriptAsString(), other.fontScriptAsString())
                && Objects.equals(fontSize(), other.fontSize()) && Objects.equals(hexFontColor(), other.hexFontColor())
                && Objects.equals(outlineColorAsString(), other.outlineColorAsString())
                && Objects.equals(outlineSize(), other.outlineSize())
                && Objects.equals(shadowColorAsString(), other.shadowColorAsString())
                && Objects.equals(shadowOpacity(), other.shadowOpacity())
                && Objects.equals(shadowXOffset(), other.shadowXOffset())
                && Objects.equals(shadowYOffset(), other.shadowYOffset())
                && Objects.equals(stylePassthroughAsString(), other.stylePassthroughAsString())
                && Objects.equals(teletextSpacingAsString(), other.teletextSpacingAsString())
                && Objects.equals(xPosition(), other.xPosition()) && Objects.equals(yPosition(), other.yPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BurninDestinationSettings").add("Alignment", alignmentAsString())
                .add("ApplyFontColor", applyFontColorAsString()).add("BackgroundColor", backgroundColorAsString())
                .add("BackgroundOpacity", backgroundOpacity()).add("FallbackFont", fallbackFontAsString())
                .add("FontColor", fontColorAsString()).add("FontOpacity", fontOpacity()).add("FontResolution", fontResolution())
                .add("FontScript", fontScriptAsString()).add("FontSize", fontSize()).add("HexFontColor", hexFontColor())
                .add("OutlineColor", outlineColorAsString()).add("OutlineSize", outlineSize())
                .add("ShadowColor", shadowColorAsString()).add("ShadowOpacity", shadowOpacity())
                .add("ShadowXOffset", shadowXOffset()).add("ShadowYOffset", shadowYOffset())
                .add("StylePassthrough", stylePassthroughAsString()).add("TeletextSpacing", teletextSpacingAsString())
                .add("XPosition", xPosition()).add("YPosition", yPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alignment":
            return Optional.ofNullable(clazz.cast(alignmentAsString()));
        case "ApplyFontColor":
            return Optional.ofNullable(clazz.cast(applyFontColorAsString()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColorAsString()));
        case "BackgroundOpacity":
            return Optional.ofNullable(clazz.cast(backgroundOpacity()));
        case "FallbackFont":
            return Optional.ofNullable(clazz.cast(fallbackFontAsString()));
        case "FontColor":
            return Optional.ofNullable(clazz.cast(fontColorAsString()));
        case "FontOpacity":
            return Optional.ofNullable(clazz.cast(fontOpacity()));
        case "FontResolution":
            return Optional.ofNullable(clazz.cast(fontResolution()));
        case "FontScript":
            return Optional.ofNullable(clazz.cast(fontScriptAsString()));
        case "FontSize":
            return Optional.ofNullable(clazz.cast(fontSize()));
        case "HexFontColor":
            return Optional.ofNullable(clazz.cast(hexFontColor()));
        case "OutlineColor":
            return Optional.ofNullable(clazz.cast(outlineColorAsString()));
        case "OutlineSize":
            return Optional.ofNullable(clazz.cast(outlineSize()));
        case "ShadowColor":
            return Optional.ofNullable(clazz.cast(shadowColorAsString()));
        case "ShadowOpacity":
            return Optional.ofNullable(clazz.cast(shadowOpacity()));
        case "ShadowXOffset":
            return Optional.ofNullable(clazz.cast(shadowXOffset()));
        case "ShadowYOffset":
            return Optional.ofNullable(clazz.cast(shadowYOffset()));
        case "StylePassthrough":
            return Optional.ofNullable(clazz.cast(stylePassthroughAsString()));
        case "TeletextSpacing":
            return Optional.ofNullable(clazz.cast(teletextSpacingAsString()));
        case "XPosition":
            return Optional.ofNullable(clazz.cast(xPosition()));
        case "YPosition":
            return Optional.ofNullable(clazz.cast(yPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BurninDestinationSettings, T> g) {
        return obj -> g.apply((BurninDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BurninDestinationSettings> {
        /**
         * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered
         * will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign
         * captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment
         * parameter, the font will be justified (either left or centered) relative to those coordinates.
         * 
         * @param alignment
         *        Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to
         *        centered will placethe captions at the bottom center of the output. Similarly, setting a left
         *        alignment willalign captions to the bottom left of the output. If x and y positions are given in
         *        conjunction with the alignment parameter, the font will be justified (either left or centered)
         *        relative to those coordinates.
         * @see BurninSubtitleAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleAlignment
         */
        Builder alignment(String alignment);

        /**
         * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered
         * will placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign
         * captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment
         * parameter, the font will be justified (either left or centered) relative to those coordinates.
         * 
         * @param alignment
         *        Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to
         *        centered will placethe captions at the bottom center of the output. Similarly, setting a left
         *        alignment willalign captions to the bottom left of the output. If x and y positions are given in
         *        conjunction with the alignment parameter, the font will be justified (either left or centered)
         *        relative to those coordinates.
         * @see BurninSubtitleAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleAlignment
         */
        Builder alignment(BurninSubtitleAlignment alignment);

        /**
         * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor)
         * set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font
         * color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting
         * only applies to white text in your input captions. For example, if your font color setting is Yellow, and
         * your input captions have red and white text, your output captions will have red and yellow text. When you
         * choose ALL_TEXT, your font color setting applies to all of your output captions text.
         * 
         * @param applyFontColor
         *        Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color
         *        (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for
         *        additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank,
         *        your font color setting only applies to white text in your input captions. For example, if your font
         *        color setting is Yellow, and your input captions have red and white text, your output captions will
         *        have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your
         *        output captions text.
         * @see BurninSubtitleApplyFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleApplyFontColor
         */
        Builder applyFontColor(String applyFontColor);

        /**
         * Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color (FontColor)
         * set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font
         * color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting
         * only applies to white text in your input captions. For example, if your font color setting is Yellow, and
         * your input captions have red and white text, your output captions will have red and yellow text. When you
         * choose ALL_TEXT, your font color setting applies to all of your output captions text.
         * 
         * @param applyFontColor
         *        Ignore this setting unless Style passthrough (StylePassthrough) is set to Enabled and Font color
         *        (FontColor) set to Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for
         *        additional font color controls. When you choose White text only (WHITE_TEXT_ONLY), or leave blank,
         *        your font color setting only applies to white text in your input captions. For example, if your font
         *        color setting is Yellow, and your input captions have red and white text, your output captions will
         *        have red and yellow text. When you choose ALL_TEXT, your font color setting applies to all of your
         *        output captions text.
         * @see BurninSubtitleApplyFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleApplyFontColor
         */
        Builder applyFontColor(BurninSubtitleApplyFontColor applyFontColor);

        /**
         * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and
         * set Style passthrough (StylePassthrough) to enabled to use the background color data from your input
         * captions, if present.
         * 
         * @param backgroundColor
         *        Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank
         *        and set Style passthrough (StylePassthrough) to enabled to use the background color data from your
         *        input captions, if present.
         * @see BurninSubtitleBackgroundColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleBackgroundColor
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank and
         * set Style passthrough (StylePassthrough) to enabled to use the background color data from your input
         * captions, if present.
         * 
         * @param backgroundColor
         *        Specify the color of the rectangle behind the captions. Leave background color (BackgroundColor) blank
         *        and set Style passthrough (StylePassthrough) to enabled to use the background color data from your
         *        input captions, if present.
         * @see BurninSubtitleBackgroundColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleBackgroundColor
         */
        Builder backgroundColor(BurninSubtitleBackgroundColor backgroundColor);

        /**
         * Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent and 255
         * is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass through the
         * background style information in your input captions to your output captions. If Style passthrough is set to
         * disabled, leave blank to use a value of 0 and remove all backgrounds from your output captions.
         * 
         * @param backgroundOpacity
         *        Specify the opacity of the background rectangle. Enter a value from 0 to 255, where 0 is transparent
         *        and 255 is opaque. If Style passthrough (StylePassthrough) is set to enabled, leave blank to pass
         *        through the background style information in your input captions to your output captions. If Style
         *        passthrough is set to disabled, leave blank to use a value of 0 and remove all backgrounds from your
         *        output captions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundOpacity(Integer backgroundOpacity);

        /**
         * Specify the font that you want the service to use for your burn in captions when your input captions specify
         * a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match
         * (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your
         * input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert
         * matches each font with the supported font that matches best. When you explicitly choose a replacement font,
         * MediaConvert uses that font to replace all unsupported fonts from your input.
         * 
         * @param fallbackFont
         *        Specify the font that you want the service to use for your burn in captions when your input captions
         *        specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best
         *        match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the
         *        font that your input captions specify. When there are multiple unsupported fonts in your input
         *        captions, MediaConvert matches each font with the supported font that matches best. When you
         *        explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts
         *        from your input.
         * @see BurninSubtitleFallbackFont
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleFallbackFont
         */
        Builder fallbackFont(String fallbackFont);

        /**
         * Specify the font that you want the service to use for your burn in captions when your input captions specify
         * a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best match
         * (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the font that your
         * input captions specify. When there are multiple unsupported fonts in your input captions, MediaConvert
         * matches each font with the supported font that matches best. When you explicitly choose a replacement font,
         * MediaConvert uses that font to replace all unsupported fonts from your input.
         * 
         * @param fallbackFont
         *        Specify the font that you want the service to use for your burn in captions when your input captions
         *        specify a font that MediaConvert doesn't support. When you set Fallback font (FallbackFont) to best
         *        match (BEST_MATCH), or leave blank, MediaConvert uses a supported font that most closely matches the
         *        font that your input captions specify. When there are multiple unsupported fonts in your input
         *        captions, MediaConvert matches each font with the supported font that matches best. When you
         *        explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts
         *        from your input.
         * @see BurninSubtitleFallbackFont
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleFallbackFont
         */
        Builder fallbackFont(BurninSubtitleFallbackFont fallbackFont);

        /**
         * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
         * passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present.
         * 
         * @param fontColor
         *        Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
         *        passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if
         *        present.
         * @see BurninSubtitleFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleFontColor
         */
        Builder fontColor(String fontColor);

        /**
         * Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
         * passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if present.
         * 
         * @param fontColor
         *        Specify the color of the burned-in captions text. Leave Font color (FontColor) blank and set Style
         *        passthrough (StylePassthrough) to enabled to use the font color data from your input captions, if
         *        present.
         * @see BurninSubtitleFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleFontColor
         */
        Builder fontColor(BurninSubtitleFontColor fontColor);

        /**
         * Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
         * 
         * @param fontOpacity
         *        Specify the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontOpacity(Integer fontOpacity);

        /**
         * Specify the Font resolution (FontResolution) in DPI (dots per inch).
         * 
         * @param fontResolution
         *        Specify the Font resolution (FontResolution) in DPI (dots per inch).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontResolution(Integer fontResolution);

        /**
         * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
         * determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional
         * Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
         * 
         * @param fontScript
         *        Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
         *        determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or
         *        Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
         * @see FontScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontScript
         */
        Builder fontScript(String fontScript);

        /**
         * Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
         * determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or Traditional
         * Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
         * 
         * @param fontScript
         *        Set Font script (FontScript) to Automatically determined (AUTOMATIC), or leave blank, to automatically
         *        determine the font script in your input captions. Otherwise, set to Simplified Chinese (HANS) or
         *        Traditional Chinese (HANT) if your input font script uses Simplified or Traditional Chinese.
         * @see FontScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontScript
         */
        Builder fontScript(FontScript fontScript);

        /**
         * Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for
         * automatic font size.
         * 
         * @param fontSize
         *        Specify the Font size (FontSize) in pixels. Must be a positive integer. Set to 0, or leave blank, for
         *        automatic font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontSize(Integer fontSize);

        /**
         * Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal digits,
         * representing red, green, and blue, with two optional extra digits for alpha. For example a value of 1122AABB
         * is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha value of 0xBB.
         * 
         * @param hexFontColor
         *        Ignore this setting unless your Font color is set to Hex. Enter either six or eight hexidecimal
         *        digits, representing red, green, and blue, with two optional extra digits for alpha. For example a
         *        value of 1122AABB is a red value of 0x11, a green value of 0x22, a blue value of 0xAA, and an alpha
         *        value of 0xBB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hexFontColor(String hexFontColor);

        /**
         * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
         * (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
         * 
         * @param outlineColor
         *        Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
         *        (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
         * @see BurninSubtitleOutlineColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleOutlineColor
         */
        Builder outlineColor(String outlineColor);

        /**
         * Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
         * (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
         * 
         * @param outlineColor
         *        Specify font outline color. Leave Outline color (OutlineColor) blank and set Style passthrough
         *        (StylePassthrough) to enabled to use the font outline color data from your input captions, if present.
         * @see BurninSubtitleOutlineColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleOutlineColor
         */
        Builder outlineColor(BurninSubtitleOutlineColor outlineColor);

        /**
         * Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and set Style
         * passthrough (StylePassthrough) to enabled to use the outline size data from your input captions, if present.
         * 
         * @param outlineSize
         *        Specify the Outline size (OutlineSize) of the caption text, in pixels. Leave Outline size blank and
         *        set Style passthrough (StylePassthrough) to enabled to use the outline size data from your input
         *        captions, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outlineSize(Integer outlineSize);

        /**
         * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style
         * passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
         * 
         * @param shadowColor
         *        Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set
         *        Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions,
         *        if present.
         * @see BurninSubtitleShadowColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleShadowColor
         */
        Builder shadowColor(String shadowColor);

        /**
         * Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set Style
         * passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions, if present.
         * 
         * @param shadowColor
         *        Specify the color of the shadow cast by the captions. Leave Shadow color (ShadowColor) blank and set
         *        Style passthrough (StylePassthrough) to enabled to use the shadow color data from your input captions,
         *        if present.
         * @see BurninSubtitleShadowColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleShadowColor
         */
        Builder shadowColor(BurninSubtitleShadowColor shadowColor);

        /**
         * Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is opaque. If
         * Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity (ShadowOpacity) blank to pass
         * through the shadow style information in your input captions to your output captions. If Style passthrough is
         * set to disabled, leave blank to use a value of 0 and remove all shadows from your output captions.
         * 
         * @param shadowOpacity
         *        Specify the opacity of the shadow. Enter a value from 0 to 255, where 0 is transparent and 255 is
         *        opaque. If Style passthrough (StylePassthrough) is set to Enabled, leave Shadow opacity
         *        (ShadowOpacity) blank to pass through the shadow style information in your input captions to your
         *        output captions. If Style passthrough is set to disabled, leave blank to use a value of 0 and remove
         *        all shadows from your output captions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowOpacity(Integer shadowOpacity);

        /**
         * Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would result
         * in a shadow offset 2 pixels to the left.
         * 
         * @param shadowXOffset
         *        Specify the horizontal offset of the shadow, relative to the captions in pixels. A value of -2 would
         *        result in a shadow offset 2 pixels to the left.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowXOffset(Integer shadowXOffset);

        /**
         * Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a
         * shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set Style passthrough
         * (StylePassthrough) to enabled to use the shadow y-offset data from your input captions, if present.
         * 
         * @param shadowYOffset
         *        Specify the vertical offset of the shadow relative to the captions in pixels. A value of -2 would
         *        result in a shadow offset 2 pixels above the text. Leave Shadow y-offset (ShadowYOffset) blank and set
         *        Style passthrough (StylePassthrough) to enabled to use the shadow y-offset data from your input
         *        captions, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowYOffset(Integer shadowYOffset);

        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         * information from your input captions. MediaConvert uses default settings for any missing style and position
         * information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style
         * and position information from your input captions and use default settings: white text with black outlining,
         * bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can
         * also choose to manually override any of the individual style and position settings.
         * 
         * @param stylePassthrough
         *        Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         *        information from your input captions. MediaConvert uses default settings for any missing style and
         *        position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to
         *        ignore the style and position information from your input captions and use default settings: white
         *        text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style
         *        passthrough to enabled or not, you can also choose to manually override any of the individual style
         *        and position settings.
         * @see BurnInSubtitleStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurnInSubtitleStylePassthrough
         */
        Builder stylePassthrough(String stylePassthrough);

        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         * information from your input captions. MediaConvert uses default settings for any missing style and position
         * information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style
         * and position information from your input captions and use default settings: white text with black outlining,
         * bottom-center positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can
         * also choose to manually override any of the individual style and position settings.
         * 
         * @param stylePassthrough
         *        Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         *        information from your input captions. MediaConvert uses default settings for any missing style and
         *        position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to
         *        ignore the style and position information from your input captions and use default settings: white
         *        text with black outlining, bottom-center positioning, and automatic sizing. Whether you set Style
         *        passthrough to enabled or not, you can also choose to manually override any of the individual style
         *        and position settings.
         * @see BurnInSubtitleStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurnInSubtitleStylePassthrough
         */
        Builder stylePassthrough(BurnInSubtitleStylePassthrough stylePassthrough);

        /**
         * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies
         * depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions
         * file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
         * 
         * @param teletextSpacing
         *        Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or
         *        varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified
         *        in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to
         *        read for closed captions.
         * @see BurninSubtitleTeletextSpacing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleTeletextSpacing
         */
        Builder teletextSpacing(String teletextSpacing);

        /**
         * Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or varies
         * depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified in the captions
         * file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to read for closed captions.
         * 
         * @param teletextSpacing
         *        Specify whether the text spacing (TeletextSpacing) in your captions is set by the captions grid, or
         *        varies depending on letter width. Choose fixed grid (FIXED_GRID) to conform to the spacing specified
         *        in the captions file more accurately. Choose proportional (PROPORTIONAL) to make the text easier to
         *        read for closed captions.
         * @see BurninSubtitleTeletextSpacing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BurninSubtitleTeletextSpacing
         */
        Builder teletextSpacing(BurninSubtitleTeletextSpacing teletextSpacing);

        /**
         * Specify the horizontal position (XPosition) of the captions, relative to the left side of the output in
         * pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no
         * explicit x_position is provided, the horizontal caption position will be determined by the alignment
         * parameter.
         * 
         * @param xPosition
         *        Specify the horizontal position (XPosition) of the captions, relative to the left side of the output
         *        in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output.
         *        If no explicit x_position is provided, the horizontal caption position will be determined by the
         *        alignment parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xPosition(Integer xPosition);

        /**
         * Specify the vertical position (YPosition) of the captions, relative to the top of the output in pixels. A
         * value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit
         * y_position is provided, the caption will be positioned towards the bottom of the output.
         * 
         * @param yPosition
         *        Specify the vertical position (YPosition) of the captions, relative to the top of the output in
         *        pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If
         *        no explicit y_position is provided, the caption will be positioned towards the bottom of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yPosition(Integer yPosition);
    }

    static final class BuilderImpl implements Builder {
        private String alignment;

        private String applyFontColor;

        private String backgroundColor;

        private Integer backgroundOpacity;

        private String fallbackFont;

        private String fontColor;

        private Integer fontOpacity;

        private Integer fontResolution;

        private String fontScript;

        private Integer fontSize;

        private String hexFontColor;

        private String outlineColor;

        private Integer outlineSize;

        private String shadowColor;

        private Integer shadowOpacity;

        private Integer shadowXOffset;

        private Integer shadowYOffset;

        private String stylePassthrough;

        private String teletextSpacing;

        private Integer xPosition;

        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(BurninDestinationSettings model) {
            alignment(model.alignment);
            applyFontColor(model.applyFontColor);
            backgroundColor(model.backgroundColor);
            backgroundOpacity(model.backgroundOpacity);
            fallbackFont(model.fallbackFont);
            fontColor(model.fontColor);
            fontOpacity(model.fontOpacity);
            fontResolution(model.fontResolution);
            fontScript(model.fontScript);
            fontSize(model.fontSize);
            hexFontColor(model.hexFontColor);
            outlineColor(model.outlineColor);
            outlineSize(model.outlineSize);
            shadowColor(model.shadowColor);
            shadowOpacity(model.shadowOpacity);
            shadowXOffset(model.shadowXOffset);
            shadowYOffset(model.shadowYOffset);
            stylePassthrough(model.stylePassthrough);
            teletextSpacing(model.teletextSpacing);
            xPosition(model.xPosition);
            yPosition(model.yPosition);
        }

        public final String getAlignment() {
            return alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(BurninSubtitleAlignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final String getApplyFontColor() {
            return applyFontColor;
        }

        public final void setApplyFontColor(String applyFontColor) {
            this.applyFontColor = applyFontColor;
        }

        @Override
        public final Builder applyFontColor(String applyFontColor) {
            this.applyFontColor = applyFontColor;
            return this;
        }

        @Override
        public final Builder applyFontColor(BurninSubtitleApplyFontColor applyFontColor) {
            this.applyFontColor(applyFontColor == null ? null : applyFontColor.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(BurninSubtitleBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor == null ? null : backgroundColor.toString());
            return this;
        }

        public final Integer getBackgroundOpacity() {
            return backgroundOpacity;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final String getFallbackFont() {
            return fallbackFont;
        }

        public final void setFallbackFont(String fallbackFont) {
            this.fallbackFont = fallbackFont;
        }

        @Override
        public final Builder fallbackFont(String fallbackFont) {
            this.fallbackFont = fallbackFont;
            return this;
        }

        @Override
        public final Builder fallbackFont(BurninSubtitleFallbackFont fallbackFont) {
            this.fallbackFont(fallbackFont == null ? null : fallbackFont.toString());
            return this;
        }

        public final String getFontColor() {
            return fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(BurninSubtitleFontColor fontColor) {
            this.fontColor(fontColor == null ? null : fontColor.toString());
            return this;
        }

        public final Integer getFontOpacity() {
            return fontOpacity;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final Integer getFontResolution() {
            return fontResolution;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final String getFontScript() {
            return fontScript;
        }

        public final void setFontScript(String fontScript) {
            this.fontScript = fontScript;
        }

        @Override
        public final Builder fontScript(String fontScript) {
            this.fontScript = fontScript;
            return this;
        }

        @Override
        public final Builder fontScript(FontScript fontScript) {
            this.fontScript(fontScript == null ? null : fontScript.toString());
            return this;
        }

        public final Integer getFontSize() {
            return fontSize;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final String getHexFontColor() {
            return hexFontColor;
        }

        public final void setHexFontColor(String hexFontColor) {
            this.hexFontColor = hexFontColor;
        }

        @Override
        public final Builder hexFontColor(String hexFontColor) {
            this.hexFontColor = hexFontColor;
            return this;
        }

        public final String getOutlineColor() {
            return outlineColor;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(BurninSubtitleOutlineColor outlineColor) {
            this.outlineColor(outlineColor == null ? null : outlineColor.toString());
            return this;
        }

        public final Integer getOutlineSize() {
            return outlineSize;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final String getShadowColor() {
            return shadowColor;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(BurninSubtitleShadowColor shadowColor) {
            this.shadowColor(shadowColor == null ? null : shadowColor.toString());
            return this;
        }

        public final Integer getShadowOpacity() {
            return shadowOpacity;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final Integer getShadowXOffset() {
            return shadowXOffset;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final Integer getShadowYOffset() {
            return shadowYOffset;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final String getStylePassthrough() {
            return stylePassthrough;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        public final Builder stylePassthrough(BurnInSubtitleStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        public final String getTeletextSpacing() {
            return teletextSpacing;
        }

        public final void setTeletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
        }

        @Override
        public final Builder teletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
            return this;
        }

        @Override
        public final Builder teletextSpacing(BurninSubtitleTeletextSpacing teletextSpacing) {
            this.teletextSpacing(teletextSpacing == null ? null : teletextSpacing.toString());
            return this;
        }

        public final Integer getXPosition() {
            return xPosition;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final Integer getYPosition() {
            return yPosition;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        @Override
        public BurninDestinationSettings build() {
            return new BurninDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
