/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. When you don't specify a
 * value, MediaConvert labels your track as Center (C) by default. To use Audio layout tagging, your output must be in a
 * QuickTime (MOV) container and your audio codec must be AAC, WAV, or AIFF.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioChannelTaggingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioChannelTaggingSettings.Builder, AudioChannelTaggingSettings> {
    private static final SdkField<String> CHANNEL_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelTag").getter(getter(AudioChannelTaggingSettings::channelTagAsString))
            .setter(setter(Builder::channelTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelTag").build()).build();

    private static final SdkField<List<String>> CHANNEL_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChannelTags")
            .getter(getter(AudioChannelTaggingSettings::channelTagsAsStrings))
            .setter(setter(Builder::channelTagsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TAG_FIELD,
            CHANNEL_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelTag;

    private final List<String> channelTags;

    private AudioChannelTaggingSettings(BuilderImpl builder) {
        this.channelTag = builder.channelTag;
        this.channelTags = builder.channelTags;
    }

    /**
     * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel layout
     * tags in the same order as your output's audio channel order. For example, if your output audio track has a left
     * and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your output has
     * multiple single-channel audio tracks, enter a single channel layout tag for each track.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelTag} will
     * return {@link AudioChannelTag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTagAsString}.
     * </p>
     * 
     * @return Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
     *         layout tags in the same order as your output's audio channel order. For example, if your output audio
     *         track has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second.
     *         If your output has multiple single-channel audio tracks, enter a single channel layout tag for each
     *         track.
     * @see AudioChannelTag
     */
    public final AudioChannelTag channelTag() {
        return AudioChannelTag.fromValue(channelTag);
    }

    /**
     * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel layout
     * tags in the same order as your output's audio channel order. For example, if your output audio track has a left
     * and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your output has
     * multiple single-channel audio tracks, enter a single channel layout tag for each track.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelTag} will
     * return {@link AudioChannelTag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTagAsString}.
     * </p>
     * 
     * @return Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
     *         layout tags in the same order as your output's audio channel order. For example, if your output audio
     *         track has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second.
     *         If your output has multiple single-channel audio tracks, enter a single channel layout tag for each
     *         track.
     * @see AudioChannelTag
     */
    public final String channelTagAsString() {
        return channelTag;
    }

    /**
     * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel layout
     * tags in the same order as your output's audio channel order. For example, if your output audio track has a left
     * and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your output has
     * multiple single-channel audio tracks, enter a single channel layout tag for each track.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelTags} method.
     * </p>
     * 
     * @return Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
     *         layout tags in the same order as your output's audio channel order. For example, if your output audio
     *         track has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second.
     *         If your output has multiple single-channel audio tracks, enter a single channel layout tag for each
     *         track.
     */
    public final List<AudioChannelTag> channelTags() {
        return ___listOfAudioChannelTagCopier.copyStringToEnum(channelTags);
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelTags() {
        return channelTags != null && !(channelTags instanceof SdkAutoConstructList);
    }

    /**
     * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel layout
     * tags in the same order as your output's audio channel order. For example, if your output audio track has a left
     * and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your output has
     * multiple single-channel audio tracks, enter a single channel layout tag for each track.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelTags} method.
     * </p>
     * 
     * @return Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
     *         layout tags in the same order as your output's audio channel order. For example, if your output audio
     *         track has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second.
     *         If your output has multiple single-channel audio tracks, enter a single channel layout tag for each
     *         track.
     */
    public final List<String> channelTagsAsStrings() {
        return channelTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelTagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelTags() ? channelTagsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelTaggingSettings)) {
            return false;
        }
        AudioChannelTaggingSettings other = (AudioChannelTaggingSettings) obj;
        return Objects.equals(channelTagAsString(), other.channelTagAsString()) && hasChannelTags() == other.hasChannelTags()
                && Objects.equals(channelTagsAsStrings(), other.channelTagsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioChannelTaggingSettings").add("ChannelTag", channelTagAsString())
                .add("ChannelTags", hasChannelTags() ? channelTagsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelTag":
            return Optional.ofNullable(clazz.cast(channelTagAsString()));
        case "ChannelTags":
            return Optional.ofNullable(clazz.cast(channelTagsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioChannelTaggingSettings, T> g) {
        return obj -> g.apply((AudioChannelTaggingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioChannelTaggingSettings> {
        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTag
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @see AudioChannelTag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelTag
         */
        Builder channelTag(String channelTag);

        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTag
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @see AudioChannelTag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelTag
         */
        Builder channelTag(AudioChannelTag channelTag);

        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTags
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelTagsWithStrings(Collection<String> channelTags);

        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTags
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelTagsWithStrings(String... channelTags);

        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTags
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelTags(Collection<AudioChannelTag> channelTags);

        /**
         * Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter channel
         * layout tags in the same order as your output's audio channel order. For example, if your output audio track
         * has a left and a right channel, enter Left (L) for the first channel and Right (R) for the second. If your
         * output has multiple single-channel audio tracks, enter a single channel layout tag for each track.
         * 
         * @param channelTags
         *        Specify the QuickTime audio channel layout tags for the audio channels in this audio track. Enter
         *        channel layout tags in the same order as your output's audio channel order. For example, if your
         *        output audio track has a left and a right channel, enter Left (L) for the first channel and Right (R)
         *        for the second. If your output has multiple single-channel audio tracks, enter a single channel layout
         *        tag for each track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelTags(AudioChannelTag... channelTags);
    }

    static final class BuilderImpl implements Builder {
        private String channelTag;

        private List<String> channelTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelTaggingSettings model) {
            channelTag(model.channelTag);
            channelTagsWithStrings(model.channelTags);
        }

        public final String getChannelTag() {
            return channelTag;
        }

        public final void setChannelTag(String channelTag) {
            this.channelTag = channelTag;
        }

        @Override
        public final Builder channelTag(String channelTag) {
            this.channelTag = channelTag;
            return this;
        }

        @Override
        public final Builder channelTag(AudioChannelTag channelTag) {
            this.channelTag(channelTag == null ? null : channelTag.toString());
            return this;
        }

        public final Collection<String> getChannelTags() {
            if (channelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return channelTags;
        }

        public final void setChannelTags(Collection<String> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copy(channelTags);
        }

        @Override
        public final Builder channelTagsWithStrings(Collection<String> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copy(channelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelTagsWithStrings(String... channelTags) {
            channelTagsWithStrings(Arrays.asList(channelTags));
            return this;
        }

        @Override
        public final Builder channelTags(Collection<AudioChannelTag> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copyEnumToString(channelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelTags(AudioChannelTag... channelTags) {
            channelTags(Arrays.asList(channelTags));
            return this;
        }

        @Override
        public AudioChannelTaggingSettings build() {
            return new AudioChannelTaggingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
