/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Note that
 * your choice of video output container constrains your choice of output captions format. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using SCTE-20 and you
 * want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded. To create a non-compliant
 * output where the embedded captions come first, choose Embedded plus SCTE-20.
 */
@Generated("software.amazon.awssdk:codegen")
public enum CaptionDestinationType {
    BURN_IN("BURN_IN"),

    DVB_SUB("DVB_SUB"),

    EMBEDDED("EMBEDDED"),

    EMBEDDED_PLUS_SCTE20("EMBEDDED_PLUS_SCTE20"),

    IMSC("IMSC"),

    SCTE20_PLUS_EMBEDDED("SCTE20_PLUS_EMBEDDED"),

    SCC("SCC"),

    SRT("SRT"),

    SMI("SMI"),

    TELETEXT("TELETEXT"),

    TTML("TTML"),

    WEBVTT("WEBVTT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CaptionDestinationType> VALUE_MAP = EnumUtils.uniqueIndex(CaptionDestinationType.class,
            CaptionDestinationType::toString);

    private final String value;

    private CaptionDestinationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CaptionDestinationType corresponding to the value
     */
    public static CaptionDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CaptionDestinationType}s
     */
    public static Set<CaptionDestinationType> knownValues() {
        Set<CaptionDestinationType> knownValues = EnumSet.allOf(CaptionDestinationType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
