/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * If your input video has accurate color space metadata, or if you don't know about color space: Keep the default
 * value, Follow. MediaConvert will automatically detect your input color space. If your input video has metadata
 * indicating the wrong color space, or has missing metadata: Specify the accurate color space here. If your input video
 * is HDR 10 and the SMPTE ST 2086 Mastering Display Color Volume static metadata isn't present in your video stream, or
 * if that metadata is present but not accurate: Choose Force HDR 10. Specify correct values in the input HDR 10
 * metadata settings. For more information about HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
 * When you specify an input color space, MediaConvert uses the following color space metadata, which includes color
 * primaries, transfer characteristics, and matrix coefficients: * HDR 10: BT.2020, PQ, BT.2020 non-constant * HLG 2020:
 * BT.2020, HLG, BT.2020 non-constant * P3DCI (Theater): DCIP3, SMPTE 428M, BT.709 * P3D65 (SDR): Display P3, sRGB,
 * BT.709 * P3D65 (HDR): Display P3, PQ, BT.709
 */
@Generated("software.amazon.awssdk:codegen")
public enum ColorSpace {
    FOLLOW("FOLLOW"),

    REC_601("REC_601"),

    REC_709("REC_709"),

    HDR10("HDR10"),

    HLG_2020("HLG_2020"),

    P3_DCI("P3DCI"),

    P3_D65_SDR("P3D65_SDR"),

    P3_D65_HDR("P3D65_HDR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColorSpace> VALUE_MAP = EnumUtils.uniqueIndex(ColorSpace.class, ColorSpace::toString);

    private final String value;

    private ColorSpace(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ColorSpace corresponding to the value
     */
    public static ColorSpace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ColorSpace}s
     */
    public static Set<ColorSpace> knownValues() {
        Set<ColorSpace> knownValues = EnumSet.allOf(ColorSpace.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
