/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * JobSettings contains all the transcode settings for a job.
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSettings implements SdkPojo, Serializable, ToCopyableBuilder<JobSettings.Builder, JobSettings> {
    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdAvailOffset").getter(getter(JobSettings::adAvailOffset)).setter(setter(Builder::adAvailOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()).build();

    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField
            .<AvailBlanking> builder(MarshallingType.SDK_POJO).memberName("AvailBlanking")
            .getter(getter(JobSettings::availBlanking)).setter(setter(Builder::availBlanking))
            .constructor(AvailBlanking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()).build();

    private static final SdkField<EsamSettings> ESAM_FIELD = SdkField.<EsamSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Esam").getter(getter(JobSettings::esam)).setter(setter(Builder::esam))
            .constructor(EsamSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esam").build()).build();

    private static final SdkField<ExtendedDataServices> EXTENDED_DATA_SERVICES_FIELD = SdkField
            .<ExtendedDataServices> builder(MarshallingType.SDK_POJO).memberName("ExtendedDataServices")
            .getter(getter(JobSettings::extendedDataServices)).setter(setter(Builder::extendedDataServices))
            .constructor(ExtendedDataServices::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendedDataServices").build())
            .build();

    private static final SdkField<Integer> FOLLOW_SOURCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FollowSource").getter(getter(JobSettings::followSource)).setter(setter(Builder::followSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followSource").build()).build();

    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField
            .<List<Input>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(JobSettings::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Input> builder(MarshallingType.SDK_POJO)
                                            .constructor(Input::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KantarWatermarkSettings> KANTAR_WATERMARK_FIELD = SdkField
            .<KantarWatermarkSettings> builder(MarshallingType.SDK_POJO).memberName("KantarWatermark")
            .getter(getter(JobSettings::kantarWatermark)).setter(setter(Builder::kantarWatermark))
            .constructor(KantarWatermarkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kantarWatermark").build()).build();

    private static final SdkField<MotionImageInserter> MOTION_IMAGE_INSERTER_FIELD = SdkField
            .<MotionImageInserter> builder(MarshallingType.SDK_POJO).memberName("MotionImageInserter")
            .getter(getter(JobSettings::motionImageInserter)).setter(setter(Builder::motionImageInserter))
            .constructor(MotionImageInserter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionImageInserter").build())
            .build();

    private static final SdkField<NielsenConfiguration> NIELSEN_CONFIGURATION_FIELD = SdkField
            .<NielsenConfiguration> builder(MarshallingType.SDK_POJO).memberName("NielsenConfiguration")
            .getter(getter(JobSettings::nielsenConfiguration)).setter(setter(Builder::nielsenConfiguration))
            .constructor(NielsenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenConfiguration").build())
            .build();

    private static final SdkField<NielsenNonLinearWatermarkSettings> NIELSEN_NON_LINEAR_WATERMARK_FIELD = SdkField
            .<NielsenNonLinearWatermarkSettings> builder(MarshallingType.SDK_POJO).memberName("NielsenNonLinearWatermark")
            .getter(getter(JobSettings::nielsenNonLinearWatermark)).setter(setter(Builder::nielsenNonLinearWatermark))
            .constructor(NielsenNonLinearWatermarkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenNonLinearWatermark").build())
            .build();

    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField
            .<List<OutputGroup>> builder(MarshallingType.LIST)
            .memberName("OutputGroups")
            .getter(getter(JobSettings::outputGroups))
            .setter(setter(Builder::outputGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField
            .<TimecodeConfig> builder(MarshallingType.SDK_POJO).memberName("TimecodeConfig")
            .getter(getter(JobSettings::timecodeConfig)).setter(setter(Builder::timecodeConfig))
            .constructor(TimecodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()).build();

    private static final SdkField<TimedMetadataInsertion> TIMED_METADATA_INSERTION_FIELD = SdkField
            .<TimedMetadataInsertion> builder(MarshallingType.SDK_POJO).memberName("TimedMetadataInsertion")
            .getter(getter(JobSettings::timedMetadataInsertion)).setter(setter(Builder::timedMetadataInsertion))
            .constructor(TimedMetadataInsertion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataInsertion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_AVAIL_OFFSET_FIELD,
            AVAIL_BLANKING_FIELD, ESAM_FIELD, EXTENDED_DATA_SERVICES_FIELD, FOLLOW_SOURCE_FIELD, INPUTS_FIELD,
            KANTAR_WATERMARK_FIELD, MOTION_IMAGE_INSERTER_FIELD, NIELSEN_CONFIGURATION_FIELD, NIELSEN_NON_LINEAR_WATERMARK_FIELD,
            OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, TIMED_METADATA_INSERTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer adAvailOffset;

    private final AvailBlanking availBlanking;

    private final EsamSettings esam;

    private final ExtendedDataServices extendedDataServices;

    private final Integer followSource;

    private final List<Input> inputs;

    private final KantarWatermarkSettings kantarWatermark;

    private final MotionImageInserter motionImageInserter;

    private final NielsenConfiguration nielsenConfiguration;

    private final NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark;

    private final List<OutputGroup> outputGroups;

    private final TimecodeConfig timecodeConfig;

    private final TimedMetadataInsertion timedMetadataInsertion;

    private JobSettings(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.availBlanking = builder.availBlanking;
        this.esam = builder.esam;
        this.extendedDataServices = builder.extendedDataServices;
        this.followSource = builder.followSource;
        this.inputs = builder.inputs;
        this.kantarWatermark = builder.kantarWatermark;
        this.motionImageInserter = builder.motionImageInserter;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.nielsenNonLinearWatermark = builder.nielsenNonLinearWatermark;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.timedMetadataInsertion = builder.timedMetadataInsertion;
    }

    /**
     * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
     * 
     * @return When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
     */
    public final Integer adAvailOffset() {
        return adAvailOffset;
    }

    /**
     * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during SCTE-35
     * triggered ad avails.
     * 
     * @return Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
     *         SCTE-35 triggered ad avails.
     */
    public final AvailBlanking availBlanking() {
        return availBlanking;
    }

    /**
     * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these settings.
     * 
     * @return Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these
     *         settings.
     */
    public final EsamSettings esam() {
        return esam;
    }

    /**
     * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert does
     * with the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove them from
     * the output. For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h Content Advisory.
     * 
     * @return If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what
     *         MediaConvert does with the Extended Data Services (XDS) packets. You can choose to pass through XDS
     *         packets, or remove them from the output. For more information about XDS, see EIA-608 Line Data Services,
     *         section 9.5.1.5 05h Content Advisory.
     */
    public final ExtendedDataServices extendedDataServices() {
        return extendedDataServices;
    }

    /**
     * Specify the input that MediaConvert references for your default output settings. MediaConvert uses this input's
     * Resolution, Frame rate, and Pixel aspect ratio for all outputs that you don't manually specify different output
     * settings for. Enabling this setting will disable "Follow source" for all other inputs. If MediaConvert cannot
     * follow your source, for example if you specify an audio-only input, MediaConvert uses the first followable input
     * instead. In your JSON job specification, enter an integer from 1 to 150 corresponding to the order of your
     * inputs.
     * 
     * @return Specify the input that MediaConvert references for your default output settings. MediaConvert uses this
     *         input's Resolution, Frame rate, and Pixel aspect ratio for all outputs that you don't manually specify
     *         different output settings for. Enabling this setting will disable "Follow source" for all other inputs.
     *         If MediaConvert cannot follow your source, for example if you specify an audio-only input, MediaConvert
     *         uses the first followable input instead. In your JSON job specification, enter an integer from 1 to 150
     *         corresponding to the order of your inputs.
     */
    public final Integer followSource() {
        return followSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job. These
     * inputs will be concantenated together to create the output.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job.
     *         These inputs will be concantenated together to create the output.
     */
    public final List<Input> inputs() {
        return inputs;
    }

    /**
     * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to generate
     * and place Kantar watermarks in your output audio. These settings apply to every output in your job. In addition
     * to specifying these values, you also need to store your Kantar credentials in AWS Secrets Manager. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
     * 
     * @return Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to
     *         generate and place Kantar watermarks in your output audio. These settings apply to every output in your
     *         job. In addition to specifying these values, you also need to store your Kantar credentials in AWS
     *         Secrets Manager. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
     */
    public final KantarWatermarkSettings kantarWatermark() {
        return kantarWatermark;
    }

    /**
     * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in
     * all output groups. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
     * 
     * @return Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all
     *         outputs in all output groups. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
     */
    public final MotionImageInserter motionImageInserter() {
        return motionImageInserter;
    }

    /**
     * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
     * settings. When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all outputs in the
     * job.
     * 
     * @return Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
     *         settings. When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all outputs
     *         in the job.
     */
    public final NielsenConfiguration nielsenConfiguration() {
        return nielsenConfiguration;
    }

    /**
     * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that MediaConvert
     * uses to generate and place Nielsen watermarks in your output audio. In addition to specifying these values, you
     * also need to set up your cloud TIC server. These settings apply to every output in your job. The MediaConvert
     * implementation is currently with the following Nielsen versions: Nielsen Watermark SDK Version 5.2.1 Nielsen NLM
     * Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator [SID_TIC] Version [5.0.0]
     * 
     * @return Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that
     *         MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to
     *         specifying these values, you also need to set up your cloud TIC server. These settings apply to every
     *         output in your job. The MediaConvert implementation is currently with the following Nielsen versions:
     *         Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark
     *         Authenticator [SID_TIC] Version [5.0.0]
     */
    public final NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark() {
        return nielsenNonLinearWatermark;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputGroups() {
        return outputGroups != null && !(outputGroups instanceof SdkAutoConstructList);
    }

    /**
     * Contains one group of settings for each set of outputs that share a common package type. All unpackaged files
     * (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required in
     * is a group of settings that apply to the whole group. This required object depends on the value you set for Type.
     * Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS,
     * HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS,
     * MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputGroups} method.
     * </p>
     * 
     * @return Contains one group of settings for each set of outputs that share a common package type. All unpackaged
     *         files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well.
     *         Required in is a group of settings that apply to the whole group. This required object depends on the
     *         value you set for Type. Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS,
     *         FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings
     *         * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
     */
    public final List<OutputGroup> outputGroups() {
        return outputGroups;
    }

    /**
     * These settings control how the service handles timecodes throughout the job. These settings don't affect input
     * clipping.
     * 
     * @return These settings control how the service handles timecodes throughout the job. These settings don't affect
     *         input clipping.
     */
    public final TimecodeConfig timecodeConfig() {
        return timecodeConfig;
    }

    /**
     * Insert user-defined custom ID3 metadata at timecodes that you specify. In each output that you want to include
     * this metadata, you must set ID3 metadata to Passthrough.
     * 
     * @return Insert user-defined custom ID3 metadata at timecodes that you specify. In each output that you want to
     *         include this metadata, you must set ID3 metadata to Passthrough.
     */
    public final TimedMetadataInsertion timedMetadataInsertion() {
        return timedMetadataInsertion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(esam());
        hashCode = 31 * hashCode + Objects.hashCode(extendedDataServices());
        hashCode = 31 * hashCode + Objects.hashCode(followSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kantarWatermark());
        hashCode = 31 * hashCode + Objects.hashCode(motionImageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenNonLinearWatermark());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputGroups() ? outputGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataInsertion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSettings)) {
            return false;
        }
        JobSettings other = (JobSettings) obj;
        return Objects.equals(adAvailOffset(), other.adAvailOffset()) && Objects.equals(availBlanking(), other.availBlanking())
                && Objects.equals(esam(), other.esam()) && Objects.equals(extendedDataServices(), other.extendedDataServices())
                && Objects.equals(followSource(), other.followSource()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(kantarWatermark(), other.kantarWatermark())
                && Objects.equals(motionImageInserter(), other.motionImageInserter())
                && Objects.equals(nielsenConfiguration(), other.nielsenConfiguration())
                && Objects.equals(nielsenNonLinearWatermark(), other.nielsenNonLinearWatermark())
                && hasOutputGroups() == other.hasOutputGroups() && Objects.equals(outputGroups(), other.outputGroups())
                && Objects.equals(timecodeConfig(), other.timecodeConfig())
                && Objects.equals(timedMetadataInsertion(), other.timedMetadataInsertion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSettings").add("AdAvailOffset", adAvailOffset()).add("AvailBlanking", availBlanking())
                .add("Esam", esam()).add("ExtendedDataServices", extendedDataServices()).add("FollowSource", followSource())
                .add("Inputs", hasInputs() ? inputs() : null).add("KantarWatermark", kantarWatermark())
                .add("MotionImageInserter", motionImageInserter()).add("NielsenConfiguration", nielsenConfiguration())
                .add("NielsenNonLinearWatermark", nielsenNonLinearWatermark())
                .add("OutputGroups", hasOutputGroups() ? outputGroups() : null).add("TimecodeConfig", timecodeConfig())
                .add("TimedMetadataInsertion", timedMetadataInsertion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdAvailOffset":
            return Optional.ofNullable(clazz.cast(adAvailOffset()));
        case "AvailBlanking":
            return Optional.ofNullable(clazz.cast(availBlanking()));
        case "Esam":
            return Optional.ofNullable(clazz.cast(esam()));
        case "ExtendedDataServices":
            return Optional.ofNullable(clazz.cast(extendedDataServices()));
        case "FollowSource":
            return Optional.ofNullable(clazz.cast(followSource()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "KantarWatermark":
            return Optional.ofNullable(clazz.cast(kantarWatermark()));
        case "MotionImageInserter":
            return Optional.ofNullable(clazz.cast(motionImageInserter()));
        case "NielsenConfiguration":
            return Optional.ofNullable(clazz.cast(nielsenConfiguration()));
        case "NielsenNonLinearWatermark":
            return Optional.ofNullable(clazz.cast(nielsenNonLinearWatermark()));
        case "OutputGroups":
            return Optional.ofNullable(clazz.cast(outputGroups()));
        case "TimecodeConfig":
            return Optional.ofNullable(clazz.cast(timecodeConfig()));
        case "TimedMetadataInsertion":
            return Optional.ofNullable(clazz.cast(timedMetadataInsertion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSettings, T> g) {
        return obj -> g.apply((JobSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSettings> {
        /**
         * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
         * 
         * @param adAvailOffset
         *        When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adAvailOffset(Integer adAvailOffset);

        /**
         * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         * SCTE-35 triggered ad avails.
         * 
         * @param availBlanking
         *        Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         *        SCTE-35 triggered ad avails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availBlanking(AvailBlanking availBlanking);

        /**
         * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         * SCTE-35 triggered ad avails. This is a convenience method that creates an instance of the
         * {@link AvailBlanking.Builder} avoiding the need to create one manually via {@link AvailBlanking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailBlanking.Builder#build()} is called immediately and its
         * result is passed to {@link #availBlanking(AvailBlanking)}.
         * 
         * @param availBlanking
         *        a consumer that will call methods on {@link AvailBlanking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availBlanking(AvailBlanking)
         */
        default Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return availBlanking(AvailBlanking.builder().applyMutation(availBlanking).build());
        }

        /**
         * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these
         * settings.
         * 
         * @param esam
         *        Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder esam(EsamSettings esam);

        /**
         * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these
         * settings. This is a convenience method that creates an instance of the {@link EsamSettings.Builder} avoiding
         * the need to create one manually via {@link EsamSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EsamSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #esam(EsamSettings)}.
         * 
         * @param esam
         *        a consumer that will call methods on {@link EsamSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #esam(EsamSettings)
         */
        default Builder esam(Consumer<EsamSettings.Builder> esam) {
            return esam(EsamSettings.builder().applyMutation(esam).build());
        }

        /**
         * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert
         * does with the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove
         * them from the output. For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h
         * Content Advisory.
         * 
         * @param extendedDataServices
         *        If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what
         *        MediaConvert does with the Extended Data Services (XDS) packets. You can choose to pass through XDS
         *        packets, or remove them from the output. For more information about XDS, see EIA-608 Line Data
         *        Services, section 9.5.1.5 05h Content Advisory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedDataServices(ExtendedDataServices extendedDataServices);

        /**
         * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert
         * does with the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove
         * them from the output. For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h
         * Content Advisory. This is a convenience method that creates an instance of the
         * {@link ExtendedDataServices.Builder} avoiding the need to create one manually via
         * {@link ExtendedDataServices#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtendedDataServices.Builder#build()} is called immediately and
         * its result is passed to {@link #extendedDataServices(ExtendedDataServices)}.
         * 
         * @param extendedDataServices
         *        a consumer that will call methods on {@link ExtendedDataServices.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedDataServices(ExtendedDataServices)
         */
        default Builder extendedDataServices(Consumer<ExtendedDataServices.Builder> extendedDataServices) {
            return extendedDataServices(ExtendedDataServices.builder().applyMutation(extendedDataServices).build());
        }

        /**
         * Specify the input that MediaConvert references for your default output settings. MediaConvert uses this
         * input's Resolution, Frame rate, and Pixel aspect ratio for all outputs that you don't manually specify
         * different output settings for. Enabling this setting will disable "Follow source" for all other inputs. If
         * MediaConvert cannot follow your source, for example if you specify an audio-only input, MediaConvert uses the
         * first followable input instead. In your JSON job specification, enter an integer from 1 to 150 corresponding
         * to the order of your inputs.
         * 
         * @param followSource
         *        Specify the input that MediaConvert references for your default output settings. MediaConvert uses
         *        this input's Resolution, Frame rate, and Pixel aspect ratio for all outputs that you don't manually
         *        specify different output settings for. Enabling this setting will disable "Follow source" for all
         *        other inputs. If MediaConvert cannot follow your source, for example if you specify an audio-only
         *        input, MediaConvert uses the first followable input instead. In your JSON job specification, enter an
         *        integer from 1 to 150 corresponding to the order of your inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followSource(Integer followSource);

        /**
         * Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job. These
         * inputs will be concantenated together to create the output.
         * 
         * @param inputs
         *        Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job.
         *        These inputs will be concantenated together to create the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job. These
         * inputs will be concantenated together to create the output.
         * 
         * @param inputs
         *        Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job.
         *        These inputs will be concantenated together to create the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * Use Inputs to define source file used in the transcode job. There can be multiple inputs add in a job. These
         * inputs will be concantenated together to create the output. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.mediaconvert.model.Input.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconvert.model.Input#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.Input.Builder#build()} is called immediately and
         * its result is passed to {@link #inputs(List<Input>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<Input>)
         */
        Builder inputs(Consumer<Input.Builder>... inputs);

        /**
         * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to
         * generate and place Kantar watermarks in your output audio. These settings apply to every output in your job.
         * In addition to specifying these values, you also need to store your Kantar credentials in AWS Secrets
         * Manager. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
         * 
         * @param kantarWatermark
         *        Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to
         *        generate and place Kantar watermarks in your output audio. These settings apply to every output in
         *        your job. In addition to specifying these values, you also need to store your Kantar credentials in
         *        AWS Secrets Manager. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kantarWatermark(KantarWatermarkSettings kantarWatermark);

        /**
         * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to
         * generate and place Kantar watermarks in your output audio. These settings apply to every output in your job.
         * In addition to specifying these values, you also need to store your Kantar credentials in AWS Secrets
         * Manager. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html. This is a convenience method
         * that creates an instance of the {@link KantarWatermarkSettings.Builder} avoiding the need to create one
         * manually via {@link KantarWatermarkSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KantarWatermarkSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #kantarWatermark(KantarWatermarkSettings)}.
         * 
         * @param kantarWatermark
         *        a consumer that will call methods on {@link KantarWatermarkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kantarWatermark(KantarWatermarkSettings)
         */
        default Builder kantarWatermark(Consumer<KantarWatermarkSettings.Builder> kantarWatermark) {
            return kantarWatermark(KantarWatermarkSettings.builder().applyMutation(kantarWatermark).build());
        }

        /**
         * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs
         * in all output groups. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
         * 
         * @param motionImageInserter
         *        Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all
         *        outputs in all output groups. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionImageInserter(MotionImageInserter motionImageInserter);

        /**
         * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs
         * in all output groups. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html. This is a convenience method
         * that creates an instance of the {@link MotionImageInserter.Builder} avoiding the need to create one manually
         * via {@link MotionImageInserter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MotionImageInserter.Builder#build()} is called immediately and
         * its result is passed to {@link #motionImageInserter(MotionImageInserter)}.
         * 
         * @param motionImageInserter
         *        a consumer that will call methods on {@link MotionImageInserter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionImageInserter(MotionImageInserter)
         */
        default Builder motionImageInserter(Consumer<MotionImageInserter.Builder> motionImageInserter) {
            return motionImageInserter(MotionImageInserter.builder().applyMutation(motionImageInserter).build());
        }

        /**
         * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
         * settings. When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all outputs in
         * the job.
         * 
         * @param nielsenConfiguration
         *        Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore
         *        these settings. When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all
         *        outputs in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration);

        /**
         * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
         * settings. When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all outputs in
         * the job. This is a convenience method that creates an instance of the {@link NielsenConfiguration.Builder}
         * avoiding the need to create one manually via {@link NielsenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NielsenConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #nielsenConfiguration(NielsenConfiguration)}.
         * 
         * @param nielsenConfiguration
         *        a consumer that will call methods on {@link NielsenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenConfiguration(NielsenConfiguration)
         */
        default Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return nielsenConfiguration(NielsenConfiguration.builder().applyMutation(nielsenConfiguration).build());
        }

        /**
         * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that
         * MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to specifying
         * these values, you also need to set up your cloud TIC server. These settings apply to every output in your
         * job. The MediaConvert implementation is currently with the following Nielsen versions: Nielsen Watermark SDK
         * Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator [SID_TIC] Version
         * [5.0.0]
         * 
         * @param nielsenNonLinearWatermark
         *        Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that
         *        MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to
         *        specifying these values, you also need to set up your cloud TIC server. These settings apply to every
         *        output in your job. The MediaConvert implementation is currently with the following Nielsen versions:
         *        Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark
         *        Authenticator [SID_TIC] Version [5.0.0]
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark);

        /**
         * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that
         * MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to specifying
         * these values, you also need to set up your cloud TIC server. These settings apply to every output in your
         * job. The MediaConvert implementation is currently with the following Nielsen versions: Nielsen Watermark SDK
         * Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator [SID_TIC] Version
         * [5.0.0] This is a convenience method that creates an instance of the
         * {@link NielsenNonLinearWatermarkSettings.Builder} avoiding the need to create one manually via
         * {@link NielsenNonLinearWatermarkSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NielsenNonLinearWatermarkSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings)}.
         * 
         * @param nielsenNonLinearWatermark
         *        a consumer that will call methods on {@link NielsenNonLinearWatermarkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings)
         */
        default Builder nielsenNonLinearWatermark(Consumer<NielsenNonLinearWatermarkSettings.Builder> nielsenNonLinearWatermark) {
            return nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings.builder().applyMutation(nielsenNonLinearWatermark)
                    .build());
        }

        /**
         * Contains one group of settings for each set of outputs that share a common package type. All unpackaged files
         * (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required
         * in is a group of settings that apply to the whole group. This required object depends on the value you set
         * for Type. Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings *
         * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings *
         * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
         * 
         * @param outputGroups
         *        Contains one group of settings for each set of outputs that share a common package type. All
         *        unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output
         *        group as well. Required in is a group of settings that apply to the whole group. This required object
         *        depends on the value you set for Type. Type, settings object pairs are as follows. *
         *        FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings *
         *        DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         *        CMAF_GROUP_SETTINGS, CmafGroupSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(Collection<OutputGroup> outputGroups);

        /**
         * Contains one group of settings for each set of outputs that share a common package type. All unpackaged files
         * (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required
         * in is a group of settings that apply to the whole group. This required object depends on the value you set
         * for Type. Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings *
         * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings *
         * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
         * 
         * @param outputGroups
         *        Contains one group of settings for each set of outputs that share a common package type. All
         *        unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output
         *        group as well. Required in is a group of settings that apply to the whole group. This required object
         *        depends on the value you set for Type. Type, settings object pairs are as follows. *
         *        FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings *
         *        DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         *        CMAF_GROUP_SETTINGS, CmafGroupSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(OutputGroup... outputGroups);

        /**
         * Contains one group of settings for each set of outputs that share a common package type. All unpackaged files
         * (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required
         * in is a group of settings that apply to the whole group. This required object depends on the value you set
         * for Type. Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings *
         * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings *
         * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.OutputGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconvert.model.OutputGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.OutputGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #outputGroups(List<OutputGroup>)}.
         * 
         * @param outputGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.OutputGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroups(java.util.Collection<OutputGroup>)
         */
        Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups);

        /**
         * These settings control how the service handles timecodes throughout the job. These settings don't affect
         * input clipping.
         * 
         * @param timecodeConfig
         *        These settings control how the service handles timecodes throughout the job. These settings don't
         *        affect input clipping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeConfig(TimecodeConfig timecodeConfig);

        /**
         * These settings control how the service handles timecodes throughout the job. These settings don't affect
         * input clipping. This is a convenience method that creates an instance of the {@link TimecodeConfig.Builder}
         * avoiding the need to create one manually via {@link TimecodeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timecodeConfig(TimecodeConfig)}.
         * 
         * @param timecodeConfig
         *        a consumer that will call methods on {@link TimecodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeConfig(TimecodeConfig)
         */
        default Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return timecodeConfig(TimecodeConfig.builder().applyMutation(timecodeConfig).build());
        }

        /**
         * Insert user-defined custom ID3 metadata at timecodes that you specify. In each output that you want to
         * include this metadata, you must set ID3 metadata to Passthrough.
         * 
         * @param timedMetadataInsertion
         *        Insert user-defined custom ID3 metadata at timecodes that you specify. In each output that you want to
         *        include this metadata, you must set ID3 metadata to Passthrough.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion);

        /**
         * Insert user-defined custom ID3 metadata at timecodes that you specify. In each output that you want to
         * include this metadata, you must set ID3 metadata to Passthrough. This is a convenience method that creates an
         * instance of the {@link TimedMetadataInsertion.Builder} avoiding the need to create one manually via
         * {@link TimedMetadataInsertion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimedMetadataInsertion.Builder#build()} is called immediately and
         * its result is passed to {@link #timedMetadataInsertion(TimedMetadataInsertion)}.
         * 
         * @param timedMetadataInsertion
         *        a consumer that will call methods on {@link TimedMetadataInsertion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timedMetadataInsertion(TimedMetadataInsertion)
         */
        default Builder timedMetadataInsertion(Consumer<TimedMetadataInsertion.Builder> timedMetadataInsertion) {
            return timedMetadataInsertion(TimedMetadataInsertion.builder().applyMutation(timedMetadataInsertion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer adAvailOffset;

        private AvailBlanking availBlanking;

        private EsamSettings esam;

        private ExtendedDataServices extendedDataServices;

        private Integer followSource;

        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();

        private KantarWatermarkSettings kantarWatermark;

        private MotionImageInserter motionImageInserter;

        private NielsenConfiguration nielsenConfiguration;

        private NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark;

        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();

        private TimecodeConfig timecodeConfig;

        private TimedMetadataInsertion timedMetadataInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSettings model) {
            adAvailOffset(model.adAvailOffset);
            availBlanking(model.availBlanking);
            esam(model.esam);
            extendedDataServices(model.extendedDataServices);
            followSource(model.followSource);
            inputs(model.inputs);
            kantarWatermark(model.kantarWatermark);
            motionImageInserter(model.motionImageInserter);
            nielsenConfiguration(model.nielsenConfiguration);
            nielsenNonLinearWatermark(model.nielsenNonLinearWatermark);
            outputGroups(model.outputGroups);
            timecodeConfig(model.timecodeConfig);
            timedMetadataInsertion(model.timedMetadataInsertion);
        }

        public final Integer getAdAvailOffset() {
            return adAvailOffset;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return availBlanking != null ? availBlanking.toBuilder() : null;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final EsamSettings.Builder getEsam() {
            return esam != null ? esam.toBuilder() : null;
        }

        public final void setEsam(EsamSettings.BuilderImpl esam) {
            this.esam = esam != null ? esam.build() : null;
        }

        @Override
        public final Builder esam(EsamSettings esam) {
            this.esam = esam;
            return this;
        }

        public final ExtendedDataServices.Builder getExtendedDataServices() {
            return extendedDataServices != null ? extendedDataServices.toBuilder() : null;
        }

        public final void setExtendedDataServices(ExtendedDataServices.BuilderImpl extendedDataServices) {
            this.extendedDataServices = extendedDataServices != null ? extendedDataServices.build() : null;
        }

        @Override
        public final Builder extendedDataServices(ExtendedDataServices extendedDataServices) {
            this.extendedDataServices = extendedDataServices;
            return this;
        }

        public final Integer getFollowSource() {
            return followSource;
        }

        public final void setFollowSource(Integer followSource) {
            this.followSource = followSource;
        }

        @Override
        public final Builder followSource(Integer followSource) {
            this.followSource = followSource;
            return this;
        }

        public final List<Input.Builder> getInputs() {
            List<Input.Builder> result = ___listOfInputCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = ___listOfInputCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = ___listOfInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> Input.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final KantarWatermarkSettings.Builder getKantarWatermark() {
            return kantarWatermark != null ? kantarWatermark.toBuilder() : null;
        }

        public final void setKantarWatermark(KantarWatermarkSettings.BuilderImpl kantarWatermark) {
            this.kantarWatermark = kantarWatermark != null ? kantarWatermark.build() : null;
        }

        @Override
        public final Builder kantarWatermark(KantarWatermarkSettings kantarWatermark) {
            this.kantarWatermark = kantarWatermark;
            return this;
        }

        public final MotionImageInserter.Builder getMotionImageInserter() {
            return motionImageInserter != null ? motionImageInserter.toBuilder() : null;
        }

        public final void setMotionImageInserter(MotionImageInserter.BuilderImpl motionImageInserter) {
            this.motionImageInserter = motionImageInserter != null ? motionImageInserter.build() : null;
        }

        @Override
        public final Builder motionImageInserter(MotionImageInserter motionImageInserter) {
            this.motionImageInserter = motionImageInserter;
            return this;
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return nielsenConfiguration != null ? nielsenConfiguration.toBuilder() : null;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final NielsenNonLinearWatermarkSettings.Builder getNielsenNonLinearWatermark() {
            return nielsenNonLinearWatermark != null ? nielsenNonLinearWatermark.toBuilder() : null;
        }

        public final void setNielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings.BuilderImpl nielsenNonLinearWatermark) {
            this.nielsenNonLinearWatermark = nielsenNonLinearWatermark != null ? nielsenNonLinearWatermark.build() : null;
        }

        @Override
        public final Builder nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark) {
            this.nielsenNonLinearWatermark = nielsenNonLinearWatermark;
            return this;
        }

        public final List<OutputGroup.Builder> getOutputGroups() {
            List<OutputGroup.Builder> result = ___listOfOutputGroupCopier.copyToBuilder(this.outputGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup... outputGroups) {
            outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups) {
            outputGroups(Stream.of(outputGroups).map(c -> OutputGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return timecodeConfig != null ? timecodeConfig.toBuilder() : null;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final TimedMetadataInsertion.Builder getTimedMetadataInsertion() {
            return timedMetadataInsertion != null ? timedMetadataInsertion.toBuilder() : null;
        }

        public final void setTimedMetadataInsertion(TimedMetadataInsertion.BuilderImpl timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion != null ? timedMetadataInsertion.build() : null;
        }

        @Override
        public final Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion;
            return this;
        }

        @Override
        public JobSettings build() {
            return new JobSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
