/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these settings.
 * When you enable Nielsen configuration, MediaConvert enables PCM to ID3 tagging for all outputs in the job.
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NielsenConfiguration.Builder, NielsenConfiguration> {
    private static final SdkField<Integer> BREAKOUT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BreakoutCode").getter(getter(NielsenConfiguration::breakoutCode)).setter(setter(Builder::breakoutCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breakoutCode").build()).build();

    private static final SdkField<String> DISTRIBUTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistributorId").getter(getter(NielsenConfiguration::distributorId))
            .setter(setter(Builder::distributorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BREAKOUT_CODE_FIELD,
            DISTRIBUTOR_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer breakoutCode;

    private final String distributorId;

    private NielsenConfiguration(BuilderImpl builder) {
        this.breakoutCode = builder.breakoutCode;
        this.distributorId = builder.distributorId;
    }

    /**
     * Nielsen has discontinued the use of breakout code functionality. If you must include this property, set the value
     * to zero.
     * 
     * @return Nielsen has discontinued the use of breakout code functionality. If you must include this property, set
     *         the value to zero.
     */
    public final Integer breakoutCode() {
        return breakoutCode;
    }

    /**
     * Use Distributor ID to specify the distributor ID that is assigned to your organization by Nielsen.
     * 
     * @return Use Distributor ID to specify the distributor ID that is assigned to your organization by Nielsen.
     */
    public final String distributorId() {
        return distributorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(breakoutCode());
        hashCode = 31 * hashCode + Objects.hashCode(distributorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenConfiguration)) {
            return false;
        }
        NielsenConfiguration other = (NielsenConfiguration) obj;
        return Objects.equals(breakoutCode(), other.breakoutCode()) && Objects.equals(distributorId(), other.distributorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenConfiguration").add("BreakoutCode", breakoutCode()).add("DistributorId", distributorId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BreakoutCode":
            return Optional.ofNullable(clazz.cast(breakoutCode()));
        case "DistributorId":
            return Optional.ofNullable(clazz.cast(distributorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenConfiguration, T> g) {
        return obj -> g.apply((NielsenConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenConfiguration> {
        /**
         * Nielsen has discontinued the use of breakout code functionality. If you must include this property, set the
         * value to zero.
         * 
         * @param breakoutCode
         *        Nielsen has discontinued the use of breakout code functionality. If you must include this property,
         *        set the value to zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breakoutCode(Integer breakoutCode);

        /**
         * Use Distributor ID to specify the distributor ID that is assigned to your organization by Nielsen.
         * 
         * @param distributorId
         *        Use Distributor ID to specify the distributor ID that is assigned to your organization by Nielsen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributorId(String distributorId);
    }

    static final class BuilderImpl implements Builder {
        private Integer breakoutCode;

        private String distributorId;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenConfiguration model) {
            breakoutCode(model.breakoutCode);
            distributorId(model.distributorId);
        }

        public final Integer getBreakoutCode() {
            return breakoutCode;
        }

        public final void setBreakoutCode(Integer breakoutCode) {
            this.breakoutCode = breakoutCode;
        }

        @Override
        public final Builder breakoutCode(Integer breakoutCode) {
            this.breakoutCode = breakoutCode;
            return this;
        }

        public final String getDistributorId() {
            return distributorId;
        }

        public final void setDistributorId(String distributorId) {
            this.distributorId = distributorId;
        }

        @Override
        public final Builder distributorId(String distributorId) {
            this.distributorId = distributorId;
            return this;
        }

        @Override
        public NielsenConfiguration build() {
            return new NielsenConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
