/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output groups for this Live Event. Output groups contain information about where streams should be distributed.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSelector implements SdkPojo, Serializable, ToCopyableBuilder<CaptionSelector.Builder, CaptionSelector> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionSelector::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CaptionSelector::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CaptionSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField
            .<CaptionSelectorSettings> builder(MarshallingType.SDK_POJO).memberName("SelectorSettings")
            .getter(getter(CaptionSelector::selectorSettings)).setter(setter(Builder::selectorSettings))
            .constructor(CaptionSelectorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            NAME_FIELD, SELECTOR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String name;

    private final CaptionSelectorSettings selectorSettings;

    private CaptionSelector(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.name = builder.name;
        this.selectorSettings = builder.selectorSettings;
    }

    /**
     * When specified this field indicates the three letter language code of the caption track to extract from the
     * source.
     * 
     * @return When specified this field indicates the three letter language code of the caption track to extract from
     *         the source.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * Name identifier for a caption selector. This name is used to associate this caption selector with one or more
     * caption descriptions. Names must be unique within an event.
     * 
     * @return Name identifier for a caption selector. This name is used to associate this caption selector with one or
     *         more caption descriptions. Names must be unique within an event.
     */
    public final String name() {
        return name;
    }

    /**
     * Caption selector settings.
     * 
     * @return Caption selector settings.
     */
    public final CaptionSelectorSettings selectorSettings() {
        return selectorSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(selectorSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector) obj;
        return Objects.equals(languageCode(), other.languageCode()) && Objects.equals(name(), other.name())
                && Objects.equals(selectorSettings(), other.selectorSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionSelector").add("LanguageCode", languageCode()).add("Name", name())
                .add("SelectorSettings", selectorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SelectorSettings":
            return Optional.ofNullable(clazz.cast(selectorSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSelector, T> g) {
        return obj -> g.apply((CaptionSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSelector> {
        /**
         * When specified this field indicates the three letter language code of the caption track to extract from the
         * source.
         * 
         * @param languageCode
         *        When specified this field indicates the three letter language code of the caption track to extract
         *        from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Name identifier for a caption selector. This name is used to associate this caption selector with one or more
         * caption descriptions. Names must be unique within an event.
         * 
         * @param name
         *        Name identifier for a caption selector. This name is used to associate this caption selector with one
         *        or more caption descriptions. Names must be unique within an event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Caption selector settings.
         * 
         * @param selectorSettings
         *        Caption selector settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectorSettings(CaptionSelectorSettings selectorSettings);

        /**
         * Caption selector settings. This is a convenience method that creates an instance of the
         * {@link CaptionSelectorSettings.Builder} avoiding the need to create one manually via
         * {@link CaptionSelectorSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptionSelectorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #selectorSettings(CaptionSelectorSettings)}.
         * 
         * @param selectorSettings
         *        a consumer that will call methods on {@link CaptionSelectorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectorSettings(CaptionSelectorSettings)
         */
        default Builder selectorSettings(Consumer<CaptionSelectorSettings.Builder> selectorSettings) {
            return selectorSettings(CaptionSelectorSettings.builder().applyMutation(selectorSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String name;

        private CaptionSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelector model) {
            languageCode(model.languageCode);
            name(model.name);
            selectorSettings(model.selectorSettings);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CaptionSelectorSettings.Builder getSelectorSettings() {
            return selectorSettings != null ? selectorSettings.toBuilder() : null;
        }

        public final void setSelectorSettings(CaptionSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        @Override
        public final Builder selectorSettings(CaptionSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        @Override
        public CaptionSelector build() {
            return new CaptionSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
