/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings that describe the active source from the input device, and the video characteristics of that source.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceUhdSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceUhdSettings.Builder, InputDeviceUhdSettings> {
    private static final SdkField<String> ACTIVE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveInput").getter(getter(InputDeviceUhdSettings::activeInputAsString))
            .setter(setter(Builder::activeInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeInput").build()).build();

    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfiguredInput").getter(getter(InputDeviceUhdSettings::configuredInputAsString))
            .setter(setter(Builder::configuredInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()).build();

    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceState").getter(getter(InputDeviceUhdSettings::deviceStateAsString))
            .setter(setter(Builder::deviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceState").build()).build();

    private static final SdkField<Double> FRAMERATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Framerate").getter(getter(InputDeviceUhdSettings::framerate)).setter(setter(Builder::framerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(InputDeviceUhdSettings::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(InputDeviceUhdSettings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanType").getter(getter(InputDeviceUhdSettings::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(InputDeviceUhdSettings::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INPUT_FIELD,
            CONFIGURED_INPUT_FIELD, DEVICE_STATE_FIELD, FRAMERATE_FIELD, HEIGHT_FIELD, MAX_BITRATE_FIELD, SCAN_TYPE_FIELD,
            WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeInput;

    private final String configuredInput;

    private final String deviceState;

    private final Double framerate;

    private final Integer height;

    private final Integer maxBitrate;

    private final String scanType;

    private final Integer width;

    private InputDeviceUhdSettings(BuilderImpl builder) {
        this.activeInput = builder.activeInput;
        this.configuredInput = builder.configuredInput;
        this.deviceState = builder.deviceState;
        this.framerate = builder.framerate;
        this.height = builder.height;
        this.maxBitrate = builder.maxBitrate;
        this.scanType = builder.scanType;
        this.width = builder.width;
    }

    /**
     * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activeInput} will
     * return {@link InputDeviceActiveInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activeInputAsString}.
     * </p>
     * 
     * @return If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
     *         HDMI).
     * @see InputDeviceActiveInput
     */
    public final InputDeviceActiveInput activeInput() {
        return InputDeviceActiveInput.fromValue(activeInput);
    }

    /**
     * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activeInput} will
     * return {@link InputDeviceActiveInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activeInputAsString}.
     * </p>
     * 
     * @return If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
     *         HDMI).
     * @see InputDeviceActiveInput
     */
    public final String activeInputAsString() {
        return activeInput;
    }

    /**
     * The source at the input device that is currently active. You can specify this source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The source at the input device that is currently active. You can specify this source.
     * @see InputDeviceConfiguredInput
     */
    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(configuredInput);
    }

    /**
     * The source at the input device that is currently active. You can specify this source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The source at the input device that is currently active. You can specify this source.
     * @see InputDeviceConfiguredInput
     */
    public final String configuredInputAsString() {
        return configuredInput;
    }

    /**
     * The state of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link InputDeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The state of the input device.
     * @see InputDeviceState
     */
    public final InputDeviceState deviceState() {
        return InputDeviceState.fromValue(deviceState);
    }

    /**
     * The state of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link InputDeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The state of the input device.
     * @see InputDeviceState
     */
    public final String deviceStateAsString() {
        return deviceState;
    }

    /**
     * The frame rate of the video source.
     * 
     * @return The frame rate of the video source.
     */
    public final Double framerate() {
        return framerate;
    }

    /**
     * The height of the video source, in pixels.
     * 
     * @return The height of the video source, in pixels.
     */
    public final Integer height() {
        return height;
    }

    /**
     * The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
     * 
     * @return The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The scan type of the video source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link InputDeviceScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scan type of the video source.
     * @see InputDeviceScanType
     */
    public final InputDeviceScanType scanType() {
        return InputDeviceScanType.fromValue(scanType);
    }

    /**
     * The scan type of the video source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link InputDeviceScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scan type of the video source.
     * @see InputDeviceScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * The width of the video source, in pixels.
     * 
     * @return The width of the video source, in pixels.
     */
    public final Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceUhdSettings)) {
            return false;
        }
        InputDeviceUhdSettings other = (InputDeviceUhdSettings) obj;
        return Objects.equals(activeInputAsString(), other.activeInputAsString())
                && Objects.equals(configuredInputAsString(), other.configuredInputAsString())
                && Objects.equals(deviceStateAsString(), other.deviceStateAsString())
                && Objects.equals(framerate(), other.framerate()) && Objects.equals(height(), other.height())
                && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceUhdSettings").add("ActiveInput", activeInputAsString())
                .add("ConfiguredInput", configuredInputAsString()).add("DeviceState", deviceStateAsString())
                .add("Framerate", framerate()).add("Height", height()).add("MaxBitrate", maxBitrate())
                .add("ScanType", scanTypeAsString()).add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInput":
            return Optional.ofNullable(clazz.cast(activeInputAsString()));
        case "ConfiguredInput":
            return Optional.ofNullable(clazz.cast(configuredInputAsString()));
        case "DeviceState":
            return Optional.ofNullable(clazz.cast(deviceStateAsString()));
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "ScanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceUhdSettings, T> g) {
        return obj -> g.apply((InputDeviceUhdSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceUhdSettings> {
        /**
         * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
         * HDMI).
         * 
         * @param activeInput
         *        If you specified Auto as the configured input, specifies which of the sources is currently active (SDI
         *        or HDMI).
         * @see InputDeviceActiveInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceActiveInput
         */
        Builder activeInput(String activeInput);

        /**
         * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
         * HDMI).
         * 
         * @param activeInput
         *        If you specified Auto as the configured input, specifies which of the sources is currently active (SDI
         *        or HDMI).
         * @see InputDeviceActiveInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceActiveInput
         */
        Builder activeInput(InputDeviceActiveInput activeInput);

        /**
         * The source at the input device that is currently active. You can specify this source.
         * 
         * @param configuredInput
         *        The source at the input device that is currently active. You can specify this source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(String configuredInput);

        /**
         * The source at the input device that is currently active. You can specify this source.
         * 
         * @param configuredInput
         *        The source at the input device that is currently active. You can specify this source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(InputDeviceConfiguredInput configuredInput);

        /**
         * The state of the input device.
         * 
         * @param deviceState
         *        The state of the input device.
         * @see InputDeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceState
         */
        Builder deviceState(String deviceState);

        /**
         * The state of the input device.
         * 
         * @param deviceState
         *        The state of the input device.
         * @see InputDeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceState
         */
        Builder deviceState(InputDeviceState deviceState);

        /**
         * The frame rate of the video source.
         * 
         * @param framerate
         *        The frame rate of the video source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(Double framerate);

        /**
         * The height of the video source, in pixels.
         * 
         * @param height
         *        The height of the video source, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
         * 
         * @param maxBitrate
         *        The current maximum bitrate for ingesting this source, in bits per second. You can specify this
         *        maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The scan type of the video source.
         * 
         * @param scanType
         *        The scan type of the video source.
         * @see InputDeviceScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceScanType
         */
        Builder scanType(String scanType);

        /**
         * The scan type of the video source.
         * 
         * @param scanType
         *        The scan type of the video source.
         * @see InputDeviceScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceScanType
         */
        Builder scanType(InputDeviceScanType scanType);

        /**
         * The width of the video source, in pixels.
         * 
         * @param width
         *        The width of the video source, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private String activeInput;

        private String configuredInput;

        private String deviceState;

        private Double framerate;

        private Integer height;

        private Integer maxBitrate;

        private String scanType;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceUhdSettings model) {
            activeInput(model.activeInput);
            configuredInput(model.configuredInput);
            deviceState(model.deviceState);
            framerate(model.framerate);
            height(model.height);
            maxBitrate(model.maxBitrate);
            scanType(model.scanType);
            width(model.width);
        }

        public final String getActiveInput() {
            return activeInput;
        }

        public final void setActiveInput(String activeInput) {
            this.activeInput = activeInput;
        }

        @Override
        public final Builder activeInput(String activeInput) {
            this.activeInput = activeInput;
            return this;
        }

        @Override
        public final Builder activeInput(InputDeviceActiveInput activeInput) {
            this.activeInput(activeInput == null ? null : activeInput.toString());
            return this;
        }

        public final String getConfiguredInput() {
            return configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final String getDeviceState() {
            return deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        public final Builder deviceState(InputDeviceState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public final Double getFramerate() {
            return framerate;
        }

        public final void setFramerate(Double framerate) {
            this.framerate = framerate;
        }

        @Override
        public final Builder framerate(Double framerate) {
            this.framerate = framerate;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(InputDeviceScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public InputDeviceUhdSettings build() {
            return new InputDeviceUhdSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
