/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfScte35DescriptorCopier {
    static List<Scte35Descriptor> copy(Collection<? extends Scte35Descriptor> __listOfScte35DescriptorParam) {
        List<Scte35Descriptor> list;
        if (__listOfScte35DescriptorParam == null || __listOfScte35DescriptorParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Scte35Descriptor> modifiableList = new ArrayList<>();
            __listOfScte35DescriptorParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Scte35Descriptor> copyFromBuilder(Collection<? extends Scte35Descriptor.Builder> __listOfScte35DescriptorParam) {
        List<Scte35Descriptor> list;
        if (__listOfScte35DescriptorParam == null || __listOfScte35DescriptorParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Scte35Descriptor> modifiableList = new ArrayList<>();
            __listOfScte35DescriptorParam.forEach(entry -> {
                Scte35Descriptor member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Scte35Descriptor.Builder> copyToBuilder(Collection<? extends Scte35Descriptor> __listOfScte35DescriptorParam) {
        List<Scte35Descriptor.Builder> list;
        if (__listOfScte35DescriptorParam == null || __listOfScte35DescriptorParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Scte35Descriptor.Builder> modifiableList = new ArrayList<>();
            __listOfScte35DescriptorParam.forEach(entry -> {
                Scte35Descriptor.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
