/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Frame Capture Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureSettings.Builder, FrameCaptureSettings> {
    private static final SdkField<Integer> CAPTURE_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CaptureInterval").getter(getter(FrameCaptureSettings::captureInterval))
            .setter(setter(Builder::captureInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureInterval").build()).build();

    private static final SdkField<String> CAPTURE_INTERVAL_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureIntervalUnits").getter(getter(FrameCaptureSettings::captureIntervalUnitsAsString))
            .setter(setter(Builder::captureIntervalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureIntervalUnits").build())
            .build();

    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField
            .<TimecodeBurninSettings> builder(MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings")
            .getter(getter(FrameCaptureSettings::timecodeBurninSettings)).setter(setter(Builder::timecodeBurninSettings))
            .constructor(TimecodeBurninSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_INTERVAL_FIELD,
            CAPTURE_INTERVAL_UNITS_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer captureInterval;

    private final String captureIntervalUnits;

    private final TimecodeBurninSettings timecodeBurninSettings;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.captureInterval = builder.captureInterval;
        this.captureIntervalUnits = builder.captureIntervalUnits;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
    }

    /**
     * The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or
     * milliseconds, as specified by captureIntervalUnits.
     * 
     * @return The frequency at which to capture frames for inclusion in the output. May be specified in either seconds
     *         or milliseconds, as specified by captureIntervalUnits.
     */
    public final Integer captureInterval() {
        return captureInterval;
    }

    /**
     * Unit for the frame capture interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captureIntervalUnits} will return {@link FrameCaptureIntervalUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captureIntervalUnitsAsString}.
     * </p>
     * 
     * @return Unit for the frame capture interval.
     * @see FrameCaptureIntervalUnit
     */
    public final FrameCaptureIntervalUnit captureIntervalUnits() {
        return FrameCaptureIntervalUnit.fromValue(captureIntervalUnits);
    }

    /**
     * Unit for the frame capture interval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captureIntervalUnits} will return {@link FrameCaptureIntervalUnit#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captureIntervalUnitsAsString}.
     * </p>
     * 
     * @return Unit for the frame capture interval.
     * @see FrameCaptureIntervalUnit
     */
    public final String captureIntervalUnitsAsString() {
        return captureIntervalUnits;
    }

    /**
     * Timecode burn-in settings
     * 
     * @return Timecode burn-in settings
     */
    public final TimecodeBurninSettings timecodeBurninSettings() {
        return timecodeBurninSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureInterval());
        hashCode = 31 * hashCode + Objects.hashCode(captureIntervalUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurninSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings) obj;
        return Objects.equals(captureInterval(), other.captureInterval())
                && Objects.equals(captureIntervalUnitsAsString(), other.captureIntervalUnitsAsString())
                && Objects.equals(timecodeBurninSettings(), other.timecodeBurninSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameCaptureSettings").add("CaptureInterval", captureInterval())
                .add("CaptureIntervalUnits", captureIntervalUnitsAsString())
                .add("TimecodeBurninSettings", timecodeBurninSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptureInterval":
            return Optional.ofNullable(clazz.cast(captureInterval()));
        case "CaptureIntervalUnits":
            return Optional.ofNullable(clazz.cast(captureIntervalUnitsAsString()));
        case "TimecodeBurninSettings":
            return Optional.ofNullable(clazz.cast(timecodeBurninSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureSettings, T> g) {
        return obj -> g.apply((FrameCaptureSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureSettings> {
        /**
         * The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or
         * milliseconds, as specified by captureIntervalUnits.
         * 
         * @param captureInterval
         *        The frequency at which to capture frames for inclusion in the output. May be specified in either
         *        seconds or milliseconds, as specified by captureIntervalUnits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureInterval(Integer captureInterval);

        /**
         * Unit for the frame capture interval.
         * 
         * @param captureIntervalUnits
         *        Unit for the frame capture interval.
         * @see FrameCaptureIntervalUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameCaptureIntervalUnit
         */
        Builder captureIntervalUnits(String captureIntervalUnits);

        /**
         * Unit for the frame capture interval.
         * 
         * @param captureIntervalUnits
         *        Unit for the frame capture interval.
         * @see FrameCaptureIntervalUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameCaptureIntervalUnit
         */
        Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits);

        /**
         * Timecode burn-in settings
         * 
         * @param timecodeBurninSettings
         *        Timecode burn-in settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings);

        /**
         * Timecode burn-in settings This is a convenience method that creates an instance of the
         * {@link TimecodeBurninSettings.Builder} avoiding the need to create one manually via
         * {@link TimecodeBurninSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeBurninSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #timecodeBurninSettings(TimecodeBurninSettings)}.
         * 
         * @param timecodeBurninSettings
         *        a consumer that will call methods on {@link TimecodeBurninSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurninSettings(TimecodeBurninSettings)
         */
        default Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return timecodeBurninSettings(TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer captureInterval;

        private String captureIntervalUnits;

        private TimecodeBurninSettings timecodeBurninSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            captureInterval(model.captureInterval);
            captureIntervalUnits(model.captureIntervalUnits);
            timecodeBurninSettings(model.timecodeBurninSettings);
        }

        public final Integer getCaptureInterval() {
            return captureInterval;
        }

        public final void setCaptureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
        }

        @Override
        public final Builder captureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
            return this;
        }

        public final String getCaptureIntervalUnits() {
            return captureIntervalUnits;
        }

        public final void setCaptureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
        }

        @Override
        public final Builder captureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
            return this;
        }

        @Override
        public final Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits) {
            this.captureIntervalUnits(captureIntervalUnits == null ? null : captureIntervalUnits.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return timecodeBurninSettings != null ? timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        @Override
        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
