/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDicomImportJobRequest extends MedicalImagingRequest implements
        ToCopyableBuilder<StartDicomImportJobRequest.Builder, StartDicomImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(StartDicomImportJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessRoleArn").getter(getter(StartDicomImportJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartDicomImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(StartDicomImportJobRequest::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()).build();

    private static final SdkField<String> INPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputS3Uri").getter(getter(StartDicomImportJobRequest::inputS3Uri)).setter(setter(Builder::inputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Uri").build()).build();

    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Uri").getter(getter(StartDicomImportJobRequest::outputS3Uri))
            .setter(setter(Builder::outputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DATASTORE_ID_FIELD, INPUT_S3_URI_FIELD, OUTPUT_S3_URI_FIELD));

    private final String jobName;

    private final String dataAccessRoleArn;

    private final String clientToken;

    private final String datastoreId;

    private final String inputS3Uri;

    private final String outputS3Uri;

    private StartDicomImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.clientToken = builder.clientToken;
        this.datastoreId = builder.datastoreId;
        this.inputS3Uri = builder.inputS3Uri;
        this.outputS3Uri = builder.outputS3Uri;
    }

    /**
     * <p>
     * The import job name.
     * </p>
     * 
     * @return The import job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants permission to access medical imaging resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants permission to access medical imaging
     *         resources.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * A unique identifier for API idempotency.
     * </p>
     * 
     * @return A unique identifier for API idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The input prefix path for the S3 bucket that contains the DICOM files to be imported.
     * </p>
     * 
     * @return The input prefix path for the S3 bucket that contains the DICOM files to be imported.
     */
    public final String inputS3Uri() {
        return inputS3Uri;
    }

    /**
     * <p>
     * The output prefix of the S3 bucket to upload the results of the DICOM import job.
     * </p>
     * 
     * @return The output prefix of the S3 bucket to upload the results of the DICOM import job.
     */
    public final String outputS3Uri() {
        return outputS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDicomImportJobRequest)) {
            return false;
        }
        StartDicomImportJobRequest other = (StartDicomImportJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(inputS3Uri(), other.inputS3Uri()) && Objects.equals(outputS3Uri(), other.outputS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDicomImportJobRequest").add("JobName", jobName())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("ClientToken", clientToken())
                .add("DatastoreId", datastoreId()).add("InputS3Uri", inputS3Uri()).add("OutputS3Uri", outputS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "dataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "inputS3Uri":
            return Optional.ofNullable(clazz.cast(inputS3Uri()));
        case "outputS3Uri":
            return Optional.ofNullable(clazz.cast(outputS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDicomImportJobRequest, T> g) {
        return obj -> g.apply((StartDicomImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDicomImportJobRequest> {
        /**
         * <p>
         * The import job name.
         * </p>
         * 
         * @param jobName
         *        The import job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants permission to access medical imaging resources.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants permission to access medical imaging
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * A unique identifier for API idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for API idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The input prefix path for the S3 bucket that contains the DICOM files to be imported.
         * </p>
         * 
         * @param inputS3Uri
         *        The input prefix path for the S3 bucket that contains the DICOM files to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Uri(String inputS3Uri);

        /**
         * <p>
         * The output prefix of the S3 bucket to upload the results of the DICOM import job.
         * </p>
         * 
         * @param outputS3Uri
         *        The output prefix of the S3 bucket to upload the results of the DICOM import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Uri(String outputS3Uri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MedicalImagingRequest.BuilderImpl implements Builder {
        private String jobName;

        private String dataAccessRoleArn;

        private String clientToken;

        private String datastoreId;

        private String inputS3Uri;

        private String outputS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDicomImportJobRequest model) {
            super(model);
            jobName(model.jobName);
            dataAccessRoleArn(model.dataAccessRoleArn);
            clientToken(model.clientToken);
            datastoreId(model.datastoreId);
            inputS3Uri(model.inputS3Uri);
            outputS3Uri(model.outputS3Uri);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getInputS3Uri() {
            return inputS3Uri;
        }

        public final void setInputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
        }

        @Override
        public final Builder inputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
            return this;
        }

        public final String getOutputS3Uri() {
            return outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDicomImportJobRequest build() {
            return new StartDicomImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
