/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsResponse;

public class ListDICOMImportJobsIterable
implements SdkIterable<ListDicomImportJobsResponse> {
    private final MedicalImagingClient client;
    private final ListDicomImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDICOMImportJobsIterable(MedicalImagingClient client, ListDicomImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDicomImportJobsResponseFetcher();
    }

    public Iterator<ListDicomImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DICOMImportJobSummary> jobSummaries() {
        Function<ListDicomImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDicomImportJobsResponseFetcher
    implements SyncPageFetcher<ListDicomImportJobsResponse> {
        private ListDicomImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDicomImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDicomImportJobsResponse nextPage(ListDicomImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDICOMImportJobsIterable.this.client.listDICOMImportJobs(ListDICOMImportJobsIterable.this.firstRequest);
            }
            return ListDICOMImportJobsIterable.this.client.listDICOMImportJobs((ListDicomImportJobsRequest)((Object)ListDICOMImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

