/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatastoreResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<GetDatastoreResponse.Builder, GetDatastoreResponse> {
    private static final SdkField<DatastoreProperties> DATASTORE_PROPERTIES_FIELD = SdkField
            .<DatastoreProperties> builder(MarshallingType.SDK_POJO).memberName("datastoreProperties")
            .getter(getter(GetDatastoreResponse::datastoreProperties)).setter(setter(Builder::datastoreProperties))
            .constructor(DatastoreProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_PROPERTIES_FIELD));

    private final DatastoreProperties datastoreProperties;

    private GetDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreProperties = builder.datastoreProperties;
    }

    /**
     * <p>
     * The data store properties.
     * </p>
     * 
     * @return The data store properties.
     */
    public final DatastoreProperties datastoreProperties() {
        return datastoreProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatastoreResponse)) {
            return false;
        }
        GetDatastoreResponse other = (GetDatastoreResponse) obj;
        return Objects.equals(datastoreProperties(), other.datastoreProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatastoreResponse").add("DatastoreProperties", datastoreProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreProperties":
            return Optional.ofNullable(clazz.cast(datastoreProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatastoreResponse, T> g) {
        return obj -> g.apply((GetDatastoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDatastoreResponse> {
        /**
         * <p>
         * The data store properties.
         * </p>
         * 
         * @param datastoreProperties
         *        The data store properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreProperties(DatastoreProperties datastoreProperties);

        /**
         * <p>
         * The data store properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastoreProperties.Builder} avoiding the
         * need to create one manually via {@link DatastoreProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #datastoreProperties(DatastoreProperties)}.
         * 
         * @param datastoreProperties
         *        a consumer that will call methods on {@link DatastoreProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreProperties(DatastoreProperties)
         */
        default Builder datastoreProperties(Consumer<DatastoreProperties.Builder> datastoreProperties) {
            return datastoreProperties(DatastoreProperties.builder().applyMutation(datastoreProperties).build());
        }
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private DatastoreProperties datastoreProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatastoreResponse model) {
            super(model);
            datastoreProperties(model.datastoreProperties);
        }

        public final DatastoreProperties.Builder getDatastoreProperties() {
            return datastoreProperties != null ? datastoreProperties.toBuilder() : null;
        }

        public final void setDatastoreProperties(DatastoreProperties.BuilderImpl datastoreProperties) {
            this.datastoreProperties = datastoreProperties != null ? datastoreProperties.build() : null;
        }

        @Override
        public final Builder datastoreProperties(DatastoreProperties datastoreProperties) {
            this.datastoreProperties = datastoreProperties;
            return this;
        }

        @Override
        public GetDatastoreResponse build() {
            return new GetDatastoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
