/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDicomImportJobResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<GetDicomImportJobResponse.Builder, GetDicomImportJobResponse> {
    private static final SdkField<DICOMImportJobProperties> JOB_PROPERTIES_FIELD = SdkField
            .<DICOMImportJobProperties> builder(MarshallingType.SDK_POJO).memberName("jobProperties")
            .getter(getter(GetDicomImportJobResponse::jobProperties)).setter(setter(Builder::jobProperties))
            .constructor(DICOMImportJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_PROPERTIES_FIELD));

    private final DICOMImportJobProperties jobProperties;

    private GetDicomImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobProperties = builder.jobProperties;
    }

    /**
     * <p>
     * The properties of the import job.
     * </p>
     * 
     * @return The properties of the import job.
     */
    public final DICOMImportJobProperties jobProperties() {
        return jobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDicomImportJobResponse)) {
            return false;
        }
        GetDicomImportJobResponse other = (GetDicomImportJobResponse) obj;
        return Objects.equals(jobProperties(), other.jobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDicomImportJobResponse").add("JobProperties", jobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobProperties":
            return Optional.ofNullable(clazz.cast(jobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDicomImportJobResponse, T> g) {
        return obj -> g.apply((GetDicomImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDicomImportJobResponse> {
        /**
         * <p>
         * The properties of the import job.
         * </p>
         * 
         * @param jobProperties
         *        The properties of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobProperties(DICOMImportJobProperties jobProperties);

        /**
         * <p>
         * The properties of the import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DICOMImportJobProperties.Builder}
         * avoiding the need to create one manually via {@link DICOMImportJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DICOMImportJobProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #jobProperties(DICOMImportJobProperties)}.
         * 
         * @param jobProperties
         *        a consumer that will call methods on {@link DICOMImportJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobProperties(DICOMImportJobProperties)
         */
        default Builder jobProperties(Consumer<DICOMImportJobProperties.Builder> jobProperties) {
            return jobProperties(DICOMImportJobProperties.builder().applyMutation(jobProperties).build());
        }
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private DICOMImportJobProperties jobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDicomImportJobResponse model) {
            super(model);
            jobProperties(model.jobProperties);
        }

        public final DICOMImportJobProperties.Builder getJobProperties() {
            return jobProperties != null ? jobProperties.toBuilder() : null;
        }

        public final void setJobProperties(DICOMImportJobProperties.BuilderImpl jobProperties) {
            this.jobProperties = jobProperties != null ? jobProperties.build() : null;
        }

        @Override
        public final Builder jobProperties(DICOMImportJobProperties jobProperties) {
            this.jobProperties = jobProperties;
            return this;
        }

        @Override
        public GetDicomImportJobResponse build() {
            return new GetDicomImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
