/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImageSetRequest extends MedicalImagingRequest implements
        ToCopyableBuilder<GetImageSetRequest.Builder, GetImageSetRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(GetImageSetRequest::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()).build();

    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(GetImageSetRequest::imageSetId)).setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("imageSetId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionId").getter(getter(GetImageSetRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            IMAGE_SET_ID_FIELD, VERSION_ID_FIELD));

    private final String datastoreId;

    private final String imageSetId;

    private final String versionId;

    private GetImageSetRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The image set version identifier.
     * </p>
     * 
     * @return The image set version identifier.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageSetRequest)) {
            return false;
        }
        GetImageSetRequest other = (GetImageSetRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(imageSetId(), other.imageSetId())
                && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImageSetRequest").add("DatastoreId", datastoreId()).add("ImageSetId", imageSetId())
                .add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImageSetRequest, T> g) {
        return obj -> g.apply((GetImageSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetImageSetRequest> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The image set version identifier.
         * </p>
         * 
         * @param versionId
         *        The image set version identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MedicalImagingRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private String imageSetId;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageSetRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            imageSetId(model.imageSetId);
            versionId(model.versionId);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetImageSetRequest build() {
            return new GetImageSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
