/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the image set metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSetsMetadataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageSetsMetadataSummary.Builder, ImageSetsMetadataSummary> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(ImageSetsMetadataSummary::imageSetId)).setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("version").getter(getter(ImageSetsMetadataSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ImageSetsMetadataSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(ImageSetsMetadataSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<DICOMTags> DICOM_TAGS_FIELD = SdkField.<DICOMTags> builder(MarshallingType.SDK_POJO)
            .memberName("DICOMTags").getter(getter(ImageSetsMetadataSummary::dicomTags)).setter(setter(Builder::dicomTags))
            .constructor(DICOMTags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD,
            VERSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DICOM_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageSetId;

    private final Integer version;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final DICOMTags dicomTags;

    private ImageSetsMetadataSummary(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.dicomTags = builder.dicomTags;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The image set version.
     * </p>
     * 
     * @return The image set version.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The time an image set is created. Sample creation date is provided in <code>1985-04-12T23:20:50.52Z</code>
     * format.
     * </p>
     * 
     * @return The time an image set is created. Sample creation date is provided in
     *         <code>1985-04-12T23:20:50.52Z</code> format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time an image set was last updated.
     * </p>
     * 
     * @return The time an image set was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The DICOM tags associated with the image set.
     * </p>
     * 
     * @return The DICOM tags associated with the image set.
     */
    public final DICOMTags dicomTags() {
        return dicomTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dicomTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSetsMetadataSummary)) {
            return false;
        }
        ImageSetsMetadataSummary other = (ImageSetsMetadataSummary) obj;
        return Objects.equals(imageSetId(), other.imageSetId()) && Objects.equals(version(), other.version())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(dicomTags(), other.dicomTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSetsMetadataSummary").add("ImageSetId", imageSetId()).add("Version", version())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("DICOMTags", dicomTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DICOMTags":
            return Optional.ofNullable(clazz.cast(dicomTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageSetsMetadataSummary, T> g) {
        return obj -> g.apply((ImageSetsMetadataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSetsMetadataSummary> {
        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The image set version.
         * </p>
         * 
         * @param version
         *        The image set version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The time an image set is created. Sample creation date is provided in <code>1985-04-12T23:20:50.52Z</code>
         * format.
         * </p>
         * 
         * @param createdAt
         *        The time an image set is created. Sample creation date is provided in
         *        <code>1985-04-12T23:20:50.52Z</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time an image set was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time an image set was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The DICOM tags associated with the image set.
         * </p>
         * 
         * @param dicomTags
         *        The DICOM tags associated with the image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomTags(DICOMTags dicomTags);

        /**
         * <p>
         * The DICOM tags associated with the image set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DICOMTags.Builder} avoiding the need to
         * create one manually via {@link DICOMTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DICOMTags.Builder#build()} is called immediately and its result
         * is passed to {@link #dicomTags(DICOMTags)}.
         * 
         * @param dicomTags
         *        a consumer that will call methods on {@link DICOMTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dicomTags(DICOMTags)
         */
        default Builder dicomTags(Consumer<DICOMTags.Builder> dicomTags) {
            return dicomTags(DICOMTags.builder().applyMutation(dicomTags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String imageSetId;

        private Integer version;

        private Instant createdAt;

        private Instant updatedAt;

        private DICOMTags dicomTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSetsMetadataSummary model) {
            imageSetId(model.imageSetId);
            version(model.version);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            dicomTags(model.dicomTags);
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final DICOMTags.Builder getDicomTags() {
            return dicomTags != null ? dicomTags.toBuilder() : null;
        }

        public final void setDicomTags(DICOMTags.BuilderImpl dicomTags) {
            this.dicomTags = dicomTags != null ? dicomTags.build() : null;
        }

        @Override
        public final Builder dicomTags(DICOMTags dicomTags) {
            this.dicomTags = dicomTags;
            return this;
        }

        @Override
        public ImageSetsMetadataSummary build() {
            return new ImageSetsMetadataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
