/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends MemoryDbRequest implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(DescribeSnapshotsRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(DescribeSnapshotsRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DescribeSnapshotsRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeSnapshotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> SHOW_DETAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowDetail").getter(getter(DescribeSnapshotsRequest::showDetail)).setter(setter(Builder::showDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            SNAPSHOT_NAME_FIELD, SOURCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SHOW_DETAIL_FIELD));

    private final String clusterName;

    private final String snapshotName;

    private final String source;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean showDetail;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.snapshotName = builder.snapshotName;
        this.source = builder.source;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.showDetail = builder.showDetail;
    }

    /**
     * <p>
     * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific
     * cluster are described.
     * </p>
     * 
     * @return A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that
     *         specific cluster are described.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.
     * </p>
     * 
     * @return A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is
     *         described.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the
     * output shows snapshots that were manually created. If omitted, the output shows both automatically and manually
     * created snapshots.
     * </p>
     * 
     * @return If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user
     *         the output shows snapshots that were manually created. If omitted, the output shows both automatically
     *         and manually created snapshots.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified MaxResults
     * value, a token is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A Boolean value which if true, the shard configuration is included in the snapshot description.
     * </p>
     * 
     * @return A Boolean value which if true, the shard configuration is included in the snapshot description.
     */
    public final Boolean showDetail() {
        return showDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(showDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(source(), other.source()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(showDetail(), other.showDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("ClusterName", clusterName()).add("SnapshotName", snapshotName())
                .add("Source", source()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ShowDetail", showDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ShowDetail":
            return Optional.ofNullable(clazz.cast(showDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that
         * specific cluster are described.
         * </p>
         * 
         * @param clusterName
         *        A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with
         *        that specific cluster are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.
         * </p>
         * 
         * @param snapshotName
         *        A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the
         * output shows snapshots that were manually created. If omitted, the output shows both automatically and
         * manually created snapshots.
         * </p>
         * 
         * @param source
         *        If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to
         *        user the output shows snapshots that were manually created. If omitted, the output shows both
         *        automatically and manually created snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified MaxResults
         * value, a token is included in the response so that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A Boolean value which if true, the shard configuration is included in the snapshot description.
         * </p>
         * 
         * @param showDetail
         *        A Boolean value which if true, the shard configuration is included in the snapshot description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showDetail(Boolean showDetail);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String snapshotName;

        private String source;

        private String nextToken;

        private Integer maxResults;

        private Boolean showDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            clusterName(model.clusterName);
            snapshotName(model.snapshotName);
            source(model.source);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            showDetail(model.showDetail);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getShowDetail() {
            return showDetail;
        }

        public final void setShowDetail(Boolean showDetail) {
            this.showDetail = showDetail;
        }

        @Override
        public final Builder showDetail(Boolean showDetail) {
            this.showDetail = showDetail;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
