/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeServerLifeCycleStateResponse extends MgnResponse implements
        ToCopyableBuilder<ChangeServerLifeCycleStateResponse.Builder, ChangeServerLifeCycleStateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ChangeServerLifeCycleStateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField
            .<DataReplicationInfo> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInfo")
            .getter(getter(ChangeServerLifeCycleStateResponse::dataReplicationInfo)).setter(setter(Builder::dataReplicationInfo))
            .constructor(DataReplicationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build())
            .build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArchived").getter(getter(ChangeServerLifeCycleStateResponse::isArchived))
            .setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()).build();

    private static final SdkField<LaunchedInstance> LAUNCHED_INSTANCE_FIELD = SdkField
            .<LaunchedInstance> builder(MarshallingType.SDK_POJO).memberName("launchedInstance")
            .getter(getter(ChangeServerLifeCycleStateResponse::launchedInstance)).setter(setter(Builder::launchedInstance))
            .constructor(LaunchedInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedInstance").build()).build();

    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.<LifeCycle> builder(MarshallingType.SDK_POJO)
            .memberName("lifeCycle").getter(getter(ChangeServerLifeCycleStateResponse::lifeCycle))
            .setter(setter(Builder::lifeCycle)).constructor(LifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()).build();

    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationType").getter(getter(ChangeServerLifeCycleStateResponse::replicationTypeAsString))
            .setter(setter(Builder::replicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationType").build()).build();

    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField
            .<SourceProperties> builder(MarshallingType.SDK_POJO).memberName("sourceProperties")
            .getter(getter(ChangeServerLifeCycleStateResponse::sourceProperties)).setter(setter(Builder::sourceProperties))
            .constructor(SourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ChangeServerLifeCycleStateResponse::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ChangeServerLifeCycleStateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VCENTER_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vcenterClientID").getter(getter(ChangeServerLifeCycleStateResponse::vcenterClientID))
            .setter(setter(Builder::vcenterClientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterClientID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DATA_REPLICATION_INFO_FIELD, IS_ARCHIVED_FIELD, LAUNCHED_INSTANCE_FIELD, LIFE_CYCLE_FIELD, REPLICATION_TYPE_FIELD,
            SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD, VCENTER_CLIENT_ID_FIELD));

    private final String arn;

    private final DataReplicationInfo dataReplicationInfo;

    private final Boolean isArchived;

    private final LaunchedInstance launchedInstance;

    private final LifeCycle lifeCycle;

    private final String replicationType;

    private final SourceProperties sourceProperties;

    private final String sourceServerID;

    private final Map<String, String> tags;

    private final String vcenterClientID;

    private ChangeServerLifeCycleStateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.isArchived = builder.isArchived;
        this.launchedInstance = builder.launchedInstance;
        this.lifeCycle = builder.lifeCycle;
        this.replicationType = builder.replicationType;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
        this.vcenterClientID = builder.vcenterClientID;
    }

    /**
     * <p>
     * Source server ARN.
     * </p>
     * 
     * @return Source server ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Source server data replication info.
     * </p>
     * 
     * @return Source server data replication info.
     */
    public final DataReplicationInfo dataReplicationInfo() {
        return dataReplicationInfo;
    }

    /**
     * <p>
     * Source server archived status.
     * </p>
     * 
     * @return Source server archived status.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * <p>
     * Source server launched instance.
     * </p>
     * 
     * @return Source server launched instance.
     */
    public final LaunchedInstance launchedInstance() {
        return launchedInstance;
    }

    /**
     * <p>
     * Source server lifecycle state.
     * </p>
     * 
     * @return Source server lifecycle state.
     */
    public final LifeCycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * Source server replication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link ReplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return Source server replication type.
     * @see ReplicationType
     */
    public final ReplicationType replicationType() {
        return ReplicationType.fromValue(replicationType);
    }

    /**
     * <p>
     * Source server replication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link ReplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return Source server replication type.
     * @see ReplicationType
     */
    public final String replicationTypeAsString() {
        return replicationType;
    }

    /**
     * <p>
     * Source server properties.
     * </p>
     * 
     * @return Source server properties.
     */
    public final SourceProperties sourceProperties() {
        return sourceProperties;
    }

    /**
     * <p>
     * Source server ID.
     * </p>
     * 
     * @return Source server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Source server Tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Source server Tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Source server vCenter client id.
     * </p>
     * 
     * @return Source server vCenter client id.
     */
    public final String vcenterClientID() {
        return vcenterClientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(launchedInstance());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vcenterClientID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeServerLifeCycleStateResponse)) {
            return false;
        }
        ChangeServerLifeCycleStateResponse other = (ChangeServerLifeCycleStateResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataReplicationInfo(), other.dataReplicationInfo())
                && Objects.equals(isArchived(), other.isArchived())
                && Objects.equals(launchedInstance(), other.launchedInstance()) && Objects.equals(lifeCycle(), other.lifeCycle())
                && Objects.equals(replicationTypeAsString(), other.replicationTypeAsString())
                && Objects.equals(sourceProperties(), other.sourceProperties())
                && Objects.equals(sourceServerID(), other.sourceServerID()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vcenterClientID(), other.vcenterClientID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeServerLifeCycleStateResponse").add("Arn", arn())
                .add("DataReplicationInfo", dataReplicationInfo()).add("IsArchived", isArchived())
                .add("LaunchedInstance", launchedInstance()).add("LifeCycle", lifeCycle())
                .add("ReplicationType", replicationTypeAsString()).add("SourceProperties", sourceProperties())
                .add("SourceServerID", sourceServerID()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VcenterClientID", vcenterClientID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "dataReplicationInfo":
            return Optional.ofNullable(clazz.cast(dataReplicationInfo()));
        case "isArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "launchedInstance":
            return Optional.ofNullable(clazz.cast(launchedInstance()));
        case "lifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "replicationType":
            return Optional.ofNullable(clazz.cast(replicationTypeAsString()));
        case "sourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vcenterClientID":
            return Optional.ofNullable(clazz.cast(vcenterClientID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeServerLifeCycleStateResponse, T> g) {
        return obj -> g.apply((ChangeServerLifeCycleStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnResponse.Builder, SdkPojo, CopyableBuilder<Builder, ChangeServerLifeCycleStateResponse> {
        /**
         * <p>
         * Source server ARN.
         * </p>
         * 
         * @param arn
         *        Source server ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Source server data replication info.
         * </p>
         * 
         * @param dataReplicationInfo
         *        Source server data replication info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo);

        /**
         * <p>
         * Source server data replication info.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationInfo.Builder} avoiding the
         * need to create one manually via {@link DataReplicationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #dataReplicationInfo(DataReplicationInfo)}.
         * 
         * @param dataReplicationInfo
         *        a consumer that will call methods on {@link DataReplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInfo(DataReplicationInfo)
         */
        default Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return dataReplicationInfo(DataReplicationInfo.builder().applyMutation(dataReplicationInfo).build());
        }

        /**
         * <p>
         * Source server archived status.
         * </p>
         * 
         * @param isArchived
         *        Source server archived status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * Source server launched instance.
         * </p>
         * 
         * @param launchedInstance
         *        Source server launched instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedInstance(LaunchedInstance launchedInstance);

        /**
         * <p>
         * Source server launched instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchedInstance.Builder} avoiding the
         * need to create one manually via {@link LaunchedInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchedInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #launchedInstance(LaunchedInstance)}.
         * 
         * @param launchedInstance
         *        a consumer that will call methods on {@link LaunchedInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchedInstance(LaunchedInstance)
         */
        default Builder launchedInstance(Consumer<LaunchedInstance.Builder> launchedInstance) {
            return launchedInstance(LaunchedInstance.builder().applyMutation(launchedInstance).build());
        }

        /**
         * <p>
         * Source server lifecycle state.
         * </p>
         * 
         * @param lifeCycle
         *        Source server lifecycle state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(LifeCycle lifeCycle);

        /**
         * <p>
         * Source server lifecycle state.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycle.Builder} avoiding the need to
         * create one manually via {@link LifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifeCycle(LifeCycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link LifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(LifeCycle)
         */
        default Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return lifeCycle(LifeCycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * Source server replication type.
         * </p>
         * 
         * @param replicationType
         *        Source server replication type.
         * @see ReplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationType
         */
        Builder replicationType(String replicationType);

        /**
         * <p>
         * Source server replication type.
         * </p>
         * 
         * @param replicationType
         *        Source server replication type.
         * @see ReplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationType
         */
        Builder replicationType(ReplicationType replicationType);

        /**
         * <p>
         * Source server properties.
         * </p>
         * 
         * @param sourceProperties
         *        Source server properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(SourceProperties sourceProperties);

        /**
         * <p>
         * Source server properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceProperties.Builder} avoiding the
         * need to create one manually via {@link SourceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceProperties(SourceProperties)}.
         * 
         * @param sourceProperties
         *        a consumer that will call methods on {@link SourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProperties(SourceProperties)
         */
        default Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return sourceProperties(SourceProperties.builder().applyMutation(sourceProperties).build());
        }

        /**
         * <p>
         * Source server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Source server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Source server Tags.
         * </p>
         * 
         * @param tags
         *        Source server Tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Source server vCenter client id.
         * </p>
         * 
         * @param vcenterClientID
         *        Source server vCenter client id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterClientID(String vcenterClientID);
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private String arn;

        private DataReplicationInfo dataReplicationInfo;

        private Boolean isArchived;

        private LaunchedInstance launchedInstance;

        private LifeCycle lifeCycle;

        private String replicationType;

        private SourceProperties sourceProperties;

        private String sourceServerID;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vcenterClientID;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeServerLifeCycleStateResponse model) {
            super(model);
            arn(model.arn);
            dataReplicationInfo(model.dataReplicationInfo);
            isArchived(model.isArchived);
            launchedInstance(model.launchedInstance);
            lifeCycle(model.lifeCycle);
            replicationType(model.replicationType);
            sourceProperties(model.sourceProperties);
            sourceServerID(model.sourceServerID);
            tags(model.tags);
            vcenterClientID(model.vcenterClientID);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return dataReplicationInfo != null ? dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final LaunchedInstance.Builder getLaunchedInstance() {
            return launchedInstance != null ? launchedInstance.toBuilder() : null;
        }

        public final void setLaunchedInstance(LaunchedInstance.BuilderImpl launchedInstance) {
            this.launchedInstance = launchedInstance != null ? launchedInstance.build() : null;
        }

        @Override
        public final Builder launchedInstance(LaunchedInstance launchedInstance) {
            this.launchedInstance = launchedInstance;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getReplicationType() {
            return replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(ReplicationType replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return sourceProperties != null ? sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getVcenterClientID() {
            return vcenterClientID;
        }

        public final void setVcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
        }

        @Override
        public final Builder vcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
            return this;
        }

        @Override
        public ChangeServerLifeCycleStateResponse build() {
            return new ChangeServerLifeCycleStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
