/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source server replication type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmParameterStoreParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<SsmParameterStoreParameter.Builder, SsmParameterStoreParameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterName").getter(getter(SsmParameterStoreParameter::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()).build();

    private static final SdkField<String> PARAMETER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterType").getter(getter(SsmParameterStoreParameter::parameterTypeAsString))
            .setter(setter(Builder::parameterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterType;

    private SsmParameterStoreParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterType = builder.parameterType;
    }

    /**
     * <p>
     * Source server replication type.
     * </p>
     * 
     * @return Source server replication type.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * Source server replication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterType}
     * will return {@link SsmParameterStoreParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #parameterTypeAsString}.
     * </p>
     * 
     * @return Source server replication type.
     * @see SsmParameterStoreParameterType
     */
    public final SsmParameterStoreParameterType parameterType() {
        return SsmParameterStoreParameterType.fromValue(parameterType);
    }

    /**
     * <p>
     * Source server replication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterType}
     * will return {@link SsmParameterStoreParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #parameterTypeAsString}.
     * </p>
     * 
     * @return Source server replication type.
     * @see SsmParameterStoreParameterType
     */
    public final String parameterTypeAsString() {
        return parameterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmParameterStoreParameter)) {
            return false;
        }
        SsmParameterStoreParameter other = (SsmParameterStoreParameter) obj;
        return Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(parameterTypeAsString(), other.parameterTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SsmParameterStoreParameter").add("ParameterName", parameterName())
                .add("ParameterType", parameterTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "parameterType":
            return Optional.ofNullable(clazz.cast(parameterTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SsmParameterStoreParameter, T> g) {
        return obj -> g.apply((SsmParameterStoreParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmParameterStoreParameter> {
        /**
         * <p>
         * Source server replication type.
         * </p>
         * 
         * @param parameterName
         *        Source server replication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * Source server replication type.
         * </p>
         * 
         * @param parameterType
         *        Source server replication type.
         * @see SsmParameterStoreParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmParameterStoreParameterType
         */
        Builder parameterType(String parameterType);

        /**
         * <p>
         * Source server replication type.
         * </p>
         * 
         * @param parameterType
         *        Source server replication type.
         * @see SsmParameterStoreParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmParameterStoreParameterType
         */
        Builder parameterType(SsmParameterStoreParameterType parameterType);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterType;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmParameterStoreParameter model) {
            parameterName(model.parameterName);
            parameterType(model.parameterType);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getParameterType() {
            return parameterType;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        @Override
        public final Builder parameterType(SsmParameterStoreParameterType parameterType) {
            this.parameterType(parameterType == null ? null : parameterType.toString());
            return this;
        }

        @Override
        public SsmParameterStoreParameter build() {
            return new SsmParameterStoreParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
