/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchConfigurationTemplateRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateLaunchConfigurationTemplateRequest.Builder, UpdateLaunchConfigurationTemplateRequest> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationTemplateID")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::launchConfigurationTemplateID))
            .setter(setter(Builder::launchConfigurationTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID")
                    .build()).build();

    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField
            .<PostLaunchActions> builder(MarshallingType.SDK_POJO).memberName("postLaunchActions")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::postLaunchActions))
            .setter(setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, POST_LAUNCH_ACTIONS_FIELD));

    private final String launchConfigurationTemplateID;

    private final PostLaunchActions postLaunchActions;

    private UpdateLaunchConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.postLaunchActions = builder.postLaunchActions;
    }

    /**
     * <p>
     * Update Launch configuration Target instance right sizing request.
     * </p>
     * 
     * @return Update Launch configuration Target instance right sizing request.
     */
    public final String launchConfigurationTemplateID() {
        return launchConfigurationTemplateID;
    }

    /**
     * <p>
     * Update Launch configuration Target instance right sizing request.
     * </p>
     * 
     * @return Update Launch configuration Target instance right sizing request.
     */
    public final PostLaunchActions postLaunchActions() {
        return postLaunchActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(postLaunchActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchConfigurationTemplateRequest)) {
            return false;
        }
        UpdateLaunchConfigurationTemplateRequest other = (UpdateLaunchConfigurationTemplateRequest) obj;
        return Objects.equals(launchConfigurationTemplateID(), other.launchConfigurationTemplateID())
                && Objects.equals(postLaunchActions(), other.postLaunchActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchConfigurationTemplateRequest")
                .add("LaunchConfigurationTemplateID", launchConfigurationTemplateID())
                .add("PostLaunchActions", postLaunchActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchConfigurationTemplateID":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplateID()));
        case "postLaunchActions":
            return Optional.ofNullable(clazz.cast(postLaunchActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((UpdateLaunchConfigurationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLaunchConfigurationTemplateRequest> {
        /**
         * <p>
         * Update Launch configuration Target instance right sizing request.
         * </p>
         * 
         * @param launchConfigurationTemplateID
         *        Update Launch configuration Target instance right sizing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplateID(String launchConfigurationTemplateID);

        /**
         * <p>
         * Update Launch configuration Target instance right sizing request.
         * </p>
         * 
         * @param postLaunchActions
         *        Update Launch configuration Target instance right sizing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActions(PostLaunchActions postLaunchActions);

        /**
         * <p>
         * Update Launch configuration Target instance right sizing request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostLaunchActions.Builder} avoiding the
         * need to create one manually via {@link PostLaunchActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostLaunchActions.Builder#build()} is called immediately and its
         * result is passed to {@link #postLaunchActions(PostLaunchActions)}.
         * 
         * @param postLaunchActions
         *        a consumer that will call methods on {@link PostLaunchActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postLaunchActions(PostLaunchActions)
         */
        default Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return postLaunchActions(PostLaunchActions.builder().applyMutation(postLaunchActions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String launchConfigurationTemplateID;

        private PostLaunchActions postLaunchActions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchConfigurationTemplateRequest model) {
            super(model);
            launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            postLaunchActions(model.postLaunchActions);
        }

        public final String getLaunchConfigurationTemplateID() {
            return launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return postLaunchActions != null ? postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchConfigurationTemplateRequest build() {
            return new UpdateLaunchConfigurationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
