/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import task error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTaskError implements SdkPojo, Serializable, ToCopyableBuilder<ImportTaskError.Builder, ImportTaskError> {
    private static final SdkField<ImportErrorData> ERROR_DATA_FIELD = SdkField
            .<ImportErrorData> builder(MarshallingType.SDK_POJO).memberName("errorData")
            .getter(getter(ImportTaskError::errorData)).setter(setter(Builder::errorData)).constructor(ImportErrorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorData").build()).build();

    private static final SdkField<String> ERROR_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDateTime").getter(getter(ImportTaskError::errorDateTime)).setter(setter(Builder::errorDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDateTime").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(ImportTaskError::errorTypeAsString)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DATA_FIELD,
            ERROR_DATE_TIME_FIELD, ERROR_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportErrorData errorData;

    private final String errorDateTime;

    private final String errorType;

    private ImportTaskError(BuilderImpl builder) {
        this.errorData = builder.errorData;
        this.errorDateTime = builder.errorDateTime;
        this.errorType = builder.errorType;
    }

    /**
     * <p>
     * Import task error data.
     * </p>
     * 
     * @return Import task error data.
     */
    public final ImportErrorData errorData() {
        return errorData;
    }

    /**
     * <p>
     * Import task error datetime.
     * </p>
     * 
     * @return Import task error datetime.
     */
    public final String errorDateTime() {
        return errorDateTime;
    }

    /**
     * <p>
     * Import task error type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ImportErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return Import task error type.
     * @see ImportErrorType
     */
    public final ImportErrorType errorType() {
        return ImportErrorType.fromValue(errorType);
    }

    /**
     * <p>
     * Import task error type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ImportErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return Import task error type.
     * @see ImportErrorType
     */
    public final String errorTypeAsString() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorData());
        hashCode = 31 * hashCode + Objects.hashCode(errorDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTaskError)) {
            return false;
        }
        ImportTaskError other = (ImportTaskError) obj;
        return Objects.equals(errorData(), other.errorData()) && Objects.equals(errorDateTime(), other.errorDateTime())
                && Objects.equals(errorTypeAsString(), other.errorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTaskError").add("ErrorData", errorData()).add("ErrorDateTime", errorDateTime())
                .add("ErrorType", errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorData":
            return Optional.ofNullable(clazz.cast(errorData()));
        case "errorDateTime":
            return Optional.ofNullable(clazz.cast(errorDateTime()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTaskError, T> g) {
        return obj -> g.apply((ImportTaskError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTaskError> {
        /**
         * <p>
         * Import task error data.
         * </p>
         * 
         * @param errorData
         *        Import task error data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorData(ImportErrorData errorData);

        /**
         * <p>
         * Import task error data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportErrorData.Builder} avoiding the
         * need to create one manually via {@link ImportErrorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportErrorData.Builder#build()} is called immediately and its
         * result is passed to {@link #errorData(ImportErrorData)}.
         * 
         * @param errorData
         *        a consumer that will call methods on {@link ImportErrorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorData(ImportErrorData)
         */
        default Builder errorData(Consumer<ImportErrorData.Builder> errorData) {
            return errorData(ImportErrorData.builder().applyMutation(errorData).build());
        }

        /**
         * <p>
         * Import task error datetime.
         * </p>
         * 
         * @param errorDateTime
         *        Import task error datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDateTime(String errorDateTime);

        /**
         * <p>
         * Import task error type.
         * </p>
         * 
         * @param errorType
         *        Import task error type.
         * @see ImportErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportErrorType
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * Import task error type.
         * </p>
         * 
         * @param errorType
         *        Import task error type.
         * @see ImportErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportErrorType
         */
        Builder errorType(ImportErrorType errorType);
    }

    static final class BuilderImpl implements Builder {
        private ImportErrorData errorData;

        private String errorDateTime;

        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTaskError model) {
            errorData(model.errorData);
            errorDateTime(model.errorDateTime);
            errorType(model.errorType);
        }

        public final ImportErrorData.Builder getErrorData() {
            return errorData != null ? errorData.toBuilder() : null;
        }

        public final void setErrorData(ImportErrorData.BuilderImpl errorData) {
            this.errorData = errorData != null ? errorData.build() : null;
        }

        @Override
        public final Builder errorData(ImportErrorData errorData) {
            this.errorData = errorData;
            return this;
        }

        public final String getErrorDateTime() {
            return errorDateTime;
        }

        public final void setErrorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
        }

        @Override
        public final Builder errorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ImportErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public ImportTaskError build() {
            return new ImportTaskError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
