/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchConfigurationRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateLaunchConfigurationRequest.Builder, UpdateLaunchConfigurationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountID").getter(getter(UpdateLaunchConfigurationRequest::accountID))
            .setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bootMode").getter(getter(UpdateLaunchConfigurationRequest::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()).build();

    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(UpdateLaunchConfigurationRequest::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(UpdateLaunchConfigurationRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<Boolean> ENABLE_MAP_AUTO_TAGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableMapAutoTagging").getter(getter(UpdateLaunchConfigurationRequest::enableMapAutoTagging))
            .setter(setter(Builder::enableMapAutoTagging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMapAutoTagging").build())
            .build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(UpdateLaunchConfigurationRequest::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(UpdateLaunchConfigurationRequest::licensing))
            .setter(setter(Builder::licensing)).constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<String> MAP_AUTO_TAGGING_MPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapAutoTaggingMpeID").getter(getter(UpdateLaunchConfigurationRequest::mapAutoTaggingMpeID))
            .setter(setter(Builder::mapAutoTaggingMpeID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapAutoTaggingMpeID").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateLaunchConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField
            .<PostLaunchActions> builder(MarshallingType.SDK_POJO).memberName("postLaunchActions")
            .getter(getter(UpdateLaunchConfigurationRequest::postLaunchActions)).setter(setter(Builder::postLaunchActions))
            .constructor(PostLaunchActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(UpdateLaunchConfigurationRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(UpdateLaunchConfigurationRequest::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BOOT_MODE_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, ENABLE_MAP_AUTO_TAGGING_FIELD, LAUNCH_DISPOSITION_FIELD,
            LICENSING_FIELD, MAP_AUTO_TAGGING_MPE_ID_FIELD, NAME_FIELD, POST_LAUNCH_ACTIONS_FIELD, SOURCE_SERVER_ID_FIELD,
            TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private final String accountID;

    private final String bootMode;

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final Boolean enableMapAutoTagging;

    private final String launchDisposition;

    private final Licensing licensing;

    private final String mapAutoTaggingMpeID;

    private final String name;

    private final PostLaunchActions postLaunchActions;

    private final String sourceServerID;

    private final String targetInstanceTypeRightSizingMethod;

    private UpdateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.enableMapAutoTagging = builder.enableMapAutoTagging;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.mapAutoTaggingMpeID = builder.mapAutoTaggingMpeID;
        this.name = builder.name;
        this.postLaunchActions = builder.postLaunchActions;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * Update Launch configuration Account ID.
     * </p>
     * 
     * @return Update Launch configuration Account ID.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * Update Launch configuration boot mode request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Update Launch configuration boot mode request.
     * @see BootMode
     */
    public final BootMode bootMode() {
        return BootMode.fromValue(bootMode);
    }

    /**
     * <p>
     * Update Launch configuration boot mode request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Update Launch configuration boot mode request.
     * @see BootMode
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * Update Launch configuration copy Private IP request.
     * </p>
     * 
     * @return Update Launch configuration copy Private IP request.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Update Launch configuration copy Tags request.
     * </p>
     * 
     * @return Update Launch configuration copy Tags request.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * Enable map auto tagging.
     * </p>
     * 
     * @return Enable map auto tagging.
     */
    public final Boolean enableMapAutoTagging() {
        return enableMapAutoTagging;
    }

    /**
     * <p>
     * Update Launch configuration launch disposition request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Update Launch configuration launch disposition request.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * Update Launch configuration launch disposition request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Update Launch configuration launch disposition request.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * <p>
     * Update Launch configuration licensing request.
     * </p>
     * 
     * @return Update Launch configuration licensing request.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * Launch configuration map auto tagging MPE ID.
     * </p>
     * 
     * @return Launch configuration map auto tagging MPE ID.
     */
    public final String mapAutoTaggingMpeID() {
        return mapAutoTaggingMpeID;
    }

    /**
     * <p>
     * Update Launch configuration name request.
     * </p>
     * 
     * @return Update Launch configuration name request.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the PostLaunchActions property for this object.
     * 
     * @return The value of the PostLaunchActions property for this object.
     */
    public final PostLaunchActions postLaunchActions() {
        return postLaunchActions;
    }

    /**
     * <p>
     * Update Launch configuration by Source Server ID request.
     * </p>
     * 
     * @return Update Launch configuration by Source Server ID request.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Update Launch configuration Target instance right sizing request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Update Launch configuration Target instance right sizing request.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Update Launch configuration Target instance right sizing request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Update Launch configuration Target instance right sizing request.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(enableMapAutoTagging());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(mapAutoTaggingMpeID());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchConfigurationRequest)) {
            return false;
        }
        UpdateLaunchConfigurationRequest other = (UpdateLaunchConfigurationRequest) obj;
        return Objects.equals(accountID(), other.accountID())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(enableMapAutoTagging(), other.enableMapAutoTagging())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(mapAutoTaggingMpeID(), other.mapAutoTaggingMpeID())
                && Objects.equals(name(), other.name())
                && Objects.equals(postLaunchActions(), other.postLaunchActions())
                && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchConfigurationRequest").add("AccountID", accountID())
                .add("BootMode", bootModeAsString()).add("CopyPrivateIp", copyPrivateIp()).add("CopyTags", copyTags())
                .add("EnableMapAutoTagging", enableMapAutoTagging()).add("LaunchDisposition", launchDispositionAsString())
                .add("Licensing", licensing()).add("MapAutoTaggingMpeID", mapAutoTaggingMpeID()).add("Name", name())
                .add("PostLaunchActions", postLaunchActions()).add("SourceServerID", sourceServerID())
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "bootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "enableMapAutoTagging":
            return Optional.ofNullable(clazz.cast(enableMapAutoTagging()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "mapAutoTaggingMpeID":
            return Optional.ofNullable(clazz.cast(mapAutoTaggingMpeID()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "postLaunchActions":
            return Optional.ofNullable(clazz.cast(postLaunchActions()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLaunchConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLaunchConfigurationRequest> {
        /**
         * <p>
         * Update Launch configuration Account ID.
         * </p>
         * 
         * @param accountID
         *        Update Launch configuration Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * Update Launch configuration boot mode request.
         * </p>
         * 
         * @param bootMode
         *        Update Launch configuration boot mode request.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * Update Launch configuration boot mode request.
         * </p>
         * 
         * @param bootMode
         *        Update Launch configuration boot mode request.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(BootMode bootMode);

        /**
         * <p>
         * Update Launch configuration copy Private IP request.
         * </p>
         * 
         * @param copyPrivateIp
         *        Update Launch configuration copy Private IP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Update Launch configuration copy Tags request.
         * </p>
         * 
         * @param copyTags
         *        Update Launch configuration copy Tags request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * Enable map auto tagging.
         * </p>
         * 
         * @param enableMapAutoTagging
         *        Enable map auto tagging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMapAutoTagging(Boolean enableMapAutoTagging);

        /**
         * <p>
         * Update Launch configuration launch disposition request.
         * </p>
         * 
         * @param launchDisposition
         *        Update Launch configuration launch disposition request.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * Update Launch configuration launch disposition request.
         * </p>
         * 
         * @param launchDisposition
         *        Update Launch configuration launch disposition request.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * <p>
         * Update Launch configuration licensing request.
         * </p>
         * 
         * @param licensing
         *        Update Launch configuration licensing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * <p>
         * Update Launch configuration licensing request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * Launch configuration map auto tagging MPE ID.
         * </p>
         * 
         * @param mapAutoTaggingMpeID
         *        Launch configuration map auto tagging MPE ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID);

        /**
         * <p>
         * Update Launch configuration name request.
         * </p>
         * 
         * @param name
         *        Update Launch configuration name request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the PostLaunchActions property for this object.
         *
         * @param postLaunchActions
         *        The new value for the PostLaunchActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActions(PostLaunchActions postLaunchActions);

        /**
         * Sets the value of the PostLaunchActions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PostLaunchActions.Builder} avoiding the
         * need to create one manually via {@link PostLaunchActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostLaunchActions.Builder#build()} is called immediately and its
         * result is passed to {@link #postLaunchActions(PostLaunchActions)}.
         * 
         * @param postLaunchActions
         *        a consumer that will call methods on {@link PostLaunchActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postLaunchActions(PostLaunchActions)
         */
        default Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return postLaunchActions(PostLaunchActions.builder().applyMutation(postLaunchActions).build());
        }

        /**
         * <p>
         * Update Launch configuration by Source Server ID request.
         * </p>
         * 
         * @param sourceServerID
         *        Update Launch configuration by Source Server ID request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Update Launch configuration Target instance right sizing request.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Update Launch configuration Target instance right sizing request.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Update Launch configuration Target instance right sizing request.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Update Launch configuration Target instance right sizing request.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String accountID;

        private String bootMode;

        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private Boolean enableMapAutoTagging;

        private String launchDisposition;

        private Licensing licensing;

        private String mapAutoTaggingMpeID;

        private String name;

        private PostLaunchActions postLaunchActions;

        private String sourceServerID;

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchConfigurationRequest model) {
            super(model);
            accountID(model.accountID);
            bootMode(model.bootMode);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            enableMapAutoTagging(model.enableMapAutoTagging);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            mapAutoTaggingMpeID(model.mapAutoTaggingMpeID);
            name(model.name);
            postLaunchActions(model.postLaunchActions);
            sourceServerID(model.sourceServerID);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Boolean getEnableMapAutoTagging() {
            return enableMapAutoTagging;
        }

        public final void setEnableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
        }

        @Override
        public final Builder enableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getMapAutoTaggingMpeID() {
            return mapAutoTaggingMpeID;
        }

        public final void setMapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
        }

        @Override
        public final Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return postLaunchActions != null ? postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchConfigurationRequest build() {
            return new UpdateLaunchConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
