/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSourceServerRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateSourceServerRequest.Builder, UpdateSourceServerRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountID").getter(getter(UpdateSourceServerRequest::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()).build();

    private static final SdkField<SourceServerConnectorAction> CONNECTOR_ACTION_FIELD = SdkField
            .<SourceServerConnectorAction> builder(MarshallingType.SDK_POJO).memberName("connectorAction")
            .getter(getter(UpdateSourceServerRequest::connectorAction)).setter(setter(Builder::connectorAction))
            .constructor(SourceServerConnectorAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorAction").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(UpdateSourceServerRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CONNECTOR_ACTION_FIELD, SOURCE_SERVER_ID_FIELD));

    private final String accountID;

    private final SourceServerConnectorAction connectorAction;

    private final String sourceServerID;

    private UpdateSourceServerRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.connectorAction = builder.connectorAction;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * Update Source Server request account ID.
     * </p>
     * 
     * @return Update Source Server request account ID.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * Update Source Server request connector action.
     * </p>
     * 
     * @return Update Source Server request connector action.
     */
    public final SourceServerConnectorAction connectorAction() {
        return connectorAction;
    }

    /**
     * <p>
     * Update Source Server request source server ID.
     * </p>
     * 
     * @return Update Source Server request source server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(connectorAction());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceServerRequest)) {
            return false;
        }
        UpdateSourceServerRequest other = (UpdateSourceServerRequest) obj;
        return Objects.equals(accountID(), other.accountID()) && Objects.equals(connectorAction(), other.connectorAction())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSourceServerRequest").add("AccountID", accountID())
                .add("ConnectorAction", connectorAction()).add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "connectorAction":
            return Optional.ofNullable(clazz.cast(connectorAction()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceServerRequest, T> g) {
        return obj -> g.apply((UpdateSourceServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSourceServerRequest> {
        /**
         * <p>
         * Update Source Server request account ID.
         * </p>
         * 
         * @param accountID
         *        Update Source Server request account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * Update Source Server request connector action.
         * </p>
         * 
         * @param connectorAction
         *        Update Source Server request connector action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorAction(SourceServerConnectorAction connectorAction);

        /**
         * <p>
         * Update Source Server request connector action.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceServerConnectorAction.Builder}
         * avoiding the need to create one manually via {@link SourceServerConnectorAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceServerConnectorAction.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorAction(SourceServerConnectorAction)}.
         * 
         * @param connectorAction
         *        a consumer that will call methods on {@link SourceServerConnectorAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorAction(SourceServerConnectorAction)
         */
        default Builder connectorAction(Consumer<SourceServerConnectorAction.Builder> connectorAction) {
            return connectorAction(SourceServerConnectorAction.builder().applyMutation(connectorAction).build());
        }

        /**
         * <p>
         * Update Source Server request source server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Update Source Server request source server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String accountID;

        private SourceServerConnectorAction connectorAction;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceServerRequest model) {
            super(model);
            accountID(model.accountID);
            connectorAction(model.connectorAction);
            sourceServerID(model.sourceServerID);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final SourceServerConnectorAction.Builder getConnectorAction() {
            return connectorAction != null ? connectorAction.toBuilder() : null;
        }

        public final void setConnectorAction(SourceServerConnectorAction.BuilderImpl connectorAction) {
            this.connectorAction = connectorAction != null ? connectorAction.build() : null;
        }

        @Override
        public final Builder connectorAction(SourceServerConnectorAction connectorAction) {
            this.connectorAction = connectorAction;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceServerRequest build() {
            return new UpdateSourceServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
