/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateCreatedArtifactRequest extends MigrationHubRequest implements
        ToCopyableBuilder<DisassociateCreatedArtifactRequest.Builder, DisassociateCreatedArtifactRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressUpdateStream").getter(getter(DisassociateCreatedArtifactRequest::progressUpdateStream))
            .setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationTaskName").getter(getter(DisassociateCreatedArtifactRequest::migrationTaskName))
            .setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<String> CREATED_ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedArtifactName").getter(getter(DisassociateCreatedArtifactRequest::createdArtifactName))
            .setter(setter(Builder::createdArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedArtifactName").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(DisassociateCreatedArtifactRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, CREATED_ARTIFACT_NAME_FIELD, DRY_RUN_FIELD));

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final String createdArtifactName;

    private final Boolean dryRun;

    private DisassociateCreatedArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.createdArtifactName = builder.createdArtifactName;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream.
     * </p>
     * 
     * @return The name of the ProgressUpdateStream.
     */
    public final String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not store
     * personal data in this field.</i>
     * </p>
     * 
     * @return Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not
     *         store personal data in this field.</i>
     */
    public final String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
     * </p>
     * 
     * @return An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
     */
    public final String createdArtifactName() {
        return createdArtifactName;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(createdArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateCreatedArtifactRequest)) {
            return false;
        }
        DisassociateCreatedArtifactRequest other = (DisassociateCreatedArtifactRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(createdArtifactName(), other.createdArtifactName()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateCreatedArtifactRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("CreatedArtifactName", createdArtifactName())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "CreatedArtifactName":
            return Optional.ofNullable(clazz.cast(createdArtifactName()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateCreatedArtifactRequest, T> g) {
        return obj -> g.apply((DisassociateCreatedArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateCreatedArtifactRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the ProgressUpdateStream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not store
         * personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        Unique identifier that references the migration task to be disassociated with the artifact. <i>Do not
         *        store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
         * </p>
         * 
         * @param createdArtifactName
         *        An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdArtifactName(String createdArtifactName);

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private String createdArtifactName;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateCreatedArtifactRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            createdArtifactName(model.createdArtifactName);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final String getCreatedArtifactName() {
            return createdArtifactName;
        }

        public final void setCreatedArtifactName(String createdArtifactName) {
            this.createdArtifactName = createdArtifactName;
        }

        @Override
        public final Builder createdArtifactName(String createdArtifactName) {
            this.createdArtifactName = createdArtifactName;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateCreatedArtifactRequest build() {
            return new DisassociateCreatedArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
