/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.migrationhubconfig.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhubconfig.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhubconfig.model.MigrationHubConfigException;
import software.amazon.awssdk.services.migrationhubconfig.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhubconfig.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable;

/**
 * Service client for accessing AWS Migration Hub Config. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The AWS Migration Hub home region APIs are available specifically for working with your Migration Hub home region.
 * You can use these APIs to determine a home region, as well as to create and work with controls that describe the home
 * region.
 * </p>
 * <ul>
 * <li>
 * <p>
 * You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your
 * home region, or a <code>HomeRegionNotSetException</code> error is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * API calls for read actions (list, describe, stop, and delete) are permitted outside of your home region.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you call a write API outside the home region, an <code>InvalidInputException</code> is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * You can call <code>GetHomeRegion</code> action to obtain the account's Migration Hub home region.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For specific API usage, see the sections that follow in this AWS Migration Hub Home Region API reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubConfigClient extends AwsClient {
    String SERVICE_NAME = "mgh";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "migrationhub-config";

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     *
     * @param createHomeRegionControlRequest
     * @return Result of the CreateHomeRegionControl operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws DryRunOperationException
     *         Exception raised to indicate that authorization of an action was successful, when the <code>DryRun</code>
     *         flag is set to true.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.CreateHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHomeRegionControlResponse createHomeRegionControl(CreateHomeRegionControlRequest createHomeRegionControlRequest)
            throws InternalServerErrorException, ServiceUnavailableException, AccessDeniedException, ThrottlingException,
            DryRunOperationException, InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHomeRegionControlRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHomeRegionControlRequest#builder()}
     * </p>
     *
     * @param createHomeRegionControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest.Builder} to
     *        create a request.
     * @return Result of the CreateHomeRegionControl operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws DryRunOperationException
     *         Exception raised to indicate that authorization of an action was successful, when the <code>DryRun</code>
     *         flag is set to true.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.CreateHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHomeRegionControlResponse createHomeRegionControl(
            Consumer<CreateHomeRegionControlRequest.Builder> createHomeRegionControlRequest) throws InternalServerErrorException,
            ServiceUnavailableException, AccessDeniedException, ThrottlingException, DryRunOperationException,
            InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        return createHomeRegionControl(CreateHomeRegionControlRequest.builder().applyMutation(createHomeRegionControlRequest)
                .build());
    }

    /**
     * <p>
     * This operation deletes the home region configuration for the calling account. The operation does not delete
     * discovery or migration tracking data in the home region.
     * </p>
     *
     * @param deleteHomeRegionControlRequest
     * @return Result of the DeleteHomeRegionControl operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DeleteHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DeleteHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHomeRegionControlResponse deleteHomeRegionControl(DeleteHomeRegionControlRequest deleteHomeRegionControlRequest)
            throws InternalServerErrorException, ServiceUnavailableException, AccessDeniedException, ThrottlingException,
            InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the home region configuration for the calling account. The operation does not delete
     * discovery or migration tracking data in the home region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHomeRegionControlRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHomeRegionControlRequest#builder()}
     * </p>
     *
     * @param deleteHomeRegionControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteHomeRegionControl operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DeleteHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DeleteHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHomeRegionControlResponse deleteHomeRegionControl(
            Consumer<DeleteHomeRegionControlRequest.Builder> deleteHomeRegionControlRequest) throws InternalServerErrorException,
            ServiceUnavailableException, AccessDeniedException, ThrottlingException, InvalidInputException, AwsServiceException,
            SdkClientException, MigrationHubConfigException {
        return deleteHomeRegionControl(DeleteHomeRegionControlRequest.builder().applyMutation(deleteHomeRegionControlRequest)
                .build());
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return Result of the DescribeHomeRegionControls operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsResponse describeHomeRegionControls(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) throws InternalServerErrorException,
            ServiceUnavailableException, AccessDeniedException, ThrottlingException, InvalidInputException, AwsServiceException,
            SdkClientException, MigrationHubConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeHomeRegionControls operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsResponse describeHomeRegionControls(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest)
            throws InternalServerErrorException, ServiceUnavailableException, AccessDeniedException, ThrottlingException,
            InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        return describeHomeRegionControls(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client.describeHomeRegionControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client
     *             .describeHomeRegionControlsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client.describeHomeRegionControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsIterable describeHomeRegionControlsPaginator(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) throws InternalServerErrorException,
            ServiceUnavailableException, AccessDeniedException, ThrottlingException, InvalidInputException, AwsServiceException,
            SdkClientException, MigrationHubConfigException {
        return new DescribeHomeRegionControlsIterable(this, describeHomeRegionControlsRequest);
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client.describeHomeRegionControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client
     *             .describeHomeRegionControlsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsIterable responses = client.describeHomeRegionControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsIterable describeHomeRegionControlsPaginator(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest)
            throws InternalServerErrorException, ServiceUnavailableException, AccessDeniedException, ThrottlingException,
            InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        return describeHomeRegionControlsPaginator(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     *
     * @param getHomeRegionRequest
     * @return Result of the GetHomeRegion operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.GetHomeRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHomeRegionResponse getHomeRegion(GetHomeRegionRequest getHomeRegionRequest) throws InternalServerErrorException,
            ServiceUnavailableException, AccessDeniedException, ThrottlingException, InvalidInputException, AwsServiceException,
            SdkClientException, MigrationHubConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHomeRegionRequest.Builder} avoiding the need to
     * create one manually via {@link GetHomeRegionRequest#builder()}
     * </p>
     *
     * @param getHomeRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest.Builder} to create a
     *        request.
     * @return Result of the GetHomeRegion operation returned by the service.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when a request fails due to temporary unavailability of the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubConfigClient.GetHomeRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHomeRegionResponse getHomeRegion(Consumer<GetHomeRegionRequest.Builder> getHomeRegionRequest)
            throws InternalServerErrorException, ServiceUnavailableException, AccessDeniedException, ThrottlingException,
            InvalidInputException, AwsServiceException, SdkClientException, MigrationHubConfigException {
        return getHomeRegion(GetHomeRegionRequest.builder().applyMutation(getHomeRegionRequest).build());
    }

    /**
     * Create a {@link MigrationHubConfigClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubConfigClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubConfigClient}.
     */
    static MigrationHubConfigClientBuilder builder() {
        return new DefaultMigrationHubConfigClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MigrationHubConfigServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
