/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom script to run tests on source or target environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepAutomationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StepAutomationConfiguration.Builder, StepAutomationConfiguration> {
    private static final SdkField<String> SCRIPT_LOCATION_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptLocationS3Bucket").getter(getter(StepAutomationConfiguration::scriptLocationS3Bucket))
            .setter(setter(Builder::scriptLocationS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocationS3Bucket").build())
            .build();

    private static final SdkField<PlatformScriptKey> SCRIPT_LOCATION_S3_KEY_FIELD = SdkField
            .<PlatformScriptKey> builder(MarshallingType.SDK_POJO).memberName("scriptLocationS3Key")
            .getter(getter(StepAutomationConfiguration::scriptLocationS3Key)).setter(setter(Builder::scriptLocationS3Key))
            .constructor(PlatformScriptKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocationS3Key").build())
            .build();

    private static final SdkField<PlatformCommand> COMMAND_FIELD = SdkField.<PlatformCommand> builder(MarshallingType.SDK_POJO)
            .memberName("command").getter(getter(StepAutomationConfiguration::command)).setter(setter(Builder::command))
            .constructor(PlatformCommand::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<String> RUN_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runEnvironment").getter(getter(StepAutomationConfiguration::runEnvironmentAsString))
            .setter(setter(Builder::runEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEnvironment").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(StepAutomationConfiguration::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCRIPT_LOCATION_S3_BUCKET_FIELD, SCRIPT_LOCATION_S3_KEY_FIELD, COMMAND_FIELD, RUN_ENVIRONMENT_FIELD,
            TARGET_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scriptLocationS3Bucket;

    private final PlatformScriptKey scriptLocationS3Key;

    private final PlatformCommand command;

    private final String runEnvironment;

    private final String targetType;

    private StepAutomationConfiguration(BuilderImpl builder) {
        this.scriptLocationS3Bucket = builder.scriptLocationS3Bucket;
        this.scriptLocationS3Key = builder.scriptLocationS3Key;
        this.command = builder.command;
        this.runEnvironment = builder.runEnvironment;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the script is located.
     * </p>
     * 
     * @return The Amazon S3 bucket where the script is located.
     */
    public final String scriptLocationS3Bucket() {
        return scriptLocationS3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 key for the script location.
     * </p>
     * 
     * @return The Amazon S3 key for the script location.
     */
    public final PlatformScriptKey scriptLocationS3Key() {
        return scriptLocationS3Key;
    }

    /**
     * <p>
     * The command to run the script.
     * </p>
     * 
     * @return The command to run the script.
     */
    public final PlatformCommand command() {
        return command;
    }

    /**
     * <p>
     * The source or target environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runEnvironment}
     * will return {@link RunEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runEnvironmentAsString}.
     * </p>
     * 
     * @return The source or target environment.
     * @see RunEnvironment
     */
    public final RunEnvironment runEnvironment() {
        return RunEnvironment.fromValue(runEnvironment);
    }

    /**
     * <p>
     * The source or target environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runEnvironment}
     * will return {@link RunEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runEnvironmentAsString}.
     * </p>
     * 
     * @return The source or target environment.
     * @see RunEnvironment
     */
    public final String runEnvironmentAsString() {
        return runEnvironment;
    }

    /**
     * <p>
     * The servers on which to run the script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The servers on which to run the script.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The servers on which to run the script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The servers on which to run the script.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocationS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocationS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(runEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAutomationConfiguration)) {
            return false;
        }
        StepAutomationConfiguration other = (StepAutomationConfiguration) obj;
        return Objects.equals(scriptLocationS3Bucket(), other.scriptLocationS3Bucket())
                && Objects.equals(scriptLocationS3Key(), other.scriptLocationS3Key())
                && Objects.equals(command(), other.command())
                && Objects.equals(runEnvironmentAsString(), other.runEnvironmentAsString())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepAutomationConfiguration").add("ScriptLocationS3Bucket", scriptLocationS3Bucket())
                .add("ScriptLocationS3Key", scriptLocationS3Key()).add("Command", command())
                .add("RunEnvironment", runEnvironmentAsString()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scriptLocationS3Bucket":
            return Optional.ofNullable(clazz.cast(scriptLocationS3Bucket()));
        case "scriptLocationS3Key":
            return Optional.ofNullable(clazz.cast(scriptLocationS3Key()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "runEnvironment":
            return Optional.ofNullable(clazz.cast(runEnvironmentAsString()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepAutomationConfiguration, T> g) {
        return obj -> g.apply((StepAutomationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepAutomationConfiguration> {
        /**
         * <p>
         * The Amazon S3 bucket where the script is located.
         * </p>
         * 
         * @param scriptLocationS3Bucket
         *        The Amazon S3 bucket where the script is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocationS3Bucket(String scriptLocationS3Bucket);

        /**
         * <p>
         * The Amazon S3 key for the script location.
         * </p>
         * 
         * @param scriptLocationS3Key
         *        The Amazon S3 key for the script location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocationS3Key(PlatformScriptKey scriptLocationS3Key);

        /**
         * <p>
         * The Amazon S3 key for the script location.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlatformScriptKey.Builder} avoiding the
         * need to create one manually via {@link PlatformScriptKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlatformScriptKey.Builder#build()} is called immediately and its
         * result is passed to {@link #scriptLocationS3Key(PlatformScriptKey)}.
         * 
         * @param scriptLocationS3Key
         *        a consumer that will call methods on {@link PlatformScriptKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptLocationS3Key(PlatformScriptKey)
         */
        default Builder scriptLocationS3Key(Consumer<PlatformScriptKey.Builder> scriptLocationS3Key) {
            return scriptLocationS3Key(PlatformScriptKey.builder().applyMutation(scriptLocationS3Key).build());
        }

        /**
         * <p>
         * The command to run the script.
         * </p>
         * 
         * @param command
         *        The command to run the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(PlatformCommand command);

        /**
         * <p>
         * The command to run the script.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlatformCommand.Builder} avoiding the
         * need to create one manually via {@link PlatformCommand#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlatformCommand.Builder#build()} is called immediately and its
         * result is passed to {@link #command(PlatformCommand)}.
         * 
         * @param command
         *        a consumer that will call methods on {@link PlatformCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #command(PlatformCommand)
         */
        default Builder command(Consumer<PlatformCommand.Builder> command) {
            return command(PlatformCommand.builder().applyMutation(command).build());
        }

        /**
         * <p>
         * The source or target environment.
         * </p>
         * 
         * @param runEnvironment
         *        The source or target environment.
         * @see RunEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunEnvironment
         */
        Builder runEnvironment(String runEnvironment);

        /**
         * <p>
         * The source or target environment.
         * </p>
         * 
         * @param runEnvironment
         *        The source or target environment.
         * @see RunEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunEnvironment
         */
        Builder runEnvironment(RunEnvironment runEnvironment);

        /**
         * <p>
         * The servers on which to run the script.
         * </p>
         * 
         * @param targetType
         *        The servers on which to run the script.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The servers on which to run the script.
         * </p>
         * 
         * @param targetType
         *        The servers on which to run the script.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);
    }

    static final class BuilderImpl implements Builder {
        private String scriptLocationS3Bucket;

        private PlatformScriptKey scriptLocationS3Key;

        private PlatformCommand command;

        private String runEnvironment;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(StepAutomationConfiguration model) {
            scriptLocationS3Bucket(model.scriptLocationS3Bucket);
            scriptLocationS3Key(model.scriptLocationS3Key);
            command(model.command);
            runEnvironment(model.runEnvironment);
            targetType(model.targetType);
        }

        public final String getScriptLocationS3Bucket() {
            return scriptLocationS3Bucket;
        }

        public final void setScriptLocationS3Bucket(String scriptLocationS3Bucket) {
            this.scriptLocationS3Bucket = scriptLocationS3Bucket;
        }

        @Override
        public final Builder scriptLocationS3Bucket(String scriptLocationS3Bucket) {
            this.scriptLocationS3Bucket = scriptLocationS3Bucket;
            return this;
        }

        public final PlatformScriptKey.Builder getScriptLocationS3Key() {
            return scriptLocationS3Key != null ? scriptLocationS3Key.toBuilder() : null;
        }

        public final void setScriptLocationS3Key(PlatformScriptKey.BuilderImpl scriptLocationS3Key) {
            this.scriptLocationS3Key = scriptLocationS3Key != null ? scriptLocationS3Key.build() : null;
        }

        @Override
        public final Builder scriptLocationS3Key(PlatformScriptKey scriptLocationS3Key) {
            this.scriptLocationS3Key = scriptLocationS3Key;
            return this;
        }

        public final PlatformCommand.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        public final void setCommand(PlatformCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(PlatformCommand command) {
            this.command = command;
            return this;
        }

        public final String getRunEnvironment() {
            return runEnvironment;
        }

        public final void setRunEnvironment(String runEnvironment) {
            this.runEnvironment = runEnvironment;
        }

        @Override
        public final Builder runEnvironment(String runEnvironment) {
            this.runEnvironment = runEnvironment;
            return this;
        }

        @Override
        public final Builder runEnvironment(RunEnvironment runEnvironment) {
            this.runEnvironment(runEnvironment == null ? null : runEnvironment.toString());
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public StepAutomationConfiguration build() {
            return new StepAutomationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
