/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a step group in a workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepGroupSummary.Builder, WorkflowStepGroupSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(WorkflowStepGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowStepGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(WorkflowStepGroupSummary::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkflowStepGroupSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(WorkflowStepGroupSummary::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(WorkflowStepGroupSummary::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            OWNER_FIELD, STATUS_FIELD, PREVIOUS_FIELD, NEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String owner;

    private final String status;

    private final List<String> previous;

    private final List<String> next;

    private WorkflowStepGroupSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.status = builder.status;
        this.previous = builder.previous;
        this.next = builder.next;
    }

    /**
     * <p>
     * The ID of the step group.
     * </p>
     * 
     * @return The ID of the step group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the step group.
     * </p>
     * 
     * @return The name of the step group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the step group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step group.
     * @see Owner
     */
    public final Owner owner() {
        return Owner.fromValue(owner);
    }

    /**
     * <p>
     * The owner of the step group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step group.
     * @see Owner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * <p>
     * The status of the step group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step group.
     * @see StepGroupStatus
     */
    public final StepGroupStatus status() {
        return StepGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the step group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step group.
     * @see StepGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step group.
     */
    public final List<String> previous() {
        return previous;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step group.
     */
    public final List<String> next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepGroupSummary)) {
            return false;
        }
        WorkflowStepGroupSummary other = (WorkflowStepGroupSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerAsString(), other.ownerAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasPrevious() == other.hasPrevious()
                && Objects.equals(previous(), other.previous()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepGroupSummary").add("Id", id()).add("Name", name()).add("Owner", ownerAsString())
                .add("Status", statusAsString()).add("Previous", hasPrevious() ? previous() : null)
                .add("Next", hasNext() ? next() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepGroupSummary, T> g) {
        return obj -> g.apply((WorkflowStepGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepGroupSummary> {
        /**
         * <p>
         * The ID of the step group.
         * </p>
         * 
         * @param id
         *        The ID of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the step group.
         * </p>
         * 
         * @param name
         *        The name of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the step group.
         * </p>
         * 
         * @param owner
         *        The owner of the step group.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(String owner);

        /**
         * <p>
         * The owner of the step group.
         * </p>
         * 
         * @param owner
         *        The owner of the step group.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * The status of the step group.
         * </p>
         * 
         * @param status
         *        The status of the step group.
         * @see StepGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the step group.
         * </p>
         * 
         * @param status
         *        The status of the step group.
         * @see StepGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepGroupStatus
         */
        Builder status(StepGroupStatus status);

        /**
         * <p>
         * The previous step group.
         * </p>
         * 
         * @param previous
         *        The previous step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step group.
         * </p>
         * 
         * @param previous
         *        The previous step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        /**
         * <p>
         * The next step group.
         * </p>
         * 
         * @param next
         *        The next step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step group.
         * </p>
         * 
         * @param next
         *        The next step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String owner;

        private String status;

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepGroupSummary model) {
            id(model.id);
            name(model.name);
            owner(model.owner);
            status(model.status);
            previous(model.previous);
            next(model.next);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        @Override
        public WorkflowStepGroupSummary build() {
            return new WorkflowStepGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
