/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceRequest extends MigrationHubRefactorSpacesRequest implements
        ToCopyableBuilder<CreateServiceRequest.Builder, CreateServiceRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier").getter(getter(CreateServiceRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateServiceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateServiceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(CreateServiceRequest::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentIdentifier").getter(getter(CreateServiceRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build())
            .build();

    private static final SdkField<LambdaEndpointInput> LAMBDA_ENDPOINT_FIELD = SdkField
            .<LambdaEndpointInput> builder(MarshallingType.SDK_POJO).memberName("LambdaEndpoint")
            .getter(getter(CreateServiceRequest::lambdaEndpoint)).setter(setter(Builder::lambdaEndpoint))
            .constructor(LambdaEndpointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaEndpoint").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateServiceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UrlEndpointInput> URL_ENDPOINT_FIELD = SdkField
            .<UrlEndpointInput> builder(MarshallingType.SDK_POJO).memberName("UrlEndpoint")
            .getter(getter(CreateServiceRequest::urlEndpoint)).setter(setter(Builder::urlEndpoint))
            .constructor(UrlEndpointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlEndpoint").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateServiceRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, LAMBDA_ENDPOINT_FIELD,
            NAME_FIELD, TAGS_FIELD, URL_ENDPOINT_FIELD, VPC_ID_FIELD));

    private final String applicationIdentifier;

    private final String clientToken;

    private final String description;

    private final String endpointType;

    private final String environmentIdentifier;

    private final LambdaEndpointInput lambdaEndpoint;

    private final String name;

    private final Map<String, String> tags;

    private final UrlEndpointInput urlEndpoint;

    private final String vpcId;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.lambdaEndpoint = builder.lambdaEndpoint;
        this.name = builder.name;
        this.tags = builder.tags;
        this.urlEndpoint = builder.urlEndpoint;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ID of the application which the service is created.
     * </p>
     * 
     * @return The ID of the application which the service is created.
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the service.
     * </p>
     * 
     * @return The description of the service.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ServiceEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
     * @see ServiceEndpointType
     */
    public final ServiceEndpointType endpointType() {
        return ServiceEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ServiceEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
     * @see ServiceEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The ID of the environment in which the service is created.
     * </p>
     * 
     * @return The ID of the environment in which the service is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The configuration for the Lambda endpoint type.
     * </p>
     * 
     * @return The configuration for the Lambda endpoint type.
     */
    public final LambdaEndpointInput lambdaEndpoint() {
        return lambdaEndpoint;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key-value pair..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource.
     *         Each tag consists of a key-value pair..
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for the URL endpoint type.
     * </p>
     * 
     * @return The configuration for the URL endpoint type.
     */
    public final UrlEndpointInput urlEndpoint() {
        return urlEndpoint;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(urlEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest) obj;
        return Objects.equals(applicationIdentifier(), other.applicationIdentifier())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(lambdaEndpoint(), other.lambdaEndpoint()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(urlEndpoint(), other.urlEndpoint()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceRequest").add("ApplicationIdentifier", applicationIdentifier())
                .add("ClientToken", clientToken()).add("Description", description()).add("EndpointType", endpointTypeAsString())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("LambdaEndpoint", lambdaEndpoint())
                .add("Name", name()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UrlEndpoint", urlEndpoint()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "EnvironmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "LambdaEndpoint":
            return Optional.ofNullable(clazz.cast(lambdaEndpoint()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UrlEndpoint":
            return Optional.ofNullable(clazz.cast(urlEndpoint()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceRequest> {
        /**
         * <p>
         * The ID of the application which the service is created.
         * </p>
         * 
         * @param applicationIdentifier
         *        The ID of the application which the service is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the service.
         * </p>
         * 
         * @param description
         *        The description of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
         * @see ServiceEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
         * @see ServiceEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEndpointType
         */
        Builder endpointType(ServiceEndpointType endpointType);

        /**
         * <p>
         * The ID of the environment in which the service is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment in which the service is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The configuration for the Lambda endpoint type.
         * </p>
         * 
         * @param lambdaEndpoint
         *        The configuration for the Lambda endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaEndpoint(LambdaEndpointInput lambdaEndpoint);

        /**
         * <p>
         * The configuration for the Lambda endpoint type.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaEndpointInput.Builder} avoiding the
         * need to create one manually via {@link LambdaEndpointInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaEndpointInput.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaEndpoint(LambdaEndpointInput)}.
         * 
         * @param lambdaEndpoint
         *        a consumer that will call methods on {@link LambdaEndpointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaEndpoint(LambdaEndpointInput)
         */
        default Builder lambdaEndpoint(Consumer<LambdaEndpointInput.Builder> lambdaEndpoint) {
            return lambdaEndpoint(LambdaEndpointInput.builder().applyMutation(lambdaEndpoint).build());
        }

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each
         * tag consists of a key-value pair..
         * </p>
         * 
         * @param tags
         *        The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key-value pair..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for the URL endpoint type.
         * </p>
         * 
         * @param urlEndpoint
         *        The configuration for the URL endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlEndpoint(UrlEndpointInput urlEndpoint);

        /**
         * <p>
         * The configuration for the URL endpoint type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlEndpointInput.Builder} avoiding the
         * need to create one manually via {@link UrlEndpointInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UrlEndpointInput.Builder#build()} is called immediately and its
         * result is passed to {@link #urlEndpoint(UrlEndpointInput)}.
         * 
         * @param urlEndpoint
         *        a consumer that will call methods on {@link UrlEndpointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlEndpoint(UrlEndpointInput)
         */
        default Builder urlEndpoint(Consumer<UrlEndpointInput.Builder> urlEndpoint) {
            return urlEndpoint(UrlEndpointInput.builder().applyMutation(urlEndpoint).build());
        }

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesRequest.BuilderImpl implements Builder {
        private String applicationIdentifier;

        private String clientToken;

        private String description;

        private String endpointType;

        private String environmentIdentifier;

        private LambdaEndpointInput lambdaEndpoint;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UrlEndpointInput urlEndpoint;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            applicationIdentifier(model.applicationIdentifier);
            clientToken(model.clientToken);
            description(model.description);
            endpointType(model.endpointType);
            environmentIdentifier(model.environmentIdentifier);
            lambdaEndpoint(model.lambdaEndpoint);
            name(model.name);
            tags(model.tags);
            urlEndpoint(model.urlEndpoint);
            vpcId(model.vpcId);
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ServiceEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final LambdaEndpointInput.Builder getLambdaEndpoint() {
            return lambdaEndpoint != null ? lambdaEndpoint.toBuilder() : null;
        }

        public final void setLambdaEndpoint(LambdaEndpointInput.BuilderImpl lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint != null ? lambdaEndpoint.build() : null;
        }

        @Override
        public final Builder lambdaEndpoint(LambdaEndpointInput lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UrlEndpointInput.Builder getUrlEndpoint() {
            return urlEndpoint != null ? urlEndpoint.toBuilder() : null;
        }

        public final void setUrlEndpoint(UrlEndpointInput.BuilderImpl urlEndpoint) {
            this.urlEndpoint = urlEndpoint != null ? urlEndpoint.build() : null;
        }

        @Override
        public final Builder urlEndpoint(UrlEndpointInput urlEndpoint) {
            this.urlEndpoint = urlEndpoint;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
