/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A combination of existing analysis statuses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisStatusUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisStatusUnion.Builder, AnalysisStatusUnion> {
    private static final SdkField<String> RUNTIME_ANALYSIS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeAnalysisStatus").getter(getter(AnalysisStatusUnion::runtimeAnalysisStatusAsString))
            .setter(setter(Builder::runtimeAnalysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeAnalysisStatus").build())
            .build();

    private static final SdkField<String> SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("srcCodeOrDbAnalysisStatus")
            .getter(getter(AnalysisStatusUnion::srcCodeOrDbAnalysisStatusAsString))
            .setter(setter(Builder::srcCodeOrDbAnalysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srcCodeOrDbAnalysisStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_ANALYSIS_STATUS_FIELD,
            SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String runtimeAnalysisStatus;

    private final String srcCodeOrDbAnalysisStatus;

    private final Type type;

    private AnalysisStatusUnion(BuilderImpl builder) {
        this.runtimeAnalysisStatus = builder.runtimeAnalysisStatus;
        this.srcCodeOrDbAnalysisStatus = builder.srcCodeOrDbAnalysisStatus;
        this.type = builder.type;
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeAnalysisStatus} will return {@link RuntimeAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #runtimeAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see RuntimeAnalysisStatus
     */
    public final RuntimeAnalysisStatus runtimeAnalysisStatus() {
        return RuntimeAnalysisStatus.fromValue(runtimeAnalysisStatus);
    }

    /**
     * <p>
     * The status of the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeAnalysisStatus} will return {@link RuntimeAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #runtimeAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the analysis.
     * @see RuntimeAnalysisStatus
     */
    public final String runtimeAnalysisStatusAsString() {
        return runtimeAnalysisStatus;
    }

    /**
     * <p>
     * The status of the source code or database analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #srcCodeOrDbAnalysisStatus} will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #srcCodeOrDbAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the source code or database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus() {
        return SrcCodeOrDbAnalysisStatus.fromValue(srcCodeOrDbAnalysisStatus);
    }

    /**
     * <p>
     * The status of the source code or database analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #srcCodeOrDbAnalysisStatus} will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #srcCodeOrDbAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of the source code or database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final String srcCodeOrDbAnalysisStatusAsString() {
        return srcCodeOrDbAnalysisStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAnalysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(srcCodeOrDbAnalysisStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisStatusUnion)) {
            return false;
        }
        AnalysisStatusUnion other = (AnalysisStatusUnion) obj;
        return Objects.equals(runtimeAnalysisStatusAsString(), other.runtimeAnalysisStatusAsString())
                && Objects.equals(srcCodeOrDbAnalysisStatusAsString(), other.srcCodeOrDbAnalysisStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisStatusUnion").add("RuntimeAnalysisStatus", runtimeAnalysisStatusAsString())
                .add("SrcCodeOrDbAnalysisStatus", srcCodeOrDbAnalysisStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runtimeAnalysisStatus":
            return Optional.ofNullable(clazz.cast(runtimeAnalysisStatusAsString()));
        case "srcCodeOrDbAnalysisStatus":
            return Optional.ofNullable(clazz.cast(srcCodeOrDbAnalysisStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #runtimeAnalysisStatusAsString()} initialized to the given value.
     *
     * <p>
     * The status of the analysis.
     * </p>
     * 
     * @param runtimeAnalysisStatus
     *        The status of the analysis.
     * @see RuntimeAnalysisStatus
     */
    public static AnalysisStatusUnion fromRuntimeAnalysisStatus(String runtimeAnalysisStatus) {
        return builder().runtimeAnalysisStatus(runtimeAnalysisStatus).build();
    }

    /**
     * Create an instance of this class with {@link #runtimeAnalysisStatusAsString()} initialized to the given value.
     *
     * <p>
     * The status of the analysis.
     * </p>
     * 
     * @param runtimeAnalysisStatus
     *        The status of the analysis.
     * @see RuntimeAnalysisStatus
     */
    public static AnalysisStatusUnion fromRuntimeAnalysisStatus(RuntimeAnalysisStatus runtimeAnalysisStatus) {
        return builder().runtimeAnalysisStatus(runtimeAnalysisStatus).build();
    }

    /**
     * Create an instance of this class with {@link #srcCodeOrDbAnalysisStatusAsString()} initialized to the given
     * value.
     *
     * <p>
     * The status of the source code or database analysis.
     * </p>
     * 
     * @param srcCodeOrDbAnalysisStatus
     *        The status of the source code or database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public static AnalysisStatusUnion fromSrcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
        return builder().srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus).build();
    }

    /**
     * Create an instance of this class with {@link #srcCodeOrDbAnalysisStatusAsString()} initialized to the given
     * value.
     *
     * <p>
     * The status of the source code or database analysis.
     * </p>
     * 
     * @param srcCodeOrDbAnalysisStatus
     *        The status of the source code or database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public static AnalysisStatusUnion fromSrcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus) {
        return builder().srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisStatusUnion, T> g) {
        return obj -> g.apply((AnalysisStatusUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisStatusUnion> {
        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param runtimeAnalysisStatus
         *        The status of the analysis.
         * @see RuntimeAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeAnalysisStatus
         */
        Builder runtimeAnalysisStatus(String runtimeAnalysisStatus);

        /**
         * <p>
         * The status of the analysis.
         * </p>
         * 
         * @param runtimeAnalysisStatus
         *        The status of the analysis.
         * @see RuntimeAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeAnalysisStatus
         */
        Builder runtimeAnalysisStatus(RuntimeAnalysisStatus runtimeAnalysisStatus);

        /**
         * <p>
         * The status of the source code or database analysis.
         * </p>
         * 
         * @param srcCodeOrDbAnalysisStatus
         *        The status of the source code or database analysis.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder srcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus);

        /**
         * <p>
         * The status of the source code or database analysis.
         * </p>
         * 
         * @param srcCodeOrDbAnalysisStatus
         *        The status of the source code or database analysis.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus);
    }

    static final class BuilderImpl implements Builder {
        private String runtimeAnalysisStatus;

        private String srcCodeOrDbAnalysisStatus;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisStatusUnion model) {
            runtimeAnalysisStatus(model.runtimeAnalysisStatus);
            srcCodeOrDbAnalysisStatus(model.srcCodeOrDbAnalysisStatus);
        }

        public final String getRuntimeAnalysisStatus() {
            return runtimeAnalysisStatus;
        }

        public final void setRuntimeAnalysisStatus(String runtimeAnalysisStatus) {
            Object oldValue = this.runtimeAnalysisStatus;
            this.runtimeAnalysisStatus = runtimeAnalysisStatus;
            handleUnionValueChange(Type.RUNTIME_ANALYSIS_STATUS, oldValue, this.runtimeAnalysisStatus);
        }

        @Override
        public final Builder runtimeAnalysisStatus(String runtimeAnalysisStatus) {
            Object oldValue = this.runtimeAnalysisStatus;
            this.runtimeAnalysisStatus = runtimeAnalysisStatus;
            handleUnionValueChange(Type.RUNTIME_ANALYSIS_STATUS, oldValue, this.runtimeAnalysisStatus);
            return this;
        }

        @Override
        public final Builder runtimeAnalysisStatus(RuntimeAnalysisStatus runtimeAnalysisStatus) {
            this.runtimeAnalysisStatus(runtimeAnalysisStatus == null ? null : runtimeAnalysisStatus.toString());
            return this;
        }

        public final String getSrcCodeOrDbAnalysisStatus() {
            return srcCodeOrDbAnalysisStatus;
        }

        public final void setSrcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            Object oldValue = this.srcCodeOrDbAnalysisStatus;
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
            handleUnionValueChange(Type.SRC_CODE_OR_DB_ANALYSIS_STATUS, oldValue, this.srcCodeOrDbAnalysisStatus);
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            Object oldValue = this.srcCodeOrDbAnalysisStatus;
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
            handleUnionValueChange(Type.SRC_CODE_OR_DB_ANALYSIS_STATUS, oldValue, this.srcCodeOrDbAnalysisStatus);
            return this;
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus) {
            this.srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus == null ? null : srcCodeOrDbAnalysisStatus.toString());
            return this;
        }

        @Override
        public AnalysisStatusUnion build() {
            return new AnalysisStatusUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalysisStatusUnion#type()
     */
    public enum Type {
        RUNTIME_ANALYSIS_STATUS,

        SRC_CODE_OR_DB_ANALYSIS_STATUS,

        UNKNOWN_TO_SDK_VERSION
    }
}
