/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.migrationhubstrategy.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ConflictException;
import software.amazon.awssdk.services.migrationhubstrategy.model.DependencyException;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.InternalServerException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyException;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServiceLinkedRoleLockClientException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ValidationException;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable;

/**
 * Service client for accessing Migration Hub Strategy Recommendations. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * <fullname>Migration Hub Strategy Recommendations</fullname>
 * <p>
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for
 * Migration Hub Strategy Recommendations (Strategy Recommendations). The topic for each action shows the API request
 * parameters and the response. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the
 * programming language or platform that you're using. For more information, see <a
 * href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubStrategyClient extends AwsClient {
    String SERVICE_NAME = "migrationhub-strategy";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "migrationhub-strategy";

    /**
     * <p>
     * Retrieves details about an application component.
     * </p>
     *
     * @param getApplicationComponentDetailsRequest
     * @return Result of the GetApplicationComponentDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetApplicationComponentDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationComponentDetailsResponse getApplicationComponentDetails(
            GetApplicationComponentDetailsRequest getApplicationComponentDetailsRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an application component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationComponentDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationComponentDetailsRequest#builder()}
     * </p>
     *
     * @param getApplicationComponentDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest.Builder}
     *        to create a request.
     * @return Result of the GetApplicationComponentDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetApplicationComponentDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationComponentDetailsResponse getApplicationComponentDetails(
            Consumer<GetApplicationComponentDetailsRequest.Builder> getApplicationComponentDetailsRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return getApplicationComponentDetails(GetApplicationComponentDetailsRequest.builder()
                .applyMutation(getApplicationComponentDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
     * </p>
     *
     * @param getApplicationComponentStrategiesRequest
     * @return Result of the GetApplicationComponentStrategies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetApplicationComponentStrategies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationComponentStrategiesResponse getApplicationComponentStrategies(
            GetApplicationComponentStrategiesRequest getApplicationComponentStrategiesRequest) throws ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationComponentStrategiesRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationComponentStrategiesRequest#builder()}
     * </p>
     *
     * @param getApplicationComponentStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest.Builder}
     *        to create a request.
     * @return Result of the GetApplicationComponentStrategies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetApplicationComponentStrategies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationComponentStrategiesResponse getApplicationComponentStrategies(
            Consumer<GetApplicationComponentStrategiesRequest.Builder> getApplicationComponentStrategiesRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return getApplicationComponentStrategies(GetApplicationComponentStrategiesRequest.builder()
                .applyMutation(getApplicationComponentStrategiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of an on-going assessment.
     * </p>
     *
     * @param getAssessmentRequest
     * @return Result of the GetAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentResponse getAssessment(GetAssessmentRequest getAssessmentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of an on-going assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssessmentRequest#builder()}
     * </p>
     *
     * @param getAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentRequest.Builder} to create
     *        a request.
     * @return Result of the GetAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssessmentResponse getAssessment(Consumer<GetAssessmentRequest.Builder> getAssessmentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getAssessment(GetAssessmentRequest.builder().applyMutation(getAssessmentRequest).build());
    }

    /**
     * <p>
     * Retrieves the details about a specific import task.
     * </p>
     *
     * @param getImportFileTaskRequest
     * @return Result of the GetImportFileTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetImportFileTaskResponse getImportFileTask(GetImportFileTaskRequest getImportFileTaskRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details about a specific import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportFileTaskRequest.Builder} avoiding the need
     * to create one manually via {@link GetImportFileTaskRequest#builder()}
     * </p>
     *
     * @param getImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskRequest.Builder} to
     *        create a request.
     * @return Result of the GetImportFileTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetImportFileTaskResponse getImportFileTask(Consumer<GetImportFileTaskRequest.Builder> getImportFileTaskRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getImportFileTask(GetImportFileTaskRequest.builder().applyMutation(getImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Retrieve the latest ID of a specific assessment task.
     * </p>
     *
     * @param getLatestAssessmentIdRequest
     * @return Result of the GetLatestAssessmentId operation returned by the service.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetLatestAssessmentId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLatestAssessmentIdResponse getLatestAssessmentId(GetLatestAssessmentIdRequest getLatestAssessmentIdRequest)
            throws DependencyException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the latest ID of a specific assessment task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLatestAssessmentIdRequest.Builder} avoiding the
     * need to create one manually via {@link GetLatestAssessmentIdRequest#builder()}
     * </p>
     *
     * @param getLatestAssessmentIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest.Builder} to
     *        create a request.
     * @return Result of the GetLatestAssessmentId operation returned by the service.
     * @throws DependencyException
     *         Dependency encountered an error.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetLatestAssessmentId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLatestAssessmentIdResponse getLatestAssessmentId(
            Consumer<GetLatestAssessmentIdRequest.Builder> getLatestAssessmentIdRequest) throws DependencyException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return getLatestAssessmentId(GetLatestAssessmentIdRequest.builder().applyMutation(getLatestAssessmentIdRequest).build());
    }

    /**
     * <p>
     * Retrieves your migration and modernization preferences.
     * </p>
     *
     * @param getPortfolioPreferencesRequest
     * @return Result of the GetPortfolioPreferences operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortfolioPreferencesResponse getPortfolioPreferences(GetPortfolioPreferencesRequest getPortfolioPreferencesRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your migration and modernization preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortfolioPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link GetPortfolioPreferencesRequest#builder()}
     * </p>
     *
     * @param getPortfolioPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest.Builder}
     *        to create a request.
     * @return Result of the GetPortfolioPreferences operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortfolioPreferencesResponse getPortfolioPreferences(
            Consumer<GetPortfolioPreferencesRequest.Builder> getPortfolioPreferencesRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return getPortfolioPreferences(GetPortfolioPreferencesRequest.builder().applyMutation(getPortfolioPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
     * </p>
     *
     * @param getPortfolioSummaryRequest
     * @return Result of the GetPortfolioSummary operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetPortfolioSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortfolioSummaryResponse getPortfolioSummary(GetPortfolioSummaryRequest getPortfolioSummaryRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortfolioSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetPortfolioSummaryRequest#builder()}
     * </p>
     *
     * @param getPortfolioSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryRequest.Builder} to
     *        create a request.
     * @return Result of the GetPortfolioSummary operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetPortfolioSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortfolioSummaryResponse getPortfolioSummary(
            Consumer<GetPortfolioSummaryRequest.Builder> getPortfolioSummaryRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getPortfolioSummary(GetPortfolioSummaryRequest.builder().applyMutation(getPortfolioSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the specified recommendation report.
     * </p>
     *
     * @param getRecommendationReportDetailsRequest
     * @return Result of the GetRecommendationReportDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetRecommendationReportDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationReportDetailsResponse getRecommendationReportDetails(
            GetRecommendationReportDetailsRequest getRecommendationReportDetailsRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the specified recommendation report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationReportDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommendationReportDetailsRequest#builder()}
     * </p>
     *
     * @param getRecommendationReportDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest.Builder}
     *        to create a request.
     * @return Result of the GetRecommendationReportDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetRecommendationReportDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationReportDetailsResponse getRecommendationReportDetails(
            Consumer<GetRecommendationReportDetailsRequest.Builder> getRecommendationReportDetailsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getRecommendationReportDetails(GetRecommendationReportDetailsRequest.builder()
                .applyMutation(getRecommendationReportDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     *
     * @param getServerDetailsRequest
     * @return Result of the GetServerDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsResponse getServerDetails(GetServerDetailsRequest getServerDetailsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetServerDetailsRequest#builder()}
     * </p>
     *
     * @param getServerDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GetServerDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsResponse getServerDetails(Consumer<GetServerDetailsRequest.Builder> getServerDetailsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getServerDetails(GetServerDetailsRequest.builder().applyMutation(getServerDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client.getServerDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client
     *             .getServerDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client.getServerDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getServerDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsIterable getServerDetailsPaginator(GetServerDetailsRequest getServerDetailsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return new GetServerDetailsIterable(this, getServerDetailsRequest);
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client.getServerDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client
     *             .getServerDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsIterable responses = client.getServerDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetServerDetailsRequest#builder()}
     * </p>
     *
     * @param getServerDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsIterable getServerDetailsPaginator(Consumer<GetServerDetailsRequest.Builder> getServerDetailsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return getServerDetailsPaginator(GetServerDetailsRequest.builder().applyMutation(getServerDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves recommended strategies and tools for the specified server.
     * </p>
     *
     * @param getServerStrategiesRequest
     * @return Result of the GetServerStrategies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerStrategiesResponse getServerStrategies(GetServerStrategiesRequest getServerStrategiesRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves recommended strategies and tools for the specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerStrategiesRequest.Builder} avoiding the
     * need to create one manually via {@link GetServerStrategiesRequest#builder()}
     * </p>
     *
     * @param getServerStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesRequest.Builder} to
     *        create a request.
     * @return Result of the GetServerStrategies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.GetServerStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerStrategiesResponse getServerStrategies(
            Consumer<GetServerStrategiesRequest.Builder> getServerStrategiesRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return getServerStrategies(GetServerStrategiesRequest.builder().applyMutation(getServerStrategiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        Represents input for ListAnalyzableServers operation.
     * @return Result of the ListAnalyzableServers operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersResponse listAnalyzableServers(ListAnalyzableServersRequest listAnalyzableServersRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzableServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzableServersRequest#builder()}
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest.Builder} to
     *        create a request. Represents input for ListAnalyzableServers operation.
     * @return Result of the ListAnalyzableServers operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersResponse listAnalyzableServers(
            Consumer<ListAnalyzableServersRequest.Builder> listAnalyzableServersRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return listAnalyzableServers(ListAnalyzableServersRequest.builder().applyMutation(listAnalyzableServersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client.listAnalyzableServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client
     *             .listAnalyzableServersPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client.listAnalyzableServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        Represents input for ListAnalyzableServers operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersIterable listAnalyzableServersPaginator(ListAnalyzableServersRequest listAnalyzableServersRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return new ListAnalyzableServersIterable(this, listAnalyzableServersRequest);
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client.listAnalyzableServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client
     *             .listAnalyzableServersPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersIterable responses = client.listAnalyzableServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzableServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzableServersRequest#builder()}
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest.Builder} to
     *        create a request. Represents input for ListAnalyzableServers operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersIterable listAnalyzableServersPaginator(
            Consumer<ListAnalyzableServersRequest.Builder> listAnalyzableServersRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return listAnalyzableServersPaginator(ListAnalyzableServersRequest.builder().applyMutation(listAnalyzableServersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     *
     * @param listApplicationComponentsRequest
     * @return Result of the ListApplicationComponents operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ServiceLinkedRoleLockClientException
     *         Exception to indicate that the service-linked role (SLR) is locked.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsResponse listApplicationComponents(
            ListApplicationComponentsRequest listApplicationComponentsRequest) throws AccessDeniedException,
            ServiceLinkedRoleLockClientException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationComponentsRequest#builder()}
     * </p>
     *
     * @param listApplicationComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationComponents operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ServiceLinkedRoleLockClientException
     *         Exception to indicate that the service-linked role (SLR) is locked.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsResponse listApplicationComponents(
            Consumer<ListApplicationComponentsRequest.Builder> listApplicationComponentsRequest) throws AccessDeniedException,
            ServiceLinkedRoleLockClientException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listApplicationComponents(ListApplicationComponentsRequest.builder()
                .applyMutation(listApplicationComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client.listApplicationComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client
     *             .listApplicationComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client.listApplicationComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ServiceLinkedRoleLockClientException
     *         Exception to indicate that the service-linked role (SLR) is locked.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsIterable listApplicationComponentsPaginator(
            ListApplicationComponentsRequest listApplicationComponentsRequest) throws AccessDeniedException,
            ServiceLinkedRoleLockClientException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return new ListApplicationComponentsIterable(this, listApplicationComponentsRequest);
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client.listApplicationComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client
     *             .listApplicationComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsIterable responses = client.listApplicationComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationComponentsRequest#builder()}
     * </p>
     *
     * @param listApplicationComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ServiceLinkedRoleLockClientException
     *         Exception to indicate that the service-linked role (SLR) is locked.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsIterable listApplicationComponentsPaginator(
            Consumer<ListApplicationComponentsRequest.Builder> listApplicationComponentsRequest) throws AccessDeniedException,
            ServiceLinkedRoleLockClientException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listApplicationComponentsPaginator(ListApplicationComponentsRequest.builder()
                .applyMutation(listApplicationComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     *
     * @param listCollectorsRequest
     * @return Result of the ListCollectors operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsResponse listCollectors(ListCollectorsRequest listCollectorsRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCollectorsRequest#builder()}
     * </p>
     *
     * @param listCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest.Builder} to create
     *        a request.
     * @return Result of the ListCollectors operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsResponse listCollectors(Consumer<ListCollectorsRequest.Builder> listCollectorsRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listCollectors(ListCollectorsRequest.builder().applyMutation(listCollectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client.listCollectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client
     *             .listCollectorsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client.listCollectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsIterable listCollectorsPaginator(ListCollectorsRequest listCollectorsRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return new ListCollectorsIterable(this, listCollectorsRequest);
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client.listCollectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client
     *             .listCollectorsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsIterable responses = client.listCollectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCollectorsRequest#builder()}
     * </p>
     *
     * @param listCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsIterable listCollectorsPaginator(Consumer<ListCollectorsRequest.Builder> listCollectorsRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listCollectorsPaginator(ListCollectorsRequest.builder().applyMutation(listCollectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     *
     * @param listImportFileTaskRequest
     * @return Result of the ListImportFileTask operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskResponse listImportFileTask(ListImportFileTaskRequest listImportFileTaskRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFileTaskRequest#builder()}
     * </p>
     *
     * @param listImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest.Builder} to
     *        create a request.
     * @return Result of the ListImportFileTask operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskResponse listImportFileTask(Consumer<ListImportFileTaskRequest.Builder> listImportFileTaskRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listImportFileTask(ListImportFileTaskRequest.builder().applyMutation(listImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client.listImportFileTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client
     *             .listImportFileTaskPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client.listImportFileTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportFileTaskRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskIterable listImportFileTaskPaginator(ListImportFileTaskRequest listImportFileTaskRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return new ListImportFileTaskIterable(this, listImportFileTaskRequest);
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client.listImportFileTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client
     *             .listImportFileTaskPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskIterable responses = client.listImportFileTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFileTaskRequest#builder()}
     * </p>
     *
     * @param listImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskIterable listImportFileTaskPaginator(
            Consumer<ListImportFileTaskRequest.Builder> listImportFileTaskRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return listImportFileTaskPaginator(ListImportFileTaskRequest.builder().applyMutation(listImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     *
     * @param listServersRequest
     * @return Result of the ListServers operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersResponse listServers(ListServersRequest listServersRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest.Builder} to create a
     *        request.
     * @return Result of the ListServers operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersResponse listServers(Consumer<ListServersRequest.Builder> listServersRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listServers(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client
     *             .listServersPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersIterable listServersPaginator(ListServersRequest listServersRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        return new ListServersIterable(this, listServersRequest);
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client
     *             .listServersPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersIterable listServersPaginator(Consumer<ListServersRequest.Builder> listServersRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return listServersPaginator(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Saves the specified migration and modernization preferences.
     * </p>
     *
     * @param putPortfolioPreferencesRequest
     * @return Result of the PutPortfolioPreferences operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws ConflictException
     *         Exception to indicate that there is an ongoing task when a new task is created. Return when once the
     *         existing tasks are complete.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.PutPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPortfolioPreferencesResponse putPortfolioPreferences(PutPortfolioPreferencesRequest putPortfolioPreferencesRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves the specified migration and modernization preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPortfolioPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link PutPortfolioPreferencesRequest#builder()}
     * </p>
     *
     * @param putPortfolioPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest.Builder}
     *        to create a request.
     * @return Result of the PutPortfolioPreferences operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws ConflictException
     *         Exception to indicate that there is an ongoing task when a new task is created. Return when once the
     *         existing tasks are complete.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.PutPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPortfolioPreferencesResponse putPortfolioPreferences(
            Consumer<PutPortfolioPreferencesRequest.Builder> putPortfolioPreferencesRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return putPortfolioPreferences(PutPortfolioPreferencesRequest.builder().applyMutation(putPortfolioPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Starts the assessment of an on-premises environment.
     * </p>
     *
     * @param startAssessmentRequest
     * @return Result of the StartAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The AWS account has reached its quota of imports. Contact AWS Support to increase the quota for this
     *         account.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAssessmentResponse startAssessment(StartAssessmentRequest startAssessmentRequest) throws AccessDeniedException,
            ThrottlingException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the assessment of an on-premises environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link StartAssessmentRequest#builder()}
     * </p>
     *
     * @param startAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentRequest.Builder} to
     *        create a request.
     * @return Result of the StartAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The AWS account has reached its quota of imports. Contact AWS Support to increase the quota for this
     *         account.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAssessmentResponse startAssessment(Consumer<StartAssessmentRequest.Builder> startAssessmentRequest)
            throws AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return startAssessment(StartAssessmentRequest.builder().applyMutation(startAssessmentRequest).build());
    }

    /**
     * <p>
     * Starts a file import.
     * </p>
     *
     * @param startImportFileTaskRequest
     * @return Result of the StartImportFileTask operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The AWS account has reached its quota of imports. Contact AWS Support to increase the quota for this
     *         account.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartImportFileTaskResponse startImportFileTask(StartImportFileTaskRequest startImportFileTaskRequest)
            throws AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a file import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartImportFileTaskRequest#builder()}
     * </p>
     *
     * @param startImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskRequest.Builder} to
     *        create a request.
     * @return Result of the StartImportFileTask operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         The AWS account has reached its quota of imports. Contact AWS Support to increase the quota for this
     *         account.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartImportFileTaskResponse startImportFileTask(
            Consumer<StartImportFileTaskRequest.Builder> startImportFileTaskRequest) throws AccessDeniedException,
            ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return startImportFileTask(StartImportFileTaskRequest.builder().applyMutation(startImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Starts generating a recommendation report.
     * </p>
     *
     * @param startRecommendationReportGenerationRequest
     * @return Result of the StartRecommendationReportGeneration operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws ConflictException
     *         Exception to indicate that there is an ongoing task when a new task is created. Return when once the
     *         existing tasks are complete.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartRecommendationReportGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRecommendationReportGenerationResponse startRecommendationReportGeneration(
            StartRecommendationReportGenerationRequest startRecommendationReportGenerationRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts generating a recommendation report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRecommendationReportGenerationRequest.Builder}
     * avoiding the need to create one manually via {@link StartRecommendationReportGenerationRequest#builder()}
     * </p>
     *
     * @param startRecommendationReportGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest.Builder}
     *        to create a request.
     * @return Result of the StartRecommendationReportGeneration operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws ConflictException
     *         Exception to indicate that there is an ongoing task when a new task is created. Return when once the
     *         existing tasks are complete.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StartRecommendationReportGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRecommendationReportGenerationResponse startRecommendationReportGeneration(
            Consumer<StartRecommendationReportGenerationRequest.Builder> startRecommendationReportGenerationRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return startRecommendationReportGeneration(StartRecommendationReportGenerationRequest.builder()
                .applyMutation(startRecommendationReportGenerationRequest).build());
    }

    /**
     * <p>
     * Stops the assessment of an on-premises environment.
     * </p>
     *
     * @param stopAssessmentRequest
     * @return Result of the StopAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StopAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StopAssessmentResponse stopAssessment(StopAssessmentRequest stopAssessmentRequest) throws AccessDeniedException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the assessment of an on-premises environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link StopAssessmentRequest#builder()}
     * </p>
     *
     * @param stopAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentRequest.Builder} to create
     *        a request.
     * @return Result of the StopAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         The user does not have permission to perform the action. Check the AWS Identity and Access Management
     *         (IAM) policy associated with this user.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.StopAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StopAssessmentResponse stopAssessment(Consumer<StopAssessmentRequest.Builder> stopAssessmentRequest)
            throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MigrationHubStrategyException {
        return stopAssessment(StopAssessmentRequest.builder().applyMutation(stopAssessmentRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an application component.
     * </p>
     *
     * @param updateApplicationComponentConfigRequest
     * @return Result of the UpdateApplicationComponentConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.UpdateApplicationComponentConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationComponentConfigResponse updateApplicationComponentConfig(
            UpdateApplicationComponentConfigRequest updateApplicationComponentConfigRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an application component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationComponentConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApplicationComponentConfigRequest#builder()}
     * </p>
     *
     * @param updateApplicationComponentConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateApplicationComponentConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.UpdateApplicationComponentConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationComponentConfigResponse updateApplicationComponentConfig(
            Consumer<UpdateApplicationComponentConfigRequest.Builder> updateApplicationComponentConfigRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return updateApplicationComponentConfig(UpdateApplicationComponentConfigRequest.builder()
                .applyMutation(updateApplicationComponentConfigRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the specified server.
     * </p>
     *
     * @param updateServerConfigRequest
     * @return Result of the UpdateServerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.UpdateServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServerConfigResponse updateServerConfig(UpdateServerConfigRequest updateServerConfigRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServerConfigRequest#builder()}
     * </p>
     *
     * @param updateServerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateServerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ID in the request is not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request body isn't valid.
     * @throws InternalServerException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubStrategyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubStrategyClient.UpdateServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServerConfigResponse updateServerConfig(Consumer<UpdateServerConfigRequest.Builder> updateServerConfigRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MigrationHubStrategyException {
        return updateServerConfig(UpdateServerConfigRequest.builder().applyMutation(updateServerConfigRequest).build());
    }

    /**
     * Create a {@link MigrationHubStrategyClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubStrategyClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubStrategyClient}.
     */
    static MigrationHubStrategyClientBuilder builder() {
        return new DefaultMigrationHubStrategyClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MigrationHubStrategyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
