/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrokerResponse extends MqResponse implements
        ToCopyableBuilder<UpdateBrokerResponse.Builder, UpdateBrokerResponse> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationStrategy").getter(getter(UpdateBrokerResponse::authenticationStrategyAsString))
            .setter(setter(Builder::authenticationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(UpdateBrokerResponse::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerId").getter(getter(UpdateBrokerResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField
            .<ConfigurationId> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateBrokerResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(UpdateBrokerResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostInstanceType").getter(getter(UpdateBrokerResponse::hostInstanceType))
            .setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<LdapServerMetadataOutput> LDAP_SERVER_METADATA_FIELD = SdkField
            .<LdapServerMetadataOutput> builder(MarshallingType.SDK_POJO).memberName("LdapServerMetadata")
            .getter(getter(UpdateBrokerResponse::ldapServerMetadata)).setter(setter(Builder::ldapServerMetadata))
            .constructor(LdapServerMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build())
            .build();

    private static final SdkField<Logs> LOGS_FIELD = SdkField.<Logs> builder(MarshallingType.SDK_POJO).memberName("Logs")
            .getter(getter(UpdateBrokerResponse::logs)).setter(setter(Builder::logs)).constructor(Logs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<WeeklyStartTime> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceWindowStartTime")
            .getter(getter(UpdateBrokerResponse::maintenanceWindowStartTime))
            .setter(setter(Builder::maintenanceWindowStartTime))
            .constructor(WeeklyStartTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(UpdateBrokerResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataReplicationMetadataOutput> DATA_REPLICATION_METADATA_FIELD = SdkField
            .<DataReplicationMetadataOutput> builder(MarshallingType.SDK_POJO).memberName("DataReplicationMetadata")
            .getter(getter(UpdateBrokerResponse::dataReplicationMetadata)).setter(setter(Builder::dataReplicationMetadata))
            .constructor(DataReplicationMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMetadata").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataReplicationMode").getter(getter(UpdateBrokerResponse::dataReplicationModeAsString))
            .setter(setter(Builder::dataReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMode").build())
            .build();

    private static final SdkField<DataReplicationMetadataOutput> PENDING_DATA_REPLICATION_METADATA_FIELD = SdkField
            .<DataReplicationMetadataOutput> builder(MarshallingType.SDK_POJO)
            .memberName("PendingDataReplicationMetadata")
            .getter(getter(UpdateBrokerResponse::pendingDataReplicationMetadata))
            .setter(setter(Builder::pendingDataReplicationMetadata))
            .constructor(DataReplicationMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDataReplicationMetadata")
                    .build()).build();

    private static final SdkField<String> PENDING_DATA_REPLICATION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PendingDataReplicationMode")
            .getter(getter(UpdateBrokerResponse::pendingDataReplicationModeAsString))
            .setter(setter(Builder::pendingDataReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDataReplicationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ID_FIELD, CONFIGURATION_FIELD, ENGINE_VERSION_FIELD,
            HOST_INSTANCE_TYPE_FIELD, LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD,
            SECURITY_GROUPS_FIELD, DATA_REPLICATION_METADATA_FIELD, DATA_REPLICATION_MODE_FIELD,
            PENDING_DATA_REPLICATION_METADATA_FIELD, PENDING_DATA_REPLICATION_MODE_FIELD));

    private final String authenticationStrategy;

    private final Boolean autoMinorVersionUpgrade;

    private final String brokerId;

    private final ConfigurationId configuration;

    private final String engineVersion;

    private final String hostInstanceType;

    private final LdapServerMetadataOutput ldapServerMetadata;

    private final Logs logs;

    private final WeeklyStartTime maintenanceWindowStartTime;

    private final List<String> securityGroups;

    private final DataReplicationMetadataOutput dataReplicationMetadata;

    private final String dataReplicationMode;

    private final DataReplicationMetadataOutput pendingDataReplicationMetadata;

    private final String pendingDataReplicationMode;

    private UpdateBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.securityGroups = builder.securityGroups;
        this.dataReplicationMetadata = builder.dataReplicationMetadata;
        this.dataReplicationMode = builder.dataReplicationMode;
        this.pendingDataReplicationMetadata = builder.pendingDataReplicationMetadata;
        this.pendingDataReplicationMode = builder.pendingDataReplicationMode;
    }

    /**
     * <p>
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(authenticationStrategy);
    }

    /**
     * <p>
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final String authenticationStrategyAsString() {
        return authenticationStrategy;
    }

    /**
     * <p>
     * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as new
     * versions are released and supported by Amazon MQ.
     * </p>
     * 
     * @return The new boolean value that specifies whether broker engines automatically upgrade to new minor versions
     *         as new versions are released and supported by Amazon MQ.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Required. The unique ID that Amazon MQ generates for the broker.
     * </p>
     * 
     * @return Required. The unique ID that Amazon MQ generates for the broker.
     */
    public final String brokerId() {
        return brokerId;
    }

    /**
     * <p>
     * The ID of the updated configuration.
     * </p>
     * 
     * @return The ID of the updated configuration.
     */
    public final ConfigurationId configuration() {
        return configuration;
    }

    /**
     * <p>
     * The broker engine version to upgrade to. For a list of supported engine versions, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.
     * </p>
     * 
     * @return The broker engine version to upgrade to. For a list of supported engine versions, see <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
     *         engines</a>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The broker's host instance type to upgrade to. For a list of supported instance types, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker
     * instance types</a>.
     * </p>
     * 
     * @return The broker's host instance type to upgrade to. For a list of supported instance types, see <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types"
     *         >Broker instance types</a>.
     */
    public final String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * <p>
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not
     * apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     *         Does not apply to RabbitMQ brokers.
     */
    public final LdapServerMetadataOutput ldapServerMetadata() {
        return ldapServerMetadata;
    }

    /**
     * <p>
     * The list of information about logs to be enabled for the specified broker.
     * </p>
     * 
     * @return The list of information about logs to be enabled for the specified broker.
     */
    public final Logs logs() {
        return logs;
    }

    /**
     * <p>
     * The parameters that determine the WeeklyStartTime.
     * </p>
     * 
     * @return The parameters that determine the WeeklyStartTime.
     */
    public final WeeklyStartTime maintenanceWindowStartTime() {
        return maintenanceWindowStartTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to
     * CRDR.
     * </p>
     * 
     * @return The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is
     *         set to CRDR.
     */
    public final DataReplicationMetadataOutput dataReplicationMetadata() {
        return dataReplicationMetadata;
    }

    /**
     * <p>
     * Describes whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final DataReplicationMode dataReplicationMode() {
        return DataReplicationMode.fromValue(dataReplicationMode);
    }

    /**
     * <p>
     * Describes whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final String dataReplicationModeAsString() {
        return dataReplicationMode;
    }

    /**
     * <p>
     * The pending replication details of the data replication-enabled broker. Only returned if
     * pendingDataReplicationMode is set to CRDR.
     * </p>
     * 
     * @return The pending replication details of the data replication-enabled broker. Only returned if
     *         pendingDataReplicationMode is set to CRDR.
     */
    public final DataReplicationMetadataOutput pendingDataReplicationMetadata() {
        return pendingDataReplicationMetadata;
    }

    /**
     * <p>
     * Describes whether this broker will be a part of a data replication pair after reboot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingDataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pendingDataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker will be a part of a data replication pair after reboot.
     * @see DataReplicationMode
     */
    public final DataReplicationMode pendingDataReplicationMode() {
        return DataReplicationMode.fromValue(pendingDataReplicationMode);
    }

    /**
     * <p>
     * Describes whether this broker will be a part of a data replication pair after reboot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingDataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pendingDataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker will be a part of a data replication pair after reboot.
     * @see DataReplicationMode
     */
    public final String pendingDataReplicationModeAsString() {
        return pendingDataReplicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDataReplicationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDataReplicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerResponse)) {
            return false;
        }
        UpdateBrokerResponse other = (UpdateBrokerResponse) obj;
        return Objects.equals(authenticationStrategyAsString(), other.authenticationStrategyAsString())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(brokerId(), other.brokerId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(hostInstanceType(), other.hostInstanceType())
                && Objects.equals(ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(logs(), other.logs())
                && Objects.equals(maintenanceWindowStartTime(), other.maintenanceWindowStartTime())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(dataReplicationMetadata(), other.dataReplicationMetadata())
                && Objects.equals(dataReplicationModeAsString(), other.dataReplicationModeAsString())
                && Objects.equals(pendingDataReplicationMetadata(), other.pendingDataReplicationMetadata())
                && Objects.equals(pendingDataReplicationModeAsString(), other.pendingDataReplicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrokerResponse").add("AuthenticationStrategy", authenticationStrategyAsString())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("BrokerId", brokerId())
                .add("Configuration", configuration()).add("EngineVersion", engineVersion())
                .add("HostInstanceType", hostInstanceType()).add("LdapServerMetadata", ldapServerMetadata()).add("Logs", logs())
                .add("MaintenanceWindowStartTime", maintenanceWindowStartTime())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("DataReplicationMetadata", dataReplicationMetadata())
                .add("DataReplicationMode", dataReplicationModeAsString())
                .add("PendingDataReplicationMetadata", pendingDataReplicationMetadata())
                .add("PendingDataReplicationMode", pendingDataReplicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationStrategy":
            return Optional.ofNullable(clazz.cast(authenticationStrategyAsString()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "LdapServerMetadata":
            return Optional.ofNullable(clazz.cast(ldapServerMetadata()));
        case "Logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "MaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceWindowStartTime()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "DataReplicationMetadata":
            return Optional.ofNullable(clazz.cast(dataReplicationMetadata()));
        case "DataReplicationMode":
            return Optional.ofNullable(clazz.cast(dataReplicationModeAsString()));
        case "PendingDataReplicationMetadata":
            return Optional.ofNullable(clazz.cast(pendingDataReplicationMetadata()));
        case "PendingDataReplicationMode":
            return Optional.ofNullable(clazz.cast(pendingDataReplicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerResponse, T> g) {
        return obj -> g.apply((UpdateBrokerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrokerResponse> {
        /**
         * <p>
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(String authenticationStrategy);

        /**
         * <p>
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy);

        /**
         * <p>
         * The new boolean value that specifies whether broker engines automatically upgrade to new minor versions as
         * new versions are released and supported by Amazon MQ.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        The new boolean value that specifies whether broker engines automatically upgrade to new minor
         *        versions as new versions are released and supported by Amazon MQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Required. The unique ID that Amazon MQ generates for the broker.
         * </p>
         * 
         * @param brokerId
         *        Required. The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * <p>
         * The ID of the updated configuration.
         * </p>
         * 
         * @param configuration
         *        The ID of the updated configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConfigurationId configuration);

        /**
         * <p>
         * The ID of the updated configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationId.Builder} avoiding the
         * need to create one manually via {@link ConfigurationId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ConfigurationId)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConfigurationId)
         */
        default Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return configuration(ConfigurationId.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The broker engine version to upgrade to. For a list of supported engine versions, see <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         * engines</a>.
         * </p>
         * 
         * @param engineVersion
         *        The broker engine version to upgrade to. For a list of supported engine versions, see <a
         *        href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         *        engines</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The broker's host instance type to upgrade to. For a list of supported instance types, see <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker
         * instance types</a>.
         * </p>
         * 
         * @param hostInstanceType
         *        The broker's host instance type to upgrade to. For a list of supported instance types, see <a href=
         *        "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types"
         *        >Broker instance types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * <p>
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does
         * not apply to RabbitMQ brokers.
         * </p>
         * 
         * @param ldapServerMetadata
         *        Optional. The metadata of the LDAP server used to authenticate and authorize connections to the
         *        broker. Does not apply to RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata);

        /**
         * <p>
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does
         * not apply to RabbitMQ brokers.
         * </p>
         * This is a convenience method that creates an instance of the {@link LdapServerMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link LdapServerMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LdapServerMetadataOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #ldapServerMetadata(LdapServerMetadataOutput)}.
         * 
         * @param ldapServerMetadata
         *        a consumer that will call methods on {@link LdapServerMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ldapServerMetadata(LdapServerMetadataOutput)
         */
        default Builder ldapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> ldapServerMetadata) {
            return ldapServerMetadata(LdapServerMetadataOutput.builder().applyMutation(ldapServerMetadata).build());
        }

        /**
         * <p>
         * The list of information about logs to be enabled for the specified broker.
         * </p>
         * 
         * @param logs
         *        The list of information about logs to be enabled for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(Logs logs);

        /**
         * <p>
         * The list of information about logs to be enabled for the specified broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link Logs.Builder} avoiding the need to create
         * one manually via {@link Logs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Logs.Builder#build()} is called immediately and its result is
         * passed to {@link #logs(Logs)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link Logs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(Logs)
         */
        default Builder logs(Consumer<Logs.Builder> logs) {
            return logs(Logs.builder().applyMutation(logs).build());
        }

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * 
         * @param maintenanceWindowStartTime
         *        The parameters that determine the WeeklyStartTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime);

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * This is a convenience method that creates an instance of the {@link WeeklyStartTime.Builder} avoiding the
         * need to create one manually via {@link WeeklyStartTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WeeklyStartTime.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindowStartTime(WeeklyStartTime)}.
         * 
         * @param maintenanceWindowStartTime
         *        a consumer that will call methods on {@link WeeklyStartTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindowStartTime(WeeklyStartTime)
         */
        default Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return maintenanceWindowStartTime(WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime).build());
        }

        /**
         * <p>
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set
         * to CRDR.
         * </p>
         * 
         * @param dataReplicationMetadata
         *        The replication details of the data replication-enabled broker. Only returned if dataReplicationMode
         *        is set to CRDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationMetadata(DataReplicationMetadataOutput dataReplicationMetadata);

        /**
         * <p>
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set
         * to CRDR.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link DataReplicationMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationMetadataOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #dataReplicationMetadata(DataReplicationMetadataOutput)}.
         * 
         * @param dataReplicationMetadata
         *        a consumer that will call methods on {@link DataReplicationMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationMetadata(DataReplicationMetadataOutput)
         */
        default Builder dataReplicationMetadata(Consumer<DataReplicationMetadataOutput.Builder> dataReplicationMetadata) {
            return dataReplicationMetadata(DataReplicationMetadataOutput.builder().applyMutation(dataReplicationMetadata).build());
        }

        /**
         * <p>
         * Describes whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Describes whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(String dataReplicationMode);

        /**
         * <p>
         * Describes whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Describes whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(DataReplicationMode dataReplicationMode);

        /**
         * <p>
         * The pending replication details of the data replication-enabled broker. Only returned if
         * pendingDataReplicationMode is set to CRDR.
         * </p>
         * 
         * @param pendingDataReplicationMetadata
         *        The pending replication details of the data replication-enabled broker. Only returned if
         *        pendingDataReplicationMode is set to CRDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDataReplicationMetadata(DataReplicationMetadataOutput pendingDataReplicationMetadata);

        /**
         * <p>
         * The pending replication details of the data replication-enabled broker. Only returned if
         * pendingDataReplicationMode is set to CRDR.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link DataReplicationMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationMetadataOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pendingDataReplicationMetadata(DataReplicationMetadataOutput)}.
         * 
         * @param pendingDataReplicationMetadata
         *        a consumer that will call methods on {@link DataReplicationMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingDataReplicationMetadata(DataReplicationMetadataOutput)
         */
        default Builder pendingDataReplicationMetadata(
                Consumer<DataReplicationMetadataOutput.Builder> pendingDataReplicationMetadata) {
            return pendingDataReplicationMetadata(DataReplicationMetadataOutput.builder()
                    .applyMutation(pendingDataReplicationMetadata).build());
        }

        /**
         * <p>
         * Describes whether this broker will be a part of a data replication pair after reboot.
         * </p>
         * 
         * @param pendingDataReplicationMode
         *        Describes whether this broker will be a part of a data replication pair after reboot.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder pendingDataReplicationMode(String pendingDataReplicationMode);

        /**
         * <p>
         * Describes whether this broker will be a part of a data replication pair after reboot.
         * </p>
         * 
         * @param pendingDataReplicationMode
         *        Describes whether this broker will be a part of a data replication pair after reboot.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder pendingDataReplicationMode(DataReplicationMode pendingDataReplicationMode);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String authenticationStrategy;

        private Boolean autoMinorVersionUpgrade;

        private String brokerId;

        private ConfigurationId configuration;

        private String engineVersion;

        private String hostInstanceType;

        private LdapServerMetadataOutput ldapServerMetadata;

        private Logs logs;

        private WeeklyStartTime maintenanceWindowStartTime;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private DataReplicationMetadataOutput dataReplicationMetadata;

        private String dataReplicationMode;

        private DataReplicationMetadataOutput pendingDataReplicationMetadata;

        private String pendingDataReplicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerResponse model) {
            super(model);
            authenticationStrategy(model.authenticationStrategy);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            brokerId(model.brokerId);
            configuration(model.configuration);
            engineVersion(model.engineVersion);
            hostInstanceType(model.hostInstanceType);
            ldapServerMetadata(model.ldapServerMetadata);
            logs(model.logs);
            maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            securityGroups(model.securityGroups);
            dataReplicationMetadata(model.dataReplicationMetadata);
            dataReplicationMode(model.dataReplicationMode);
            pendingDataReplicationMetadata(model.pendingDataReplicationMetadata);
            pendingDataReplicationMode(model.pendingDataReplicationMode);
        }

        public final String getAuthenticationStrategy() {
            return authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerId() {
            return brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final LdapServerMetadataOutput.Builder getLdapServerMetadata() {
            return ldapServerMetadata != null ? ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        public final Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final Logs.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return maintenanceWindowStartTime != null ? maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final DataReplicationMetadataOutput.Builder getDataReplicationMetadata() {
            return dataReplicationMetadata != null ? dataReplicationMetadata.toBuilder() : null;
        }

        public final void setDataReplicationMetadata(DataReplicationMetadataOutput.BuilderImpl dataReplicationMetadata) {
            this.dataReplicationMetadata = dataReplicationMetadata != null ? dataReplicationMetadata.build() : null;
        }

        @Override
        public final Builder dataReplicationMetadata(DataReplicationMetadataOutput dataReplicationMetadata) {
            this.dataReplicationMetadata = dataReplicationMetadata;
            return this;
        }

        public final String getDataReplicationMode() {
            return dataReplicationMode;
        }

        public final void setDataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
        }

        @Override
        public final Builder dataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
            return this;
        }

        @Override
        public final Builder dataReplicationMode(DataReplicationMode dataReplicationMode) {
            this.dataReplicationMode(dataReplicationMode == null ? null : dataReplicationMode.toString());
            return this;
        }

        public final DataReplicationMetadataOutput.Builder getPendingDataReplicationMetadata() {
            return pendingDataReplicationMetadata != null ? pendingDataReplicationMetadata.toBuilder() : null;
        }

        public final void setPendingDataReplicationMetadata(
                DataReplicationMetadataOutput.BuilderImpl pendingDataReplicationMetadata) {
            this.pendingDataReplicationMetadata = pendingDataReplicationMetadata != null ? pendingDataReplicationMetadata.build()
                    : null;
        }

        @Override
        public final Builder pendingDataReplicationMetadata(DataReplicationMetadataOutput pendingDataReplicationMetadata) {
            this.pendingDataReplicationMetadata = pendingDataReplicationMetadata;
            return this;
        }

        public final String getPendingDataReplicationMode() {
            return pendingDataReplicationMode;
        }

        public final void setPendingDataReplicationMode(String pendingDataReplicationMode) {
            this.pendingDataReplicationMode = pendingDataReplicationMode;
        }

        @Override
        public final Builder pendingDataReplicationMode(String pendingDataReplicationMode) {
            this.pendingDataReplicationMode = pendingDataReplicationMode;
            return this;
        }

        @Override
        public final Builder pendingDataReplicationMode(DataReplicationMode pendingDataReplicationMode) {
            this.pendingDataReplicationMode(pendingDataReplicationMode == null ? null : pendingDataReplicationMode.toString());
            return this;
        }

        @Override
        public UpdateBrokerResponse build() {
            return new UpdateBrokerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
