/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.model.StartDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StartDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StopDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StopDbClusterResponse;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeGlobalClustersPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher;
import software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher;
import software.amazon.awssdk.services.neptune.waiters.NeptuneAsyncWaiter;

/**
 * Service client for accessing Amazon Neptune asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Neptune</fullname>
 * <p>
 * Amazon Neptune is a fast, reliable, fully-managed graph database service that makes it easy to build and run
 * applications that work with highly connected datasets. The core of Amazon Neptune is a purpose-built,
 * high-performance graph database engine optimized for storing billions of relationships and querying the graph with
 * milliseconds latency. Amazon Neptune supports popular graph models Property Graph and W3C's RDF, and their respective
 * query languages Apache TinkerPop Gremlin and SPARQL, allowing you to easily build queries that efficiently navigate
 * highly connected datasets. Neptune powers graph use cases such as recommendation engines, fraud detection, knowledge
 * graphs, drug discovery, and network security.
 * </p>
 * <p>
 * This interface reference for Amazon Neptune contains documentation for a programming or command line interface you
 * can use to manage Amazon Neptune. Note that Amazon Neptune is asynchronous, which means that some interfaces might
 * require techniques such as polling or callback functions to determine when a command has been applied. In this
 * reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot,
 * or during the maintenance window. The reference structure is as follows, and we list following some related topics
 * from the user guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NeptuneAsyncClient extends AwsClient {
    String SERVICE_NAME = "rds";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rds";

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbClusterRequest#builder()}
     * </p>
     *
     * @param addRoleToDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(
            Consumer<AddRoleToDbClusterRequest.Builder> addRoleToDbClusterRequest) {
        return addRoleToDBCluster(AddRoleToDbClusterRequest.builder().applyMutation(addRoleToDbClusterRequest).build());
    }

    /**
     * <p>
     * Adds a source identifier to an existing event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a source identifier to an existing event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddSourceIdentifierToSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link AddSourceIdentifierToSubscriptionRequest#builder()}
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            Consumer<AddSourceIdentifierToSubscriptionRequest.Builder> addSourceIdentifierToSubscriptionRequest) {
        return addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.builder()
                .applyMutation(addSourceIdentifierToSubscriptionRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to
     * track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon
     * Neptune.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to
     * track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon
     * Neptune.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest) {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CopyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            Consumer<CopyDbClusterParameterGroupRequest.Builder> copyDbClusterParameterGroupRequest) {
        return copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder()
                .applyMutation(copyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            Consumer<CopyDbClusterSnapshotRequest.Builder> copyDbClusterSnapshotRequest) {
        return copyDBClusterSnapshot(CopyDbClusterSnapshotRequest.builder().applyMutation(copyDbClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     *
     * @param copyDbParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            Consumer<CopyDbParameterGroupRequest.Builder> copyDbParameterGroupRequest) {
        return copyDBParameterGroup(CopyDbParameterGroupRequest.builder().applyMutation(copyDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Neptune DB cluster.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of
     * another DB cluster or Amazon Neptune DB instance.
     * </p>
     * <p>
     * Note that when you create a new cluster using <code>CreateDBCluster</code> directly, deletion protection is
     * disabled by default (when you create a new production cluster in the console, deletion protection is enabled by
     * default). You can only delete a DB cluster if its <code>DeletionProtection</code> field is set to
     * <code>false</code>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Neptune DB cluster.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of
     * another DB cluster or Amazon Neptune DB instance.
     * </p>
     * <p>
     * Note that when you create a new cluster using <code>CreateDBCluster</code> directly, deletion protection is
     * disabled by default (when you create a new production cluster in the console, deletion protection is enabled by
     * default). You can only delete a DB cluster if its <code>DeletionProtection</code> field is set to
     * <code>false</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(
            Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest) {
        return createDBCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
     * </p>
     *
     * @param createDbClusterEndpointRequest
     * @return A Java Future containing the result of the CreateDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterEndpointQuotaExceededException The cluster already has the maximum number of custom
     *         endpoints.</li>
     *         <li>DbClusterEndpointAlreadyExistsException The specified custom endpoint cannot be created because it
     *         already exists.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterEndpointResponse> createDBClusterEndpoint(
            CreateDbClusterEndpointRequest createDbClusterEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param createDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterEndpointQuotaExceededException The cluster already has the maximum number of custom
     *         endpoints.</li>
     *         <li>DbClusterEndpointAlreadyExistsException The specified custom endpoint cannot be created because it
     *         already exists.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterEndpointResponse> createDBClusterEndpoint(
            Consumer<CreateDbClusterEndpointRequest.Builder> createDbClusterEndpointRequest) {
        return createDBClusterEndpoint(CreateDbClusterEndpointRequest.builder().applyMutation(createDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <a>ModifyDBClusterParameterGroup</a>. Once you've created a DB cluster parameter group, you
     * need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster
     * parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover
     * for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This is especially important for parameters that are critical when creating the default database for a
     * DB cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a>
     * command to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <a>ModifyDBClusterParameterGroup</a>. Once you've created a DB cluster parameter group, you
     * need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster
     * parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover
     * for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This is especially important for parameters that are critical when creating the default database for a
     * DB cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a>
     * command to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            Consumer<CreateDbClusterParameterGroupRequest.Builder> createDbClusterParameterGroupRequest) {
        return createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder()
                .applyMutation(createDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            Consumer<CreateDbClusterSnapshotRequest.Builder> createDbClusterSnapshotRequest) {
        return createDBClusterSnapshot(CreateDbClusterSnapshotRequest.builder().applyMutation(createDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>InstanceQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         instances.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>InstanceQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         instances.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(
            Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest) {
        return createDBInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB
     * instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance,
     * you need to reboot the DB instance without failover for the new DB parameter group and associated settings to
     * take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB
     * instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance,
     * you need to reboot the DB instance without failover for the new DB parameter group and associated settings to
     * take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException Request would result in user exceeding the allowed number of
     *         DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            Consumer<CreateDbParameterGroupRequest.Builder> createDbParameterGroupRequest) {
        return createDBParameterGroup(CreateDbParameterGroupRequest.builder().applyMutation(createDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <i>DBSubnetGroupName</i> is already used by an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <i>DBSubnetGroupName</i> is already used by an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            Consumer<CreateDbSubnetGroupRequest.Builder> createDbSubnetGroupRequest) {
        return createDBSubnetGroup(CreateDbSubnetGroupRequest.builder().applyMutation(createDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by
     * either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic
     * in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources
     * (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you
     * want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
     * mydbinstance2 and EventCategories = Availability, Backup.
     * </p>
     * <p>
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier =
     * myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a
     * SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all
     * your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of
     * events generated from all Neptune sources belonging to your customer account.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have exceeded the number of events you can subscribe to.</li>
     *         <li>SubscriptionAlreadyExistException This subscription already exists.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException There is no SNS authorization.</li>
     *         <li>SnsTopicArnNotFoundException The ARN of the SNS topic could not be found.</li>
     *         <li>SubscriptionCategoryNotFoundException The designated subscription category could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by
     * either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic
     * in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources
     * (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you
     * want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
     * mydbinstance2 and EventCategories = Availability, Backup.
     * </p>
     * <p>
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier =
     * myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a
     * SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all
     * your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of
     * events generated from all Neptune sources belonging to your customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have exceeded the number of events you can subscribe to.</li>
     *         <li>SubscriptionAlreadyExistException This subscription already exists.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException There is no SNS authorization.</li>
     *         <li>SnsTopicArnNotFoundException The ARN of the SNS topic could not be found.</li>
     *         <li>SubscriptionCategoryNotFoundException The designated subscription category could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest) {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single
     * primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary
     * cluster through high-speed replication performed by the Neptune storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then add a primary cluster and secondary clusters
     * to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster
     * of the global database.
     * </p>
     *
     * @param createGlobalClusterRequest
     * @return A Java Future containing the result of the CreateGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterAlreadyExistsException The <code>GlobalClusterIdentifier</code> already exists. Choose a
     *         new global database identifier (unique name) to create a new global database cluster.</li>
     *         <li>GlobalClusterQuotaExceededException The number of global database clusters for this account is
     *         already at the maximum allowed.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlobalClusterResponse> createGlobalCluster(
            CreateGlobalClusterRequest createGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single
     * primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary
     * cluster through high-speed replication performed by the Neptune storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then add a primary cluster and secondary clusters
     * to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster
     * of the global database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalClusterRequest#builder()}
     * </p>
     *
     * @param createGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.CreateGlobalClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterAlreadyExistsException The <code>GlobalClusterIdentifier</code> already exists. Choose a
     *         new global database identifier (unique name) to create a new global database cluster.</li>
     *         <li>GlobalClusterQuotaExceededException The number of global database clusters for this account is
     *         already at the maximum allowed.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlobalClusterResponse> createGlobalCluster(
            Consumer<CreateGlobalClusterRequest.Builder> createGlobalClusterRequest) {
        return createGlobalCluster(CreateGlobalClusterRequest.builder().applyMutation(createGlobalClusterRequest).build());
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set
     * its <code>DeletionProtection</code> field to <code>False</code>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set
     * its <code>DeletionProtection</code> field to <code>False</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException User already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(
            Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest) {
        return deleteDBCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
     * </p>
     *
     * @param deleteDbClusterEndpointRequest
     * @return A Java Future containing the result of the DeleteDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterEndpointStateException The requested operation cannot be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterEndpointResponse> deleteDBClusterEndpoint(
            DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterEndpointStateException The requested operation cannot be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterEndpointResponse> deleteDBClusterEndpoint(
            Consumer<DeleteDbClusterEndpointRequest.Builder> deleteDbClusterEndpointRequest) {
        return deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest.builder().applyMutation(deleteDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            Consumer<DeleteDbClusterParameterGroupRequest.Builder> deleteDbClusterParameterGroupRequest) {
        return deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder()
                .applyMutation(deleteDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            Consumer<DeleteDbClusterSnapshotRequest.Builder> deleteDbClusterSnapshotRequest) {
        return deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().applyMutation(deleteDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until
     * the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * Note that when a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the
     * <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection
     * enabled.
     * </p>
     *
     * @param deleteDbInstanceRequest
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbSnapshotAlreadyExistsException <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.
     *         </li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until
     * the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * Note that when a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the
     * <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection
     * enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbSnapshotAlreadyExistsException <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.
     *         </li>
     *         <li>SnapshotQuotaExceededException Request would result in user exceeding the allowed number of DB
     *         snapshots.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(
            Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest) {
        return deleteDBInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(
            DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(
            Consumer<DeleteDbParameterGroupRequest.Builder> deleteDbParameterGroupRequest) {
        return deleteDBParameterGroup(DeleteDbParameterGroupRequest.builder().applyMutation(deleteDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet is not in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(
            DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet is not in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(
            Consumer<DeleteDbSubnetGroupRequest.Builder> deleteDbSubnetGroupRequest) {
        return deleteDBSubnetGroup(DeleteDbSubnetGroupRequest.builder().applyMutation(deleteDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>InvalidEventSubscriptionStateException The event subscription is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>InvalidEventSubscriptionStateException The event subscription is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
     * </p>
     *
     * @param deleteGlobalClusterRequest
     * @return A Java Future containing the result of the DeleteGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalClusterResponse> deleteGlobalCluster(
            DeleteGlobalClusterRequest deleteGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalClusterRequest#builder()}
     * </p>
     *
     * @param deleteGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalClusterResponse> deleteGlobalCluster(
            Consumer<DeleteGlobalClusterRequest.Builder> deleteGlobalClusterRequest) {
        return deleteGlobalCluster(DeleteGlobalClusterRequest.builder().applyMutation(deleteGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest) {
        return describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsPublisher describeDBClusterEndpointsPaginator(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) {
        return new DescribeDBClusterEndpointsPublisher(this, describeDbClusterEndpointsRequest);
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsPublisher describeDBClusterEndpointsPaginator(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest) {
        return describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest) {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups() {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator() {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        return new DescribeDBClusterParameterGroupsPublisher(this, describeDbClusterParameterGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest) {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest) {
        return describeDBClusterParameters(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersPublisher describeDBClusterParametersPaginator(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        return new DescribeDBClusterParametersPublisher(this, describeDbClusterParametersRequest);
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersPublisher describeDBClusterParametersPaginator(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest) {
        return describeDBClusterParametersPaginator(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore
     * the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by
     * all Amazon accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the
     * manual DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore
     * the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by
     * all Amazon accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the
     * manual DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            Consumer<DescribeDbClusterSnapshotAttributesRequest.Builder> describeDbClusterSnapshotAttributesRequest) {
        return describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder()
                .applyMutation(describeDbClusterSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest) {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots() {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator() {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return new DescribeDBClusterSnapshotsPublisher(this, describeDbClusterSnapshotsRequest);
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest) {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClustersRequest
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) {
        return describeDBClusters(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters() {
        return describeDBClusters(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator() {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) {
        return new DescribeDBClustersPublisher(this, describeDbClustersRequest);
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().applyMutation(describeDbEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions() {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator() {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        return new DescribeDBEngineVersionsPublisher(this, describeDbEngineVersionsRequest);
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder()
                .applyMutation(describeDbEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstances(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances() {
        return describeDBInstances(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator() {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return new DescribeDBInstancesPublisher(this, describeDbInstancesRequest);
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups() {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator() {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        return new DescribeDBParameterGroupsPublisher(this, describeDbParameterGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            DescribeDbParametersRequest describeDbParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParameters(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) {
        return new DescribeDBParametersPublisher(this, describeDbParametersRequest);
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParametersPaginator(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().applyMutation(describeDbSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups() {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator() {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        return new DescribeDBSubnetGroupsPublisher(this, describeDbSubnetGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder()
                .applyMutation(describeDbSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEngineDefaultClusterParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEngineDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            Consumer<DescribeEngineDefaultClusterParametersRequest.Builder> describeEngineDefaultClusterParametersRequest) {
        return describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder()
                .applyMutation(describeEngineDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, describeEngineDefaultParametersRequest);
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories() {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions() {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator() {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, describeEventSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.neptune.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeEventsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about Neptune global database clusters. This API supports pagination.
     * </p>
     *
     * @param describeGlobalClustersRequest
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeGlobalClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Neptune global database clusters. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeGlobalClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) {
        return describeGlobalClusters(DescribeGlobalClustersRequest.builder().applyMutation(describeGlobalClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about Neptune global database clusters. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeGlobalClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalClustersPublisher describeGlobalClustersPaginator(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        return new DescribeGlobalClustersPublisher(this, describeGlobalClustersRequest);
    }

    /**
     * <p>
     * Returns information about Neptune global database clusters. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeGlobalClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGlobalClustersPublisher describeGlobalClustersPaginator(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) {
        return describeGlobalClustersPaginator(DescribeGlobalClustersRequest.builder()
                .applyMutation(describeGlobalClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        return new DescribeOrderableDBInstanceOptionsPublisher(this, describeOrderableDbInstanceOptionsRequest);
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions() {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator() {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        return new DescribePendingMaintenanceActionsPublisher(this, describePendingMaintenanceActionsRequest);
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptune.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB
     * instance. You can use this information when you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return A Java Future containing the result of the DescribeValidDBInstanceModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB
     * instance. You can use this information when you call <a>ModifyDBInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeValidDbInstanceModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeValidDbInstanceModificationsRequest#builder()}
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeValidDBInstanceModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(
            Consumer<DescribeValidDbInstanceModificationsRequest.Builder> describeValidDbInstanceModificationsRequest) {
        return describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest.builder()
                .applyMutation(describeValidDbInstanceModificationsRequest).build());
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the
     * primary instance (the cluster writer).
     * </p>
     * <p>
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails.
     * You can force a failover when you want to simulate a failure of a primary instance for testing. Because each
     * instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the
     * primary instance (the cluster writer).
     * </p>
     * <p>
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails.
     * You can force a failover when you want to simulate a failure of a primary instance for testing. Because each
     * instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link FailoverDbClusterRequest#builder()}
     * </p>
     *
     * @param failoverDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(
            Consumer<FailoverDbClusterRequest.Builder> failoverDbClusterRequest) {
        return failoverDBCluster(FailoverDbClusterRequest.builder().applyMutation(failoverDbClusterRequest).build());
    }

    /**
     * <p>
     * Initiates the failover process for a Neptune global database.
     * </p>
     * <p>
     * A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB
     * cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role
     * of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected
     * secondary DB cluster assumes full read/write capabilities for the Neptune global database.
     * </p>
     * <note>
     * <p>
     * This action applies <b>only</b> to Neptune global databases. This action is only intended for use on healthy
     * Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery
     * scenarios or to reconfigure the global database topology.
     * </p>
     * </note>
     *
     * @param failoverGlobalClusterRequest
     * @return A Java Future containing the result of the FailoverGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<FailoverGlobalClusterResponse> failoverGlobalCluster(
            FailoverGlobalClusterRequest failoverGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the failover process for a Neptune global database.
     * </p>
     * <p>
     * A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB
     * cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role
     * of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected
     * secondary DB cluster assumes full read/write capabilities for the Neptune global database.
     * </p>
     * <note>
     * <p>
     * This action applies <b>only</b> to Neptune global databases. This action is only intended for use on healthy
     * Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery
     * scenarios or to reconfigure the global database topology.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link FailoverGlobalClusterRequest#builder()}
     * </p>
     *
     * @param failoverGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FailoverGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<FailoverGlobalClusterResponse> failoverGlobalCluster(
            Consumer<FailoverGlobalClusterRequest.Builder> failoverGlobalClusterRequest) {
        return failoverGlobalCluster(FailoverGlobalClusterRequest.builder().applyMutation(failoverGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an Amazon Neptune resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an Amazon Neptune resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbClusterRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it is in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(
            Consumer<ModifyDbClusterRequest.Builder> modifyDbClusterRequest) {
        return modifyDBCluster(ModifyDbClusterRequest.builder().applyMutation(modifyDbClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
     * </p>
     *
     * @param modifyDbClusterEndpointRequest
     * @return A Java Future containing the result of the ModifyDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterEndpointStateException The requested operation cannot be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterEndpointResponse> modifyDBClusterEndpoint(
            ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbClusterEndpointStateException The requested operation cannot be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterEndpointResponse> modifyDBClusterEndpoint(
            Consumer<ModifyDbClusterEndpointRequest.Builder> modifyDbClusterEndpointRequest) {
        return modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest.builder().applyMutation(modifyDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB cluster associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the
     * <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or
     * modified.
     * </p>
     * </important>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB cluster associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the
     * <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or
     * modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            Consumer<ModifyDbClusterParameterGroupRequest.Builder> modifyDbClusterParameterGroupRequest) {
        return modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest.builder()
                .applyMutation(modifyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do
     * not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized Amazon account IDs for the <code>ValuesToAdd</code> parameter. You can't
     * use <code>all</code> as a value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB
     * cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do
     * not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized Amazon account IDs for the <code>ValuesToAdd</code> parameter. You can't
     * use <code>all</code> as a value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB
     * cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterSnapshotAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterSnapshotAttributeRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            Consumer<ModifyDbClusterSnapshotAttributeRequest.Builder> modifyDbClusterSnapshotAttributeRequest) {
        return modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.builder()
                .applyMutation(modifyDbClusterSnapshotAttributeRequest).build());
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource the DB depends on could
     *         not be modified.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>CertificateNotFoundException <i>CertificateIdentifier</i> does not refer to an existing certificate.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbInstanceRequest#builder()}
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group does not allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException User already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSecurityGroupNotFoundException <i>DBSecurityGroupName</i> does not refer to an existing DB security
     *         group.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException Specified DB instance class is not available in the specified
     *         Availability Zone.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource the DB depends on could
     *         not be modified.</li>
     *         <li>StorageTypeNotSupportedException <i>StorageType</i> specified cannot be associated with the DB
     *         Instance.</li>
     *         <li>AuthorizationNotFoundException Specified CIDRIP or EC2 security group is not authorized for the
     *         specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.</li>
     *         <li>CertificateNotFoundException <i>CertificateIdentifier</i> does not refer to an existing certificate.</li>
     *         <li>DomainNotFoundException <i>Domain</i> does not refer to an existing Active Directory Domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(
            Consumer<ModifyDbInstanceRequest.Builder> modifyDbInstanceRequest) {
        return modifyDBInstance(ModifyDbInstanceRequest.builder().applyMutation(modifyDbInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB instance associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(
            ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB instance associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(
            Consumer<ModifyDbParameterGroupRequest.Builder> modifyDbParameterGroupRequest) {
        return modifyDBParameterGroup(ModifyDbParameterGroupRequest.builder().applyMutation(modifyDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException Request would result in user exceeding the allowed number of subnets
     *         in a DB subnet groups.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            Consumer<ModifyDbSubnetGroupRequest.Builder> modifyDbSubnetGroupRequest) {
        return modifyDBSubnetGroup(ModifyDbSubnetGroupRequest.builder().applyMutation(modifyDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using
     * this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and
     * <a>RemoveSourceIdentifierFromSubscription</a> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b>
     * action.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have exceeded the number of events you can subscribe to.</li>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException There is no SNS authorization.</li>
     *         <li>SnsTopicArnNotFoundException The ARN of the SNS topic could not be found.</li>
     *         <li>SubscriptionCategoryNotFoundException The designated subscription category could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using
     * this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and
     * <a>RemoveSourceIdentifierFromSubscription</a> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b>
     * action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have exceeded the number of events you can subscribe to.</li>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException There is no SNS authorization.</li>
     *         <li>SnsTopicArnNotFoundException The ARN of the SNS topic could not be found.</li>
     *         <li>SubscriptionCategoryNotFoundException The designated subscription category could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest) {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration
     * parameters by specifying these parameters and their new values in the request.
     * </p>
     *
     * @param modifyGlobalClusterRequest
     * @return A Java Future containing the result of the ModifyGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyGlobalClusterResponse> modifyGlobalCluster(
            ModifyGlobalClusterRequest modifyGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration
     * parameters by specifying these parameters and their new values in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyGlobalClusterRequest#builder()}
     * </p>
     *
     * @param modifyGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ModifyGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyGlobalClusterResponse> modifyGlobalCluster(
            Consumer<ModifyGlobalClusterRequest.Builder> modifyGlobalClusterRequest) {
        return modifyGlobalCluster(ModifyGlobalClusterRequest.builder().applyMutation(modifyGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Not supported.
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     * @return A Java Future containing the result of the PromoteReadReplicaDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.PromoteReadReplicaDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(
            PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PromoteReadReplicaDbClusterRequest.Builder}
     * avoiding the need to create one manually via {@link PromoteReadReplicaDbClusterRequest#builder()}
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PromoteReadReplicaDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.PromoteReadReplicaDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(
            Consumer<PromoteReadReplicaDbClusterRequest.Builder> promoteReadReplicaDbClusterRequest) {
        return promoteReadReplicaDBCluster(PromoteReadReplicaDbClusterRequest.builder()
                .applyMutation(promoteReadReplicaDbClusterRequest).build());
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     *
     * @param rebootDbInstanceRequest
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RebootDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link RebootDbInstanceRequest#builder()}
     * </p>
     *
     * @param rebootDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RebootDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(
            Consumer<RebootDbInstanceRequest.Builder> rebootDbInstanceRequest) {
        return rebootDBInstance(RebootDbInstanceRequest.builder().applyMutation(rebootDbInstanceRequest).build());
    }

    /**
     * <p>
     * Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone
     * cluster with read-write capability instead of being read-only, and no longer receives data from a the primary
     * cluster.
     * </p>
     *
     * @param removeFromGlobalClusterRequest
     * @return A Java Future containing the result of the RemoveFromGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveFromGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveFromGlobalCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFromGlobalClusterResponse> removeFromGlobalCluster(
            RemoveFromGlobalClusterRequest removeFromGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone
     * cluster with read-write capability instead of being read-only, and no longer receives data from a the primary
     * cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFromGlobalClusterRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveFromGlobalClusterRequest#builder()}
     * </p>
     *
     * @param removeFromGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveFromGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveFromGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveFromGlobalCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFromGlobalClusterResponse> removeFromGlobalCluster(
            Consumer<RemoveFromGlobalClusterRequest.Builder> removeFromGlobalClusterRequest) {
        return removeFromGlobalCluster(RemoveFromGlobalClusterRequest.builder().applyMutation(removeFromGlobalClusterRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     * @return A Java Future containing the result of the RemoveRoleFromDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleNotFoundException The specified IAM role Amazon Resource Name (ARN) is not associated
     *         with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveRoleFromDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveRoleFromDbClusterResponse> removeRoleFromDBCluster(
            RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveRoleFromDbClusterRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveRoleFromDbClusterRequest#builder()}
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveRoleFromDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleNotFoundException The specified IAM role Amazon Resource Name (ARN) is not associated
     *         with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveRoleFromDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveRoleFromDbClusterResponse> removeRoleFromDBCluster(
            Consumer<RemoveRoleFromDbClusterRequest.Builder> removeRoleFromDbClusterRequest) {
        return removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest.builder().applyMutation(removeRoleFromDbClusterRequest)
                .build());
    }

    /**
     * <p>
     * Removes a source identifier from an existing event notification subscription.
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     * @return A Java Future containing the result of the RemoveSourceIdentifierFromSubscription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(
            RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source identifier from an existing event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RemoveSourceIdentifierFromSubscriptionRequest.Builder} avoiding the need to create one manually via
     * {@link RemoveSourceIdentifierFromSubscriptionRequest#builder()}
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RemoveSourceIdentifierFromSubscription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The designated subscription could not be found.</li>
     *         <li>SourceNotFoundException The source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(
            Consumer<RemoveSourceIdentifierFromSubscriptionRequest.Builder> removeSourceIdentifierFromSubscriptionRequest) {
        return removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.builder()
                .applyMutation(removeSourceIdentifierFromSubscriptionRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon Neptune resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon Neptune resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request.
     * You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static
     * parameter to apply to.
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request.
     * You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static
     * parameter to apply to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ResetDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            Consumer<ResetDbClusterParameterGroupRequest.Builder> resetDbClusterParameterGroupRequest) {
        return resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest.builder()
                .applyMutation(resetDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     *
     * @param resetDbParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(
            ResetDbParameterGroupRequest resetDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResetDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you cannot delete it when the parameter group is in
     *         this state.</li>
     *         <li>DbParameterGroupNotFoundException <i>DBParameterGroupName</i> does not refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.ResetDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(
            Consumer<ResetDbParameterGroupRequest.Builder> resetDbParameterGroupRequest) {
        return resetDBParameterGroup(ResetDbParameterGroupRequest.builder().applyMutation(resetDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterFromSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            Consumer<RestoreDbClusterFromSnapshotRequest.Builder> restoreDbClusterFromSnapshotRequest) {
        return restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.builder()
                .applyMutation(restoreDbClusterFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of
     * the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the
     * <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     *
     * @param restoreDbClusterToPointInTimeRequest
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of
     * the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the
     * <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterToPointInTimeRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterToPointInTimeRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException User already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException User attempted to create a new DB cluster and the user has already
     *         reached the maximum allowed DB cluster quota.</li>
     *         <li>DbClusterSnapshotNotFoundException <i>DBClusterSnapshotIdentifier</i> does not refer to an existing
     *         DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <i>DBSubnetGroupName</i> does not refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster does not have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You may be able to resolve this error by updating your subnet group to use different Availability
     *         Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value is not a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot does not allow deletion.</li>
     *         <li>InvalidRestoreException Cannot restore from vpc backup to non-vpc DB instance.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException DB subnet group does not cover all Availability Zones after it is
     *         created because users' change.</li>
     *         <li>KmsKeyNotAccessibleException Error accessing KMS key.</li>
     *         <li>OptionGroupNotFoundException The designated option group could not be found.</li>
     *         <li>StorageQuotaExceededException Request would result in user exceeding the allowed amount of storage
     *         available across all DB instances.</li>
     *         <li>DbClusterParameterGroupNotFoundException <i>DBClusterParameterGroupName</i> does not refer to an
     *         existing DB Cluster parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            Consumer<RestoreDbClusterToPointInTimeRequest.Builder> restoreDbClusterToPointInTimeRequest) {
        return restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.builder()
                .applyMutation(restoreDbClusterToPointInTimeRequest).build());
    }

    /**
     * <p>
     * Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster
     * command, or the StopDBCluster API.
     * </p>
     *
     * @param startDbClusterRequest
     * @return A Java Future containing the result of the StartDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.StartDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDbClusterResponse> startDBCluster(StartDbClusterRequest startDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster
     * command, or the StopDBCluster API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDbClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StartDbClusterRequest#builder()}
     * </p>
     *
     * @param startDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.StartDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.StartDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDbClusterResponse> startDBCluster(Consumer<StartDbClusterRequest.Builder> startDbClusterRequest) {
        return startDBCluster(StartDbClusterRequest.builder().applyMutation(startDbClusterRequest).build());
    }

    /**
     * <p>
     * Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata,
     * including its endpoints and DB parameter groups.
     * </p>
     * <p>
     * Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.
     * </p>
     *
     * @param stopDbClusterRequest
     * @return A Java Future containing the result of the StopDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.StopDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDbClusterResponse> stopDBCluster(StopDbClusterRequest stopDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata,
     * including its endpoints and DB parameter groups.
     * </p>
     * <p>
     * Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDbClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StopDbClusterRequest#builder()}
     * </p>
     *
     * @param stopDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptune.model.StopDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The DB cluster is not in a valid state.</li>
     *         <li>InvalidDbInstanceStateException The specified DB instance is not in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneAsyncClient.StopDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDbClusterResponse> stopDBCluster(Consumer<StopDbClusterRequest.Builder> stopDbClusterRequest) {
        return stopDBCluster(StopDbClusterRequest.builder().applyMutation(stopDbClusterRequest).build());
    }

    /**
     * Create an instance of {@link NeptuneAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NeptuneAsyncWaiter}
     */
    default NeptuneAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default NeptuneServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NeptuneAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptuneAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptuneAsyncClient}.
     */
    static NeptuneAsyncClientBuilder builder() {
        return new DefaultNeptuneAsyncClientBuilder();
    }
}
