/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.neptunedata.internal.NeptunedataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.neptunedata.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.BadRequestException;
import software.amazon.awssdk.services.neptunedata.model.BulkLoadIdNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelledByUserException;
import software.amazon.awssdk.services.neptunedata.model.ClientTimeoutException;
import software.amazon.awssdk.services.neptunedata.model.ConcurrentModificationException;
import software.amazon.awssdk.services.neptunedata.model.ConstraintViolationException;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExpiredStreamException;
import software.amazon.awssdk.services.neptunedata.model.FailureByQueryException;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.IllegalArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InternalFailureException;
import software.amazon.awssdk.services.neptunedata.model.InvalidArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InvalidNumericDataException;
import software.amazon.awssdk.services.neptunedata.model.InvalidParameterException;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.LoadUrlAccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.MalformedQueryException;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.MemoryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.MethodNotAllowedException;
import software.amazon.awssdk.services.neptunedata.model.MissingParameterException;
import software.amazon.awssdk.services.neptunedata.model.MlResourceNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataException;
import software.amazon.awssdk.services.neptunedata.model.ParsingException;
import software.amazon.awssdk.services.neptunedata.model.PreconditionsFailedException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitException;
import software.amazon.awssdk.services.neptunedata.model.QueryTooLargeException;
import software.amazon.awssdk.services.neptunedata.model.ReadOnlyViolationException;
import software.amazon.awssdk.services.neptunedata.model.S3Exception;
import software.amazon.awssdk.services.neptunedata.model.ServerShutdownException;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StatisticsNotAvailableException;
import software.amazon.awssdk.services.neptunedata.model.StreamRecordsNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.ThrottlingException;
import software.amazon.awssdk.services.neptunedata.model.TimeLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.TooManyRequestsException;
import software.amazon.awssdk.services.neptunedata.model.UnsupportedOperationException;
import software.amazon.awssdk.services.neptunedata.transform.CancelGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CreateMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeletePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteFastResetRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinProfileQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetEngineStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetGremlinQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetLoaderJobStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetOpenCypherQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetRdfGraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListGremlinQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListLoaderJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlDataProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListOpenCypherQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManagePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManageSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link NeptunedataAsyncClient}.
 *
 * @see NeptunedataAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNeptunedataAsyncClient implements NeptunedataAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNeptunedataAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNeptunedataAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelGremlinQueryRequest
     * @return A Java Future containing the result of the CancelGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelGremlinQueryResponse> cancelGremlinQuery(CancelGremlinQueryRequest cancelGremlinQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelGremlinQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelGremlinQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelGremlinQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelGremlinQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelGremlinQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelGremlinQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelGremlinQueryRequest, CancelGremlinQueryResponse>()
                            .withOperationName("CancelGremlinQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelGremlinQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelGremlinQueryRequest));
            CompletableFuture<CancelGremlinQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob"
     * >neptune-db:CancelLoaderJob</a> IAM action in that cluster..
     * </p>
     *
     * @param cancelLoaderJobRequest
     * @return A Java Future containing the result of the CancelLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelLoaderJobResponse> cancelLoaderJob(CancelLoaderJobRequest cancelLoaderJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelLoaderJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelLoaderJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelLoaderJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelLoaderJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelLoaderJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelLoaderJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelLoaderJobRequest, CancelLoaderJobResponse>()
                            .withOperationName("CancelLoaderJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelLoaderJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelLoaderJobRequest));
            CompletableFuture<CancelLoaderJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob"
     * >neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     * @return A Java Future containing the result of the CancelMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMlDataProcessingJobResponse> cancelMLDataProcessingJob(
            CancelMlDataProcessingJobRequest cancelMlDataProcessingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMlDataProcessingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLDataProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMlDataProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMlDataProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMlDataProcessingJobRequest, CancelMlDataProcessingJobResponse>()
                            .withOperationName("CancelMLDataProcessingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMlDataProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMlDataProcessingJobRequest));
            CompletableFuture<CancelMlDataProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob"
     * >neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     * @return A Java Future containing the result of the CancelMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMlModelTrainingJobResponse> cancelMLModelTrainingJob(
            CancelMlModelTrainingJobRequest cancelMlModelTrainingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMlModelTrainingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLModelTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMlModelTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMlModelTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMlModelTrainingJobRequest, CancelMlModelTrainingJobResponse>()
                            .withOperationName("CancelMLModelTrainingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMlModelTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMlModelTrainingJobRequest));
            CompletableFuture<CancelMlModelTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob"
     * >neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     * @return A Java Future containing the result of the CancelMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMlModelTransformJobResponse> cancelMLModelTransformJob(
            CancelMlModelTransformJobRequest cancelMlModelTransformJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMlModelTransformJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLModelTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMlModelTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMlModelTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMlModelTransformJobRequest, CancelMlModelTransformJobResponse>()
                            .withOperationName("CancelMLModelTransformJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMlModelTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMlModelTransformJobRequest));
            CompletableFuture<CancelMlModelTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     * @return A Java Future containing the result of the CancelOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelOpenCypherQueryResponse> cancelOpenCypherQuery(
            CancelOpenCypherQueryRequest cancelOpenCypherQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelOpenCypherQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelOpenCypherQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelOpenCypherQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelOpenCypherQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelOpenCypherQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelOpenCypherQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelOpenCypherQueryRequest, CancelOpenCypherQueryResponse>()
                            .withOperationName("CancelOpenCypherQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelOpenCypherQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelOpenCypherQueryRequest));
            CompletableFuture<CancelOpenCypherQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint"
     * >neptune-db:CreateMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param createMlEndpointRequest
     * @return A Java Future containing the result of the CreateMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMlEndpointResponse> createMLEndpoint(CreateMlEndpointRequest createMlEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMlEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMLEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMlEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMlEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMlEndpointRequest, CreateMlEndpointResponse>()
                            .withOperationName("CreateMLEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMlEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMlEndpointRequest));
            CompletableFuture<CreateMlEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint"
     * >neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteMlEndpointRequest
     * @return A Java Future containing the result of the DeleteMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMlEndpointResponse> deleteMLEndpoint(DeleteMlEndpointRequest deleteMlEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMlEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMlEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMlEndpointRequest, DeleteMlEndpointResponse>()
                            .withOperationName("DeleteMLEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMlEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMlEndpointRequest));
            CompletableFuture<DeleteMlEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     * @return A Java Future containing the result of the DeletePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePropertygraphStatisticsResponse> deletePropertygraphStatistics(
            DeletePropertygraphStatisticsRequest deletePropertygraphStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePropertygraphStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePropertygraphStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePropertygraphStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePropertygraphStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePropertygraphStatisticsRequest, DeletePropertygraphStatisticsResponse>()
                            .withOperationName("DeletePropertygraphStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePropertygraphStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePropertygraphStatisticsRequest));
            CompletableFuture<DeletePropertygraphStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     * @return A Java Future containing the result of the DeleteSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSparqlStatisticsResponse> deleteSparqlStatistics(
            DeleteSparqlStatisticsRequest deleteSparqlStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSparqlStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSparqlStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSparqlStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSparqlStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSparqlStatisticsRequest, DeleteSparqlStatisticsResponse>()
                            .withOperationName("DeleteSparqlStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSparqlStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSparqlStatisticsRequest));
            CompletableFuture<DeleteSparqlStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase"
     * >neptune-db:ResetDatabase</a> IAM action in that cluster.
     * </p>
     *
     * @param executeFastResetRequest
     * @return A Java Future containing the result of the ExecuteFastReset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ServerShutdownException Raised when the server shuts down while processing a request.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MethodNotAllowedException Raised when the HTTP method used by a request is not supported by the
     *         endpoint being used.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteFastResetResponse> executeFastReset(ExecuteFastResetRequest executeFastResetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeFastResetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeFastResetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteFastReset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteFastResetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteFastResetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteFastResetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteFastResetRequest, ExecuteFastResetResponse>()
                            .withOperationName("ExecuteFastReset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteFastResetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeFastResetRequest));
            CompletableFuture<ExecuteFastResetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinExplainQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteGremlinExplainQueryResponse> executeGremlinExplainQuery(
            ExecuteGremlinExplainQueryRequest executeGremlinExplainQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeGremlinExplainQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinExplainQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinExplainQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<ExecuteGremlinExplainQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteGremlinExplainQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteGremlinExplainQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteGremlinExplainQueryRequest, ExecuteGremlinExplainQueryResponse>()
                            .withOperationName("ExecuteGremlinExplainQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteGremlinExplainQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeGremlinExplainQueryRequest));
            CompletableFuture<ExecuteGremlinExplainQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinProfileQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteGremlinProfileQueryResponse> executeGremlinProfileQuery(
            ExecuteGremlinProfileQueryRequest executeGremlinProfileQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeGremlinProfileQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinProfileQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinProfileQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<ExecuteGremlinProfileQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteGremlinProfileQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteGremlinProfileQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteGremlinProfileQueryRequest, ExecuteGremlinProfileQueryResponse>()
                            .withOperationName("ExecuteGremlinProfileQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteGremlinProfileQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeGremlinProfileQueryRequest));
            CompletableFuture<ExecuteGremlinProfileQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteGremlinQueryResponse> executeGremlinQuery(
            ExecuteGremlinQueryRequest executeGremlinQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeGremlinQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteGremlinQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteGremlinQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteGremlinQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteGremlinQueryRequest, ExecuteGremlinQueryResponse>()
                            .withOperationName("ExecuteGremlinQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteGremlinQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeGremlinQueryRequest));
            CompletableFuture<ExecuteGremlinQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     * @return A Java Future containing the result of the ExecuteOpenCypherExplainQuery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteOpenCypherExplainQueryResponse> executeOpenCypherExplainQuery(
            ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeOpenCypherExplainQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeOpenCypherExplainQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteOpenCypherExplainQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<ExecuteOpenCypherExplainQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteOpenCypherExplainQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteOpenCypherExplainQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteOpenCypherExplainQueryRequest, ExecuteOpenCypherExplainQueryResponse>()
                            .withOperationName("ExecuteOpenCypherExplainQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteOpenCypherExplainQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeOpenCypherExplainQueryRequest));
            CompletableFuture<ExecuteOpenCypherExplainQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     * <p>
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or
     * role making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note also that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     * @return A Java Future containing the result of the ExecuteOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteOpenCypherQueryResponse> executeOpenCypherQuery(
            ExecuteOpenCypherQueryRequest executeOpenCypherQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeOpenCypherQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeOpenCypherQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteOpenCypherQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteOpenCypherQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteOpenCypherQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteOpenCypherQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteOpenCypherQueryRequest, ExecuteOpenCypherQueryResponse>()
                            .withOperationName("ExecuteOpenCypherQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExecuteOpenCypherQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(executeOpenCypherQueryRequest));
            CompletableFuture<ExecuteOpenCypherQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status of the graph database on the host.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus"
     * >neptune-db:GetEngineStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getEngineStatusRequest
     * @return A Java Future containing the result of the GetEngineStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEngineStatusResponse> getEngineStatus(GetEngineStatusRequest getEngineStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEngineStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngineStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngineStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEngineStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEngineStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEngineStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEngineStatusRequest, GetEngineStatusResponse>()
                            .withOperationName("GetEngineStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEngineStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEngineStatusRequest));
            CompletableFuture<GetEngineStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     * @return A Java Future containing the result of the GetGremlinQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGremlinQueryStatusResponse> getGremlinQueryStatus(
            GetGremlinQueryStatusRequest getGremlinQueryStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGremlinQueryStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGremlinQueryStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGremlinQueryStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGremlinQueryStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGremlinQueryStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGremlinQueryStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGremlinQueryStatusRequest, GetGremlinQueryStatusResponse>()
                            .withOperationName("GetGremlinQueryStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGremlinQueryStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGremlinQueryStatusRequest));
            CompletableFuture<GetGremlinQueryStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus"
     * >neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..
     * </p>
     *
     * @param getLoaderJobStatusRequest
     * @return A Java Future containing the result of the GetLoaderJobStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoaderJobStatusResponse> getLoaderJobStatus(GetLoaderJobStatusRequest getLoaderJobStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLoaderJobStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoaderJobStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoaderJobStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoaderJobStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoaderJobStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoaderJobStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoaderJobStatusRequest, GetLoaderJobStatusResponse>()
                            .withOperationName("GetLoaderJobStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLoaderJobStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLoaderJobStatusRequest));
            CompletableFuture<GetLoaderJobStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus"
     * >neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     * @return A Java Future containing the result of the GetMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlDataProcessingJobResponse> getMLDataProcessingJob(
            GetMlDataProcessingJobRequest getMlDataProcessingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlDataProcessingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLDataProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMlDataProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlDataProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlDataProcessingJobRequest, GetMlDataProcessingJobResponse>()
                            .withOperationName("GetMLDataProcessingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlDataProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlDataProcessingJobRequest));
            CompletableFuture<GetMlDataProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus"
     * >neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlEndpointRequest
     * @return A Java Future containing the result of the GetMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlEndpointResponse> getMLEndpoint(GetMlEndpointRequest getMlEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMlEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlEndpointRequest, GetMlEndpointResponse>()
                            .withOperationName("GetMLEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlEndpointRequest));
            CompletableFuture<GetMlEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus"
     * >neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     * @return A Java Future containing the result of the GetMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlModelTrainingJobResponse> getMLModelTrainingJob(
            GetMlModelTrainingJobRequest getMlModelTrainingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlModelTrainingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLModelTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMlModelTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlModelTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlModelTrainingJobRequest, GetMlModelTrainingJobResponse>()
                            .withOperationName("GetMLModelTrainingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlModelTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlModelTrainingJobRequest));
            CompletableFuture<GetMlModelTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus"
     * >neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTransformJobRequest
     * @return A Java Future containing the result of the GetMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlModelTransformJobResponse> getMLModelTransformJob(
            GetMlModelTransformJobRequest getMlModelTransformJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlModelTransformJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLModelTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMlModelTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlModelTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlModelTransformJobRequest, GetMlModelTransformJobResponse>()
                            .withOperationName("GetMLModelTransformJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlModelTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlModelTransformJobRequest));
            CompletableFuture<GetMlModelTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     * @return A Java Future containing the result of the GetOpenCypherQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpenCypherQueryStatusResponse> getOpenCypherQueryStatus(
            GetOpenCypherQueryStatusRequest getOpenCypherQueryStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOpenCypherQueryStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpenCypherQueryStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpenCypherQueryStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOpenCypherQueryStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOpenCypherQueryStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOpenCypherQueryStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpenCypherQueryStatusRequest, GetOpenCypherQueryStatusResponse>()
                            .withOperationName("GetOpenCypherQueryStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOpenCypherQueryStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOpenCypherQueryStatusRequest));
            CompletableFuture<GetOpenCypherQueryStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus"
     * >neptune-db:GetStatisticsStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     * @return A Java Future containing the result of the GetPropertygraphStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPropertygraphStatisticsResponse> getPropertygraphStatistics(
            GetPropertygraphStatisticsRequest getPropertygraphStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPropertygraphStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPropertygraphStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPropertygraphStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphStatisticsRequest, GetPropertygraphStatisticsResponse>()
                            .withOperationName("GetPropertygraphStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPropertygraphStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPropertygraphStatisticsRequest));
            CompletableFuture<GetPropertygraphStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions, depending on the
     * query:
     * </p>
     * <p>
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys
     * available in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getPropertygraphStreamRequest
     * @return A Java Future containing the result of the GetPropertygraphStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPropertygraphStreamResponse> getPropertygraphStream(
            GetPropertygraphStreamRequest getPropertygraphStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPropertygraphStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPropertygraphStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPropertygraphStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPropertygraphStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphStreamRequest, GetPropertygraphStreamResponse>()
                            .withOperationName("GetPropertygraphStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPropertygraphStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPropertygraphStreamRequest));
            CompletableFuture<GetPropertygraphStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     * @return A Java Future containing the result of the GetPropertygraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPropertygraphSummaryResponse> getPropertygraphSummary(
            GetPropertygraphSummaryRequest getPropertygraphSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPropertygraphSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPropertygraphSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPropertygraphSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPropertygraphSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphSummaryRequest, GetPropertygraphSummaryResponse>()
                            .withOperationName("GetPropertygraphSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPropertygraphSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPropertygraphSummaryRequest));
            CompletableFuture<GetPropertygraphSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     * @return A Java Future containing the result of the GetRDFGraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRdfGraphSummaryResponse> getRDFGraphSummary(GetRdfGraphSummaryRequest getRdfGraphSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRdfGraphSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRdfGraphSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRDFGraphSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRdfGraphSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRdfGraphSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRdfGraphSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRdfGraphSummaryRequest, GetRdfGraphSummaryResponse>()
                            .withOperationName("GetRDFGraphSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRdfGraphSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRdfGraphSummaryRequest));
            CompletableFuture<GetRdfGraphSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     *
     * @param getSparqlStatisticsRequest
     * @return A Java Future containing the result of the GetSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSparqlStatisticsResponse> getSparqlStatistics(
            GetSparqlStatisticsRequest getSparqlStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSparqlStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSparqlStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSparqlStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSparqlStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSparqlStatisticsRequest, GetSparqlStatisticsResponse>()
                            .withOperationName("GetSparqlStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSparqlStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSparqlStatisticsRequest));
            CompletableFuture<GetSparqlStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of
     * SPARQL queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getSparqlStreamRequest
     * @return A Java Future containing the result of the GetSparqlStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSparqlStreamResponse> getSparqlStream(GetSparqlStreamRequest getSparqlStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSparqlStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSparqlStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSparqlStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSparqlStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSparqlStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSparqlStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSparqlStreamRequest, GetSparqlStreamResponse>()
                            .withOperationName("GetSparqlStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSparqlStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSparqlStreamRequest));
            CompletableFuture<GetSparqlStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listGremlinQueriesRequest
     * @return A Java Future containing the result of the ListGremlinQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGremlinQueriesResponse> listGremlinQueries(ListGremlinQueriesRequest listGremlinQueriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGremlinQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGremlinQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGremlinQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGremlinQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGremlinQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGremlinQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGremlinQueriesRequest, ListGremlinQueriesResponse>()
                            .withOperationName("ListGremlinQueries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGremlinQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGremlinQueriesRequest));
            CompletableFuture<ListGremlinQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs"
     * >neptune-db:ListLoaderJobs</a> IAM action in that cluster..
     * </p>
     *
     * @param listLoaderJobsRequest
     * @return A Java Future containing the result of the ListLoaderJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLoaderJobsResponse> listLoaderJobs(ListLoaderJobsRequest listLoaderJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLoaderJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLoaderJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLoaderJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLoaderJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLoaderJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLoaderJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLoaderJobsRequest, ListLoaderJobsResponse>()
                            .withOperationName("ListLoaderJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLoaderJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listLoaderJobsRequest));
            CompletableFuture<ListLoaderJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs"
     * >neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     * @return A Java Future containing the result of the ListMLDataProcessingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMlDataProcessingJobsResponse> listMLDataProcessingJobs(
            ListMlDataProcessingJobsRequest listMlDataProcessingJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlDataProcessingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlDataProcessingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLDataProcessingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMlDataProcessingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMlDataProcessingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMlDataProcessingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMlDataProcessingJobsRequest, ListMlDataProcessingJobsResponse>()
                            .withOperationName("ListMLDataProcessingJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMlDataProcessingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMlDataProcessingJobsRequest));
            CompletableFuture<ListMlDataProcessingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints"
     * >neptune-db:ListMLEndpoints</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlEndpointsRequest
     * @return A Java Future containing the result of the ListMLEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMlEndpointsResponse> listMLEndpoints(ListMlEndpointsRequest listMlEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMlEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMlEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMlEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMlEndpointsRequest, ListMlEndpointsResponse>()
                            .withOperationName("ListMLEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMlEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMlEndpointsRequest));
            CompletableFuture<ListMlEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs"
     * >neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     * @return A Java Future containing the result of the ListMLModelTrainingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMlModelTrainingJobsResponse> listMLModelTrainingJobs(
            ListMlModelTrainingJobsRequest listMlModelTrainingJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlModelTrainingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlModelTrainingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLModelTrainingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMlModelTrainingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMlModelTrainingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMlModelTrainingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMlModelTrainingJobsRequest, ListMlModelTrainingJobsResponse>()
                            .withOperationName("ListMLModelTrainingJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMlModelTrainingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMlModelTrainingJobsRequest));
            CompletableFuture<ListMlModelTrainingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs"
     * >neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     * @return A Java Future containing the result of the ListMLModelTransformJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMlModelTransformJobsResponse> listMLModelTransformJobs(
            ListMlModelTransformJobsRequest listMlModelTransformJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlModelTransformJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlModelTransformJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLModelTransformJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMlModelTransformJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMlModelTransformJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMlModelTransformJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMlModelTransformJobsRequest, ListMlModelTransformJobsResponse>()
                            .withOperationName("ListMLModelTransformJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMlModelTransformJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMlModelTransformJobsRequest));
            CompletableFuture<ListMlModelTransformJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     * @return A Java Future containing the result of the ListOpenCypherQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpenCypherQueriesResponse> listOpenCypherQueries(
            ListOpenCypherQueriesRequest listOpenCypherQueriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOpenCypherQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpenCypherQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpenCypherQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOpenCypherQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOpenCypherQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOpenCypherQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpenCypherQueriesRequest, ListOpenCypherQueriesResponse>()
                            .withOperationName("ListOpenCypherQueries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOpenCypherQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOpenCypherQueriesRequest));
            CompletableFuture<ListOpenCypherQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     * @return A Java Future containing the result of the ManagePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ManagePropertygraphStatisticsResponse> managePropertygraphStatistics(
            ManagePropertygraphStatisticsRequest managePropertygraphStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(managePropertygraphStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                managePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ManagePropertygraphStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ManagePropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ManagePropertygraphStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ManagePropertygraphStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ManagePropertygraphStatisticsRequest, ManagePropertygraphStatisticsResponse>()
                            .withOperationName("ManagePropertygraphStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ManagePropertygraphStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(managePropertygraphStatisticsRequest));
            CompletableFuture<ManagePropertygraphStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     * @return A Java Future containing the result of the ManageSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ManageSparqlStatisticsResponse> manageSparqlStatistics(
            ManageSparqlStatisticsRequest manageSparqlStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(manageSparqlStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, manageSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ManageSparqlStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ManageSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ManageSparqlStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ManageSparqlStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ManageSparqlStatisticsRequest, ManageSparqlStatisticsResponse>()
                            .withOperationName("ManageSparqlStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ManageSparqlStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(manageSparqlStatisticsRequest));
            CompletableFuture<ManageSparqlStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob"
     * >neptune-db:StartLoaderJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startLoaderJobRequest
     * @return A Java Future containing the result of the StartLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>S3Exception Raised when there is a problem accessing Amazon S3.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartLoaderJobResponse> startLoaderJob(StartLoaderJobRequest startLoaderJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startLoaderJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startLoaderJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartLoaderJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartLoaderJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartLoaderJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartLoaderJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartLoaderJobRequest, StartLoaderJobResponse>()
                            .withOperationName("StartLoaderJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartLoaderJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startLoaderJobRequest));
            CompletableFuture<StartLoaderJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob"
     * >neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     * @return A Java Future containing the result of the StartMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMlDataProcessingJobResponse> startMLDataProcessingJob(
            StartMlDataProcessingJobRequest startMlDataProcessingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMlDataProcessingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLDataProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMlDataProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMlDataProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMlDataProcessingJobRequest, StartMlDataProcessingJobResponse>()
                            .withOperationName("StartMLDataProcessingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMlDataProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMlDataProcessingJobRequest));
            CompletableFuture<StartMlDataProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob"
     * >neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     * @return A Java Future containing the result of the StartMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMlModelTrainingJobResponse> startMLModelTrainingJob(
            StartMlModelTrainingJobRequest startMlModelTrainingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMlModelTrainingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLModelTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMlModelTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMlModelTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMlModelTrainingJobRequest, StartMlModelTrainingJobResponse>()
                            .withOperationName("StartMLModelTrainingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMlModelTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMlModelTrainingJobRequest));
            CompletableFuture<StartMlModelTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob"
     * >neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTransformJobRequest
     * @return A Java Future containing the result of the StartMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMlModelTransformJobResponse> startMLModelTransformJob(
            StartMlModelTransformJobRequest startMlModelTransformJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMlModelTransformJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLModelTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMlModelTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMlModelTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMlModelTransformJobRequest, StartMlModelTransformJobResponse>()
                            .withOperationName("StartMLModelTransformJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMlModelTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMlModelTransformJobRequest));
            CompletableFuture<StartMlModelTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final NeptunedataServiceClientConfiguration serviceClientConfiguration() {
        return new NeptunedataServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NeptunedataException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .customErrorCodeFieldName("code")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamRecordsNotFoundException")
                                .exceptionBuilderSupplier(StreamRecordsNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BulkLoadIdNotFoundException")
                                .exceptionBuilderSupplier(BulkLoadIdNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNumericDataException")
                                .exceptionBuilderSupplier(InvalidNumericDataException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalArgumentException")
                                .exceptionBuilderSupplier(IllegalArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LoadUrlAccessDeniedException")
                                .exceptionBuilderSupplier(LoadUrlAccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingParameterException")
                                .exceptionBuilderSupplier(MissingParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CancelledByUserException")
                                .exceptionBuilderSupplier(CancelledByUserException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLimitExceededException")
                                .exceptionBuilderSupplier(QueryLimitExceededException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MemoryLimitExceededException")
                                .exceptionBuilderSupplier(MemoryLimitExceededException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParsingException")
                                .exceptionBuilderSupplier(ParsingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryTooLargeException")
                                .exceptionBuilderSupplier(QueryTooLargeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3Exception").exceptionBuilderSupplier(S3Exception::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReadOnlyViolationException")
                                .exceptionBuilderSupplier(ReadOnlyViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StatisticsNotAvailableException")
                                .exceptionBuilderSupplier(StatisticsNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgumentException")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MLResourceNotFoundException")
                                .exceptionBuilderSupplier(MlResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConstraintViolationException")
                                .exceptionBuilderSupplier(ConstraintViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedQueryException")
                                .exceptionBuilderSupplier(MalformedQueryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientTimeoutException")
                                .exceptionBuilderSupplier(ClientTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionsFailedException")
                                .exceptionBuilderSupplier(PreconditionsFailedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExpiredStreamException")
                                .exceptionBuilderSupplier(ExpiredStreamException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLimitException")
                                .exceptionBuilderSupplier(QueryLimitException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerShutdownException")
                                .exceptionBuilderSupplier(ServerShutdownException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FailureByQueryException")
                                .exceptionBuilderSupplier(FailureByQueryException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TimeLimitExceededException")
                                .exceptionBuilderSupplier(TimeLimitExceededException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        NeptunedataServiceClientConfigurationBuilder serviceConfigBuilder = new NeptunedataServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
