/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An edge structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeStructure implements SdkPojo, Serializable, ToCopyableBuilder<EdgeStructure.Builder, EdgeStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(EdgeStructure::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<String>> EDGE_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("edgeProperties")
            .getter(getter(EdgeStructure::edgeProperties))
            .setter(setter(Builder::edgeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            EDGE_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final List<String> edgeProperties;

    private EdgeStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.edgeProperties = builder.edgeProperties;
    }

    /**
     * <p>
     * The number of edges that have this specific structure.
     * </p>
     * 
     * @return The number of edges that have this specific structure.
     */
    public final Long count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeProperties() {
        return edgeProperties != null && !(edgeProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of edge properties present in this specific structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeProperties} method.
     * </p>
     * 
     * @return A list of edge properties present in this specific structure.
     */
    public final List<String> edgeProperties() {
        return edgeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeProperties() ? edgeProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStructure)) {
            return false;
        }
        EdgeStructure other = (EdgeStructure) obj;
        return Objects.equals(count(), other.count()) && hasEdgeProperties() == other.hasEdgeProperties()
                && Objects.equals(edgeProperties(), other.edgeProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeStructure").add("Count", count())
                .add("EdgeProperties", hasEdgeProperties() ? edgeProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "edgeProperties":
            return Optional.ofNullable(clazz.cast(edgeProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeStructure, T> g) {
        return obj -> g.apply((EdgeStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeStructure> {
        /**
         * <p>
         * The number of edges that have this specific structure.
         * </p>
         * 
         * @param count
         *        The number of edges that have this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * A list of edge properties present in this specific structure.
         * </p>
         * 
         * @param edgeProperties
         *        A list of edge properties present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeProperties(Collection<String> edgeProperties);

        /**
         * <p>
         * A list of edge properties present in this specific structure.
         * </p>
         * 
         * @param edgeProperties
         *        A list of edge properties present in this specific structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeProperties(String... edgeProperties);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private List<String> edgeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStructure model) {
            count(model.count);
            edgeProperties(model.edgeProperties);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getEdgeProperties() {
            if (edgeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeProperties;
        }

        public final void setEdgeProperties(Collection<String> edgeProperties) {
            this.edgeProperties = EdgePropertiesCopier.copy(edgeProperties);
        }

        @Override
        public final Builder edgeProperties(Collection<String> edgeProperties) {
            this.edgeProperties = EdgePropertiesCopier.copy(edgeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeProperties(String... edgeProperties) {
            edgeProperties(Arrays.asList(edgeProperties));
            return this;
        }

        @Override
        public EdgeStructure build() {
            return new EdgeStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
