/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteGremlinExplainQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteGremlinExplainQueryRequest.Builder, ExecuteGremlinExplainQueryRequest> {
    private static final SdkField<String> GREMLIN_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gremlinQuery").getter(getter(ExecuteGremlinExplainQueryRequest::gremlinQuery))
            .setter(setter(Builder::gremlinQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREMLIN_QUERY_FIELD));

    private final String gremlinQuery;

    private ExecuteGremlinExplainQueryRequest(BuilderImpl builder) {
        super(builder);
        this.gremlinQuery = builder.gremlinQuery;
    }

    /**
     * <p>
     * The Gremlin explain query string.
     * </p>
     * 
     * @return The Gremlin explain query string.
     */
    public final String gremlinQuery() {
        return gremlinQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gremlinQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinExplainQueryRequest)) {
            return false;
        }
        ExecuteGremlinExplainQueryRequest other = (ExecuteGremlinExplainQueryRequest) obj;
        return Objects.equals(gremlinQuery(), other.gremlinQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteGremlinExplainQueryRequest").add("GremlinQuery", gremlinQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gremlinQuery":
            return Optional.ofNullable(clazz.cast(gremlinQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinExplainQueryRequest, T> g) {
        return obj -> g.apply((ExecuteGremlinExplainQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteGremlinExplainQueryRequest> {
        /**
         * <p>
         * The Gremlin explain query string.
         * </p>
         * 
         * @param gremlinQuery
         *        The Gremlin explain query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gremlinQuery(String gremlinQuery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String gremlinQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinExplainQueryRequest model) {
            super(model);
            gremlinQuery(model.gremlinQuery);
        }

        public final String getGremlinQuery() {
            return gremlinQuery;
        }

        public final void setGremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
        }

        @Override
        public final Builder gremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteGremlinExplainQueryRequest build() {
            return new ExecuteGremlinExplainQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
