/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteGremlinProfileQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteGremlinProfileQueryRequest.Builder, ExecuteGremlinProfileQueryRequest> {
    private static final SdkField<String> GREMLIN_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gremlinQuery").getter(getter(ExecuteGremlinProfileQueryRequest::gremlinQuery))
            .setter(setter(Builder::gremlinQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()).build();

    private static final SdkField<Boolean> RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("results").getter(getter(ExecuteGremlinProfileQueryRequest::results)).setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.results").build()).build();

    private static final SdkField<Integer> CHOP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("chop")
            .getter(getter(ExecuteGremlinProfileQueryRequest::chop)).setter(setter(Builder::chop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.chop").build()).build();

    private static final SdkField<String> SERIALIZER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serializer").getter(getter(ExecuteGremlinProfileQueryRequest::serializer))
            .setter(setter(Builder::serializer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.serializer").build())
            .build();

    private static final SdkField<Boolean> INDEX_OPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("indexOps").getter(getter(ExecuteGremlinProfileQueryRequest::indexOps)).setter(setter(Builder::indexOps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile.indexOps").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREMLIN_QUERY_FIELD,
            RESULTS_FIELD, CHOP_FIELD, SERIALIZER_FIELD, INDEX_OPS_FIELD));

    private final String gremlinQuery;

    private final Boolean results;

    private final Integer chop;

    private final String serializer;

    private final Boolean indexOps;

    private ExecuteGremlinProfileQueryRequest(BuilderImpl builder) {
        super(builder);
        this.gremlinQuery = builder.gremlinQuery;
        this.results = builder.results;
        this.chop = builder.chop;
        this.serializer = builder.serializer;
        this.indexOps = builder.indexOps;
    }

    /**
     * <p>
     * The Gremlin query string to profile.
     * </p>
     * 
     * @return The Gremlin query string to profile.
     */
    public final String gremlinQuery() {
        return gremlinQuery;
    }

    /**
     * <p>
     * If this flag is set to <code>TRUE</code>, the query results are gathered and displayed as part of the profile
     * report. If <code>FALSE</code>, only the result count is displayed.
     * </p>
     * 
     * @return If this flag is set to <code>TRUE</code>, the query results are gathered and displayed as part of the
     *         profile report. If <code>FALSE</code>, only the result count is displayed.
     */
    public final Boolean results() {
        return results;
    }

    /**
     * <p>
     * If non-zero, causes the results string to be truncated at that number of characters. If set to zero, the string
     * contains all the results.
     * </p>
     * 
     * @return If non-zero, causes the results string to be truncated at that number of characters. If set to zero, the
     *         string contains all the results.
     */
    public final Integer chop() {
        return chop;
    }

    /**
     * <p>
     * If non-null, the gathered results are returned in a serialized response message in the format specified by this
     * parameter. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin
     * profile API in Neptune</a> for more information.
     * </p>
     * 
     * @return If non-null, the gathered results are returned in a serialized response message in the format specified
     *         by this parameter. See <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API
     *         in Neptune</a> for more information.
     */
    public final String serializer() {
        return serializer;
    }

    /**
     * <p>
     * If this flag is set to <code>TRUE</code>, the results include a detailed report of all index operations that took
     * place during query execution and serialization.
     * </p>
     * 
     * @return If this flag is set to <code>TRUE</code>, the results include a detailed report of all index operations
     *         that took place during query execution and serialization.
     */
    public final Boolean indexOps() {
        return indexOps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gremlinQuery());
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(chop());
        hashCode = 31 * hashCode + Objects.hashCode(serializer());
        hashCode = 31 * hashCode + Objects.hashCode(indexOps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinProfileQueryRequest)) {
            return false;
        }
        ExecuteGremlinProfileQueryRequest other = (ExecuteGremlinProfileQueryRequest) obj;
        return Objects.equals(gremlinQuery(), other.gremlinQuery()) && Objects.equals(results(), other.results())
                && Objects.equals(chop(), other.chop()) && Objects.equals(serializer(), other.serializer())
                && Objects.equals(indexOps(), other.indexOps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteGremlinProfileQueryRequest").add("GremlinQuery", gremlinQuery())
                .add("Results", results()).add("Chop", chop()).add("Serializer", serializer()).add("IndexOps", indexOps())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gremlinQuery":
            return Optional.ofNullable(clazz.cast(gremlinQuery()));
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "chop":
            return Optional.ofNullable(clazz.cast(chop()));
        case "serializer":
            return Optional.ofNullable(clazz.cast(serializer()));
        case "indexOps":
            return Optional.ofNullable(clazz.cast(indexOps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinProfileQueryRequest, T> g) {
        return obj -> g.apply((ExecuteGremlinProfileQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteGremlinProfileQueryRequest> {
        /**
         * <p>
         * The Gremlin query string to profile.
         * </p>
         * 
         * @param gremlinQuery
         *        The Gremlin query string to profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gremlinQuery(String gremlinQuery);

        /**
         * <p>
         * If this flag is set to <code>TRUE</code>, the query results are gathered and displayed as part of the profile
         * report. If <code>FALSE</code>, only the result count is displayed.
         * </p>
         * 
         * @param results
         *        If this flag is set to <code>TRUE</code>, the query results are gathered and displayed as part of the
         *        profile report. If <code>FALSE</code>, only the result count is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Boolean results);

        /**
         * <p>
         * If non-zero, causes the results string to be truncated at that number of characters. If set to zero, the
         * string contains all the results.
         * </p>
         * 
         * @param chop
         *        If non-zero, causes the results string to be truncated at that number of characters. If set to zero,
         *        the string contains all the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chop(Integer chop);

        /**
         * <p>
         * If non-null, the gathered results are returned in a serialized response message in the format specified by
         * this parameter. See <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
         * Neptune</a> for more information.
         * </p>
         * 
         * @param serializer
         *        If non-null, the gathered results are returned in a serialized response message in the format
         *        specified by this parameter. See <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile
         *        API in Neptune</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serializer(String serializer);

        /**
         * <p>
         * If this flag is set to <code>TRUE</code>, the results include a detailed report of all index operations that
         * took place during query execution and serialization.
         * </p>
         * 
         * @param indexOps
         *        If this flag is set to <code>TRUE</code>, the results include a detailed report of all index
         *        operations that took place during query execution and serialization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexOps(Boolean indexOps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String gremlinQuery;

        private Boolean results;

        private Integer chop;

        private String serializer;

        private Boolean indexOps;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinProfileQueryRequest model) {
            super(model);
            gremlinQuery(model.gremlinQuery);
            results(model.results);
            chop(model.chop);
            serializer(model.serializer);
            indexOps(model.indexOps);
        }

        public final String getGremlinQuery() {
            return gremlinQuery;
        }

        public final void setGremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
        }

        @Override
        public final Builder gremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
            return this;
        }

        public final Boolean getResults() {
            return results;
        }

        public final void setResults(Boolean results) {
            this.results = results;
        }

        @Override
        public final Builder results(Boolean results) {
            this.results = results;
            return this;
        }

        public final Integer getChop() {
            return chop;
        }

        public final void setChop(Integer chop) {
            this.chop = chop;
        }

        @Override
        public final Builder chop(Integer chop) {
            this.chop = chop;
            return this;
        }

        public final String getSerializer() {
            return serializer;
        }

        public final void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        @Override
        public final Builder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        public final Boolean getIndexOps() {
            return indexOps;
        }

        public final void setIndexOps(Boolean indexOps) {
            this.indexOps = indexOps;
        }

        @Override
        public final Builder indexOps(Boolean indexOps) {
            this.indexOps = indexOps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteGremlinProfileQueryRequest build() {
            return new ExecuteGremlinProfileQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
