/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLoaderJobsResponse extends NeptunedataResponse implements
        ToCopyableBuilder<ListLoaderJobsResponse.Builder, ListLoaderJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListLoaderJobsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<LoaderIdResult> PAYLOAD_FIELD = SdkField.<LoaderIdResult> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(ListLoaderJobsResponse::payload)).setter(setter(Builder::payload))
            .constructor(LoaderIdResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PAYLOAD_FIELD));

    private final String status;

    private final LoaderIdResult payload;

    private ListLoaderJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * Returns the status of the job list request.
     * </p>
     * 
     * @return Returns the status of the job list request.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The requested list of job IDs.
     * </p>
     * 
     * @return The requested list of job IDs.
     */
    public final LoaderIdResult payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoaderJobsResponse)) {
            return false;
        }
        ListLoaderJobsResponse other = (ListLoaderJobsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLoaderJobsResponse").add("Status", status()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLoaderJobsResponse, T> g) {
        return obj -> g.apply((ListLoaderJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLoaderJobsResponse> {
        /**
         * <p>
         * Returns the status of the job list request.
         * </p>
         * 
         * @param status
         *        Returns the status of the job list request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The requested list of job IDs.
         * </p>
         * 
         * @param payload
         *        The requested list of job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(LoaderIdResult payload);

        /**
         * <p>
         * The requested list of job IDs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoaderIdResult.Builder} avoiding the need
         * to create one manually via {@link LoaderIdResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoaderIdResult.Builder#build()} is called immediately and its
         * result is passed to {@link #payload(LoaderIdResult)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link LoaderIdResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(LoaderIdResult)
         */
        default Builder payload(Consumer<LoaderIdResult.Builder> payload) {
            return payload(LoaderIdResult.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private LoaderIdResult payload;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoaderJobsResponse model) {
            super(model);
            status(model.status);
            payload(model.payload);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final LoaderIdResult.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(LoaderIdResult.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(LoaderIdResult payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public ListLoaderJobsResponse build() {
            return new ListLoaderJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
