/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a Neptune ML resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MlResourceDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MlResourceDefinition.Builder, MlResourceDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MlResourceDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(MlResourceDefinition::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MlResourceDefinition::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputLocation").getter(getter(MlResourceDefinition::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(MlResourceDefinition::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> CLOUDWATCH_LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudwatchLogUrl").getter(getter(MlResourceDefinition::cloudwatchLogUrl))
            .setter(setter(Builder::cloudwatchLogUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchLogUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            STATUS_FIELD, OUTPUT_LOCATION_FIELD, FAILURE_REASON_FIELD, CLOUDWATCH_LOG_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String status;

    private final String outputLocation;

    private final String failureReason;

    private final String cloudwatchLogUrl;

    private MlResourceDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.outputLocation = builder.outputLocation;
        this.failureReason = builder.failureReason;
        this.cloudwatchLogUrl = builder.cloudwatchLogUrl;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @return The resource ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The resource status.
     * </p>
     * 
     * @return The resource status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The output location.
     * </p>
     * 
     * @return The output location.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The failure reason, in case of a failure.
     * </p>
     * 
     * @return The failure reason, in case of a failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The CloudWatch log URL for the resource.
     * </p>
     * 
     * @return The CloudWatch log URL for the resource.
     */
    public final String cloudwatchLogUrl() {
        return cloudwatchLogUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MlResourceDefinition)) {
            return false;
        }
        MlResourceDefinition other = (MlResourceDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(status(), other.status()) && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(cloudwatchLogUrl(), other.cloudwatchLogUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MlResourceDefinition").add("Name", name()).add("Arn", arn()).add("Status", status())
                .add("OutputLocation", outputLocation()).add("FailureReason", failureReason())
                .add("CloudwatchLogUrl", cloudwatchLogUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "cloudwatchLogUrl":
            return Optional.ofNullable(clazz.cast(cloudwatchLogUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MlResourceDefinition, T> g) {
        return obj -> g.apply((MlResourceDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MlResourceDefinition> {
        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param name
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource ARN.
         * </p>
         * 
         * @param arn
         *        The resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The resource status.
         * </p>
         * 
         * @param status
         *        The resource status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The output location.
         * </p>
         * 
         * @param outputLocation
         *        The output location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The failure reason, in case of a failure.
         * </p>
         * 
         * @param failureReason
         *        The failure reason, in case of a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The CloudWatch log URL for the resource.
         * </p>
         * 
         * @param cloudwatchLogUrl
         *        The CloudWatch log URL for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogUrl(String cloudwatchLogUrl);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String status;

        private String outputLocation;

        private String failureReason;

        private String cloudwatchLogUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(MlResourceDefinition model) {
            name(model.name);
            arn(model.arn);
            status(model.status);
            outputLocation(model.outputLocation);
            failureReason(model.failureReason);
            cloudwatchLogUrl(model.cloudwatchLogUrl);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getCloudwatchLogUrl() {
            return cloudwatchLogUrl;
        }

        public final void setCloudwatchLogUrl(String cloudwatchLogUrl) {
            this.cloudwatchLogUrl = cloudwatchLogUrl;
        }

        @Override
        public final Builder cloudwatchLogUrl(String cloudwatchLogUrl) {
            this.cloudwatchLogUrl = cloudwatchLogUrl;
            return this;
        }

        @Override
        public MlResourceDefinition build() {
            return new MlResourceDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
