/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobResponse;

/**
 * Service client for accessing Amazon NeptuneData asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * <fullname>Neptune Data API</fullname>
 * <p>
 * The Amazon Neptune data API provides SDK support for more than 40 of Neptune's data operations, including data
 * loading, query execution, data inquiry, and machine learning. It supports the Gremlin and openCypher query languages,
 * and is available in all SDK languages. It automatically signs API requests and greatly simplifies integrating Neptune
 * into your applications.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NeptunedataAsyncClient extends AwsClient {
    String SERVICE_NAME = "neptune-db";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "neptune-db";

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelGremlinQueryRequest
     * @return A Java Future containing the result of the CancelGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelGremlinQueryResponse> cancelGremlinQuery(CancelGremlinQueryRequest cancelGremlinQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelGremlinQueryRequest.Builder} avoiding the
     * need to create one manually via {@link CancelGremlinQueryRequest#builder()}
     * </p>
     *
     * @param cancelGremlinQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelGremlinQueryResponse> cancelGremlinQuery(
            Consumer<CancelGremlinQueryRequest.Builder> cancelGremlinQueryRequest) {
        return cancelGremlinQuery(CancelGremlinQueryRequest.builder().applyMutation(cancelGremlinQueryRequest).build());
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob"
     * >neptune-db:CancelLoaderJob</a> IAM action in that cluster..
     * </p>
     *
     * @param cancelLoaderJobRequest
     * @return A Java Future containing the result of the CancelLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelLoaderJobResponse> cancelLoaderJob(CancelLoaderJobRequest cancelLoaderJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob"
     * >neptune-db:CancelLoaderJob</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelLoaderJobRequest.Builder} avoiding the need
     * to create one manually via {@link CancelLoaderJobRequest#builder()}
     * </p>
     *
     * @param cancelLoaderJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelLoaderJobResponse> cancelLoaderJob(
            Consumer<CancelLoaderJobRequest.Builder> cancelLoaderJobRequest) {
        return cancelLoaderJob(CancelLoaderJobRequest.builder().applyMutation(cancelLoaderJobRequest).build());
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob"
     * >neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     * @return A Java Future containing the result of the CancelMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlDataProcessingJobResponse> cancelMLDataProcessingJob(
            CancelMlDataProcessingJobRequest cancelMlDataProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob"
     * >neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlDataProcessingJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlDataProcessingJobResponse> cancelMLDataProcessingJob(
            Consumer<CancelMlDataProcessingJobRequest.Builder> cancelMlDataProcessingJobRequest) {
        return cancelMLDataProcessingJob(CancelMlDataProcessingJobRequest.builder()
                .applyMutation(cancelMlDataProcessingJobRequest).build());
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob"
     * >neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     * @return A Java Future containing the result of the CancelMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlModelTrainingJobResponse> cancelMLModelTrainingJob(
            CancelMlModelTrainingJobRequest cancelMlModelTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob"
     * >neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlModelTrainingJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlModelTrainingJobResponse> cancelMLModelTrainingJob(
            Consumer<CancelMlModelTrainingJobRequest.Builder> cancelMlModelTrainingJobRequest) {
        return cancelMLModelTrainingJob(CancelMlModelTrainingJobRequest.builder().applyMutation(cancelMlModelTrainingJobRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob"
     * >neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     * @return A Java Future containing the result of the CancelMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlModelTransformJobResponse> cancelMLModelTransformJob(
            CancelMlModelTransformJobRequest cancelMlModelTransformJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob"
     * >neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlModelTransformJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMlModelTransformJobResponse> cancelMLModelTransformJob(
            Consumer<CancelMlModelTransformJobRequest.Builder> cancelMlModelTransformJobRequest) {
        return cancelMLModelTransformJob(CancelMlModelTransformJobRequest.builder()
                .applyMutation(cancelMlModelTransformJobRequest).build());
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     * @return A Java Future containing the result of the CancelOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelOpenCypherQueryResponse> cancelOpenCypherQuery(
            CancelOpenCypherQueryRequest cancelOpenCypherQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelOpenCypherQueryRequest.Builder} avoiding the
     * need to create one manually via {@link CancelOpenCypherQueryRequest#builder()}
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelOpenCypherQueryResponse> cancelOpenCypherQuery(
            Consumer<CancelOpenCypherQueryRequest.Builder> cancelOpenCypherQueryRequest) {
        return cancelOpenCypherQuery(CancelOpenCypherQueryRequest.builder().applyMutation(cancelOpenCypherQueryRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint"
     * >neptune-db:CreateMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param createMlEndpointRequest
     * @return A Java Future containing the result of the CreateMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMlEndpointResponse> createMLEndpoint(CreateMlEndpointRequest createMlEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint"
     * >neptune-db:CreateMLEndpoint</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMlEndpointRequest#builder()}
     * </p>
     *
     * @param createMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMlEndpointResponse> createMLEndpoint(
            Consumer<CreateMlEndpointRequest.Builder> createMlEndpointRequest) {
        return createMLEndpoint(CreateMlEndpointRequest.builder().applyMutation(createMlEndpointRequest).build());
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint"
     * >neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteMlEndpointRequest
     * @return A Java Future containing the result of the DeleteMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMlEndpointResponse> deleteMLEndpoint(DeleteMlEndpointRequest deleteMlEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint"
     * >neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMlEndpointRequest#builder()}
     * </p>
     *
     * @param deleteMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMlEndpointResponse> deleteMLEndpoint(
            Consumer<DeleteMlEndpointRequest.Builder> deleteMlEndpointRequest) {
        return deleteMLEndpoint(DeleteMlEndpointRequest.builder().applyMutation(deleteMlEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     * @return A Java Future containing the result of the DeletePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePropertygraphStatisticsResponse> deletePropertygraphStatistics(
            DeletePropertygraphStatisticsRequest deletePropertygraphStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePropertygraphStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePropertygraphStatisticsResponse> deletePropertygraphStatistics(
            Consumer<DeletePropertygraphStatisticsRequest.Builder> deletePropertygraphStatisticsRequest) {
        return deletePropertygraphStatistics(DeletePropertygraphStatisticsRequest.builder()
                .applyMutation(deletePropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     * @return A Java Future containing the result of the DeleteSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSparqlStatisticsResponse> deleteSparqlStatistics(
            DeleteSparqlStatisticsRequest deleteSparqlStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSparqlStatisticsResponse> deleteSparqlStatistics(
            Consumer<DeleteSparqlStatisticsRequest.Builder> deleteSparqlStatisticsRequest) {
        return deleteSparqlStatistics(DeleteSparqlStatisticsRequest.builder().applyMutation(deleteSparqlStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase"
     * >neptune-db:ResetDatabase</a> IAM action in that cluster.
     * </p>
     *
     * @param executeFastResetRequest
     * @return A Java Future containing the result of the ExecuteFastReset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ServerShutdownException Raised when the server shuts down while processing a request.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MethodNotAllowedException Raised when the HTTP method used by a request is not supported by the
     *         endpoint being used.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExecuteFastResetResponse> executeFastReset(ExecuteFastResetRequest executeFastResetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase"
     * >neptune-db:ResetDatabase</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteFastResetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteFastResetRequest#builder()}
     * </p>
     *
     * @param executeFastResetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteFastReset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ServerShutdownException Raised when the server shuts down while processing a request.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MethodNotAllowedException Raised when the HTTP method used by a request is not supported by the
     *         endpoint being used.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExecuteFastResetResponse> executeFastReset(
            Consumer<ExecuteFastResetRequest.Builder> executeFastResetRequest) {
        return executeFastReset(ExecuteFastResetRequest.builder().applyMutation(executeFastResetRequest).build());
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinExplainQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinExplainQueryResponse> executeGremlinExplainQuery(
            ExecuteGremlinExplainQueryRequest executeGremlinExplainQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinExplainQueryRequest.Builder} avoiding
     * the need to create one manually via {@link ExecuteGremlinExplainQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExecuteGremlinExplainQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinExplainQueryResponse> executeGremlinExplainQuery(
            Consumer<ExecuteGremlinExplainQueryRequest.Builder> executeGremlinExplainQueryRequest) {
        return executeGremlinExplainQuery(ExecuteGremlinExplainQueryRequest.builder()
                .applyMutation(executeGremlinExplainQueryRequest).build());
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinProfileQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinProfileQueryResponse> executeGremlinProfileQuery(
            ExecuteGremlinProfileQueryRequest executeGremlinProfileQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinProfileQueryRequest.Builder} avoiding
     * the need to create one manually via {@link ExecuteGremlinProfileQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExecuteGremlinProfileQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinProfileQueryResponse> executeGremlinProfileQuery(
            Consumer<ExecuteGremlinProfileQueryRequest.Builder> executeGremlinProfileQueryRequest) {
        return executeGremlinProfileQuery(ExecuteGremlinProfileQueryRequest.builder()
                .applyMutation(executeGremlinProfileQueryRequest).build());
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinQueryRequest
     * @return A Java Future containing the result of the ExecuteGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinQueryResponse> executeGremlinQuery(
            ExecuteGremlinQueryRequest executeGremlinQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteGremlinQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteGremlinQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteGremlinQueryResponse> executeGremlinQuery(
            Consumer<ExecuteGremlinQueryRequest.Builder> executeGremlinQueryRequest) {
        return executeGremlinQuery(ExecuteGremlinQueryRequest.builder().applyMutation(executeGremlinQueryRequest).build());
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     * @return A Java Future containing the result of the ExecuteOpenCypherExplainQuery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteOpenCypherExplainQueryResponse> executeOpenCypherExplainQuery(
            ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteOpenCypherExplainQueryRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteOpenCypherExplainQueryRequest#builder()}
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExecuteOpenCypherExplainQuery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteOpenCypherExplainQueryResponse> executeOpenCypherExplainQuery(
            Consumer<ExecuteOpenCypherExplainQueryRequest.Builder> executeOpenCypherExplainQueryRequest) {
        return executeOpenCypherExplainQuery(ExecuteOpenCypherExplainQueryRequest.builder()
                .applyMutation(executeOpenCypherExplainQueryRequest).build());
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     * <p>
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or
     * role making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note also that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     * @return A Java Future containing the result of the ExecuteOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteOpenCypherQueryResponse> executeOpenCypherQuery(
            ExecuteOpenCypherQueryRequest executeOpenCypherQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     * <p>
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or
     * role making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note also that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteOpenCypherQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteOpenCypherQueryRequest#builder()}
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ExecuteOpenCypherQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>QueryTooLargeException Raised when the body of a query is too large.</li>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>QueryLimitExceededException Raised when the number of active queries exceeds what the server can
     *         process. The query in question can be retried when the system is less busy.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>QueryLimitException Raised when the size of a query exceeds the system limit.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>CancelledByUserException Raised when a user cancelled a request.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>MalformedQueryException Raised when a query is submitted that is syntactically incorrect or does not
     *         pass additional validation.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteOpenCypherQueryResponse> executeOpenCypherQuery(
            Consumer<ExecuteOpenCypherQueryRequest.Builder> executeOpenCypherQueryRequest) {
        return executeOpenCypherQuery(ExecuteOpenCypherQueryRequest.builder().applyMutation(executeOpenCypherQueryRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of the graph database on the host.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus"
     * >neptune-db:GetEngineStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getEngineStatusRequest
     * @return A Java Future containing the result of the GetEngineStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEngineStatusResponse> getEngineStatus(GetEngineStatusRequest getEngineStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of the graph database on the host.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus"
     * >neptune-db:GetEngineStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEngineStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetEngineStatusRequest#builder()}
     * </p>
     *
     * @param getEngineStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEngineStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEngineStatusResponse> getEngineStatus(
            Consumer<GetEngineStatusRequest.Builder> getEngineStatusRequest) {
        return getEngineStatus(GetEngineStatusRequest.builder().applyMutation(getEngineStatusRequest).build());
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     * @return A Java Future containing the result of the GetGremlinQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGremlinQueryStatusResponse> getGremlinQueryStatus(
            GetGremlinQueryStatusRequest getGremlinQueryStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGremlinQueryStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetGremlinQueryStatusRequest#builder()}
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGremlinQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGremlinQueryStatusResponse> getGremlinQueryStatus(
            Consumer<GetGremlinQueryStatusRequest.Builder> getGremlinQueryStatusRequest) {
        return getGremlinQueryStatus(GetGremlinQueryStatusRequest.builder().applyMutation(getGremlinQueryStatusRequest).build());
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus"
     * >neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..
     * </p>
     *
     * @param getLoaderJobStatusRequest
     * @return A Java Future containing the result of the GetLoaderJobStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoaderJobStatusResponse> getLoaderJobStatus(GetLoaderJobStatusRequest getLoaderJobStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus"
     * >neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoaderJobStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetLoaderJobStatusRequest#builder()}
     * </p>
     *
     * @param getLoaderJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoaderJobStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoaderJobStatusResponse> getLoaderJobStatus(
            Consumer<GetLoaderJobStatusRequest.Builder> getLoaderJobStatusRequest) {
        return getLoaderJobStatus(GetLoaderJobStatusRequest.builder().applyMutation(getLoaderJobStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus"
     * >neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     * @return A Java Future containing the result of the GetMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlDataProcessingJobResponse> getMLDataProcessingJob(
            GetMlDataProcessingJobRequest getMlDataProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus"
     * >neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlDataProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlDataProcessingJobResponse> getMLDataProcessingJob(
            Consumer<GetMlDataProcessingJobRequest.Builder> getMlDataProcessingJobRequest) {
        return getMLDataProcessingJob(GetMlDataProcessingJobRequest.builder().applyMutation(getMlDataProcessingJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus"
     * >neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlEndpointRequest
     * @return A Java Future containing the result of the GetMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlEndpointResponse> getMLEndpoint(GetMlEndpointRequest getMlEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus"
     * >neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlEndpointRequest#builder()}
     * </p>
     *
     * @param getMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMLEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlEndpointResponse> getMLEndpoint(Consumer<GetMlEndpointRequest.Builder> getMlEndpointRequest) {
        return getMLEndpoint(GetMlEndpointRequest.builder().applyMutation(getMlEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus"
     * >neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     * @return A Java Future containing the result of the GetMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlModelTrainingJobResponse> getMLModelTrainingJob(
            GetMlModelTrainingJobRequest getMlModelTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus"
     * >neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlModelTrainingJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlModelTrainingJobResponse> getMLModelTrainingJob(
            Consumer<GetMlModelTrainingJobRequest.Builder> getMlModelTrainingJobRequest) {
        return getMLModelTrainingJob(GetMlModelTrainingJobRequest.builder().applyMutation(getMlModelTrainingJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus"
     * >neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTransformJobRequest
     * @return A Java Future containing the result of the GetMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlModelTransformJobResponse> getMLModelTransformJob(
            GetMlModelTransformJobRequest getMlModelTransformJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus"
     * >neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlModelTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param getMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlModelTransformJobResponse> getMLModelTransformJob(
            Consumer<GetMlModelTransformJobRequest.Builder> getMlModelTransformJobRequest) {
        return getMLModelTransformJob(GetMlModelTransformJobRequest.builder().applyMutation(getMlModelTransformJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     * @return A Java Future containing the result of the GetOpenCypherQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenCypherQueryStatusResponse> getOpenCypherQueryStatus(
            GetOpenCypherQueryStatusRequest getOpenCypherQueryStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenCypherQueryStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetOpenCypherQueryStatusRequest#builder()}
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetOpenCypherQueryStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOpenCypherQueryStatusResponse> getOpenCypherQueryStatus(
            Consumer<GetOpenCypherQueryStatusRequest.Builder> getOpenCypherQueryStatusRequest) {
        return getOpenCypherQueryStatus(GetOpenCypherQueryStatusRequest.builder().applyMutation(getOpenCypherQueryStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus"
     * >neptune-db:GetStatisticsStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     * @return A Java Future containing the result of the GetPropertygraphStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphStatisticsResponse> getPropertygraphStatistics(
            GetPropertygraphStatisticsRequest getPropertygraphStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus"
     * >neptune-db:GetStatisticsStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPropertygraphStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphStatisticsResponse> getPropertygraphStatistics(
            Consumer<GetPropertygraphStatisticsRequest.Builder> getPropertygraphStatisticsRequest) {
        return getPropertygraphStatistics(GetPropertygraphStatisticsRequest.builder()
                .applyMutation(getPropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions, depending on the
     * query:
     * </p>
     * <p>
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys
     * available in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getPropertygraphStreamRequest
     * @return A Java Future containing the result of the GetPropertygraphStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphStreamResponse> getPropertygraphStream(
            GetPropertygraphStreamRequest getPropertygraphStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions, depending on the
     * query:
     * </p>
     * <p>
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys
     * available in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphStreamRequest.Builder} avoiding the
     * need to create one manually via {@link GetPropertygraphStreamRequest#builder()}
     * </p>
     *
     * @param getPropertygraphStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetPropertygraphStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphStreamResponse> getPropertygraphStream(
            Consumer<GetPropertygraphStreamRequest.Builder> getPropertygraphStreamRequest) {
        return getPropertygraphStream(GetPropertygraphStreamRequest.builder().applyMutation(getPropertygraphStreamRequest)
                .build());
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     * @return A Java Future containing the result of the GetPropertygraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphSummaryResponse> getPropertygraphSummary(
            GetPropertygraphSummaryRequest getPropertygraphSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertygraphSummaryRequest#builder()}
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetPropertygraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPropertygraphSummaryResponse> getPropertygraphSummary(
            Consumer<GetPropertygraphSummaryRequest.Builder> getPropertygraphSummaryRequest) {
        return getPropertygraphSummary(GetPropertygraphSummaryRequest.builder().applyMutation(getPropertygraphSummaryRequest)
                .build());
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     * @return A Java Future containing the result of the GetRDFGraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRdfGraphSummaryResponse> getRDFGraphSummary(GetRdfGraphSummaryRequest getRdfGraphSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRdfGraphSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetRdfGraphSummaryRequest#builder()}
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRDFGraphSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRdfGraphSummaryResponse> getRDFGraphSummary(
            Consumer<GetRdfGraphSummaryRequest.Builder> getRdfGraphSummaryRequest) {
        return getRDFGraphSummary(GetRdfGraphSummaryRequest.builder().applyMutation(getRdfGraphSummaryRequest).build());
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     *
     * @param getSparqlStatisticsRequest
     * @return A Java Future containing the result of the GetSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSparqlStatisticsResponse> getSparqlStatistics(
            GetSparqlStatisticsRequest getSparqlStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param getSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSparqlStatisticsResponse> getSparqlStatistics(
            Consumer<GetSparqlStatisticsRequest.Builder> getSparqlStatisticsRequest) {
        return getSparqlStatistics(GetSparqlStatisticsRequest.builder().applyMutation(getSparqlStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of
     * SPARQL queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getSparqlStreamRequest
     * @return A Java Future containing the result of the GetSparqlStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSparqlStreamResponse> getSparqlStream(GetSparqlStreamRequest getSparqlStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of
     * SPARQL queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSparqlStreamRequest.Builder} avoiding the need
     * to create one manually via {@link GetSparqlStreamRequest#builder()}
     * </p>
     *
     * @param getSparqlStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSparqlStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>ExpiredStreamException Raised when a request attempts to access an stream that has expired.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>MemoryLimitExceededException Raised when a request fails because of insufficient memory resources.
     *         The request can be retried.</li>
     *         <li>StreamRecordsNotFoundException Raised when stream records requested by a query cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ThrottlingException Raised when the rate of requests exceeds the maximum throughput. Requests can be
     *         retried after encountering this exception.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSparqlStreamResponse> getSparqlStream(
            Consumer<GetSparqlStreamRequest.Builder> getSparqlStreamRequest) {
        return getSparqlStream(GetSparqlStreamRequest.builder().applyMutation(getSparqlStreamRequest).build());
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listGremlinQueriesRequest
     * @return A Java Future containing the result of the ListGremlinQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGremlinQueriesResponse> listGremlinQueries(ListGremlinQueriesRequest listGremlinQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGremlinQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGremlinQueriesRequest#builder()}
     * </p>
     *
     * @param listGremlinQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGremlinQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGremlinQueriesResponse> listGremlinQueries(
            Consumer<ListGremlinQueriesRequest.Builder> listGremlinQueriesRequest) {
        return listGremlinQueries(ListGremlinQueriesRequest.builder().applyMutation(listGremlinQueriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs"
     * >neptune-db:ListLoaderJobs</a> IAM action in that cluster..
     * </p>
     *
     * @param listLoaderJobsRequest
     * @return A Java Future containing the result of the ListLoaderJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLoaderJobsResponse> listLoaderJobs(ListLoaderJobsRequest listLoaderJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs"
     * >neptune-db:ListLoaderJobs</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoaderJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLoaderJobsRequest#builder()}
     * </p>
     *
     * @param listLoaderJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLoaderJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLoaderJobsResponse> listLoaderJobs(Consumer<ListLoaderJobsRequest.Builder> listLoaderJobsRequest) {
        return listLoaderJobs(ListLoaderJobsRequest.builder().applyMutation(listLoaderJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs"
     * >neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     * @return A Java Future containing the result of the ListMLDataProcessingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlDataProcessingJobsResponse> listMLDataProcessingJobs(
            ListMlDataProcessingJobsRequest listMlDataProcessingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs"
     * >neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlDataProcessingJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlDataProcessingJobsRequest#builder()}
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMLDataProcessingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlDataProcessingJobsResponse> listMLDataProcessingJobs(
            Consumer<ListMlDataProcessingJobsRequest.Builder> listMlDataProcessingJobsRequest) {
        return listMLDataProcessingJobs(ListMlDataProcessingJobsRequest.builder().applyMutation(listMlDataProcessingJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints"
     * >neptune-db:ListMLEndpoints</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlEndpointsRequest
     * @return A Java Future containing the result of the ListMLEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMlEndpointsResponse> listMLEndpoints(ListMlEndpointsRequest listMlEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints"
     * >neptune-db:ListMLEndpoints</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMlEndpointsRequest#builder()}
     * </p>
     *
     * @param listMlEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMLEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMlEndpointsResponse> listMLEndpoints(
            Consumer<ListMlEndpointsRequest.Builder> listMlEndpointsRequest) {
        return listMLEndpoints(ListMlEndpointsRequest.builder().applyMutation(listMlEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs"
     * >neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     * @return A Java Future containing the result of the ListMLModelTrainingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlModelTrainingJobsResponse> listMLModelTrainingJobs(
            ListMlModelTrainingJobsRequest listMlModelTrainingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs"
     * >neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlModelTrainingJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlModelTrainingJobsRequest#builder()}
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMLModelTrainingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlModelTrainingJobsResponse> listMLModelTrainingJobs(
            Consumer<ListMlModelTrainingJobsRequest.Builder> listMlModelTrainingJobsRequest) {
        return listMLModelTrainingJobs(ListMlModelTrainingJobsRequest.builder().applyMutation(listMlModelTrainingJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs"
     * >neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     * @return A Java Future containing the result of the ListMLModelTransformJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlModelTransformJobsResponse> listMLModelTransformJobs(
            ListMlModelTransformJobsRequest listMlModelTransformJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs"
     * >neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlModelTransformJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlModelTransformJobsRequest#builder()}
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMLModelTransformJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlModelTransformJobsResponse> listMLModelTransformJobs(
            Consumer<ListMlModelTransformJobsRequest.Builder> listMlModelTransformJobsRequest) {
        return listMLModelTransformJobs(ListMlModelTransformJobsRequest.builder().applyMutation(listMlModelTransformJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     * @return A Java Future containing the result of the ListOpenCypherQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenCypherQueriesResponse> listOpenCypherQueries(
            ListOpenCypherQueriesRequest listOpenCypherQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenCypherQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListOpenCypherQueriesRequest#builder()}
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOpenCypherQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNumericDataException Raised when invalid numerical data is encountered when servicing a
     *         request.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>FailureByQueryException Raised when a request fails.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ParsingException Raised when a parsing issue is encountered.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>TimeLimitExceededException Raised when the an operation exceeds the time limit allowed for it.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>ConcurrentModificationException Raised when a request attempts to modify data that is concurrently
     *         being modified by another process.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenCypherQueriesResponse> listOpenCypherQueries(
            Consumer<ListOpenCypherQueriesRequest.Builder> listOpenCypherQueriesRequest) {
        return listOpenCypherQueries(ListOpenCypherQueriesRequest.builder().applyMutation(listOpenCypherQueriesRequest).build());
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     * @return A Java Future containing the result of the ManagePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ManagePropertygraphStatisticsResponse> managePropertygraphStatistics(
            ManagePropertygraphStatisticsRequest managePropertygraphStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ManagePropertygraphStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link ManagePropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ManagePropertygraphStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ManagePropertygraphStatisticsResponse> managePropertygraphStatistics(
            Consumer<ManagePropertygraphStatisticsRequest.Builder> managePropertygraphStatisticsRequest) {
        return managePropertygraphStatistics(ManagePropertygraphStatisticsRequest.builder()
                .applyMutation(managePropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     * @return A Java Future containing the result of the ManageSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ManageSparqlStatisticsResponse> manageSparqlStatistics(
            ManageSparqlStatisticsRequest manageSparqlStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ManageSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ManageSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ManageSparqlStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>StatisticsNotAvailableException Raised when statistics needed to satisfy a request are not available.
     *         </li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>AccessDeniedException Raised in case of an authentication or authorization failure.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ReadOnlyViolationException Raised when a request attempts to write to a read-only resource.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ManageSparqlStatisticsResponse> manageSparqlStatistics(
            Consumer<ManageSparqlStatisticsRequest.Builder> manageSparqlStatisticsRequest) {
        return manageSparqlStatistics(ManageSparqlStatisticsRequest.builder().applyMutation(manageSparqlStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob"
     * >neptune-db:StartLoaderJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startLoaderJobRequest
     * @return A Java Future containing the result of the StartLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>S3Exception Raised when there is a problem accessing Amazon S3.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartLoaderJobResponse> startLoaderJob(StartLoaderJobRequest startLoaderJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob"
     * >neptune-db:StartLoaderJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLoaderJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartLoaderJobRequest#builder()}
     * </p>
     *
     * @param startLoaderJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartLoaderJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>BulkLoadIdNotFoundException Raised when a specified bulk-load job ID cannot be found.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>LoadUrlAccessDeniedException Raised when access is denied to a specified load URL.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>InternalFailureException Raised when the processing of the request failed unexpectedly.</li>
     *         <li>S3Exception Raised when there is a problem accessing Amazon S3.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartLoaderJobResponse> startLoaderJob(Consumer<StartLoaderJobRequest.Builder> startLoaderJobRequest) {
        return startLoaderJob(StartLoaderJobRequest.builder().applyMutation(startLoaderJobRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob"
     * >neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     * @return A Java Future containing the result of the StartMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlDataProcessingJobResponse> startMLDataProcessingJob(
            StartMlDataProcessingJobRequest startMlDataProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob"
     * >neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlDataProcessingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartMLDataProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlDataProcessingJobResponse> startMLDataProcessingJob(
            Consumer<StartMlDataProcessingJobRequest.Builder> startMlDataProcessingJobRequest) {
        return startMLDataProcessingJob(StartMlDataProcessingJobRequest.builder().applyMutation(startMlDataProcessingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob"
     * >neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     * @return A Java Future containing the result of the StartMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlModelTrainingJobResponse> startMLModelTrainingJob(
            StartMlModelTrainingJobRequest startMlModelTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob"
     * >neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlModelTrainingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartMLModelTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlModelTrainingJobResponse> startMLModelTrainingJob(
            Consumer<StartMlModelTrainingJobRequest.Builder> startMlModelTrainingJobRequest) {
        return startMLModelTrainingJob(StartMlModelTrainingJobRequest.builder().applyMutation(startMlModelTrainingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob"
     * >neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTransformJobRequest
     * @return A Java Future containing the result of the StartMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlModelTransformJobResponse> startMLModelTransformJob(
            StartMlModelTransformJobRequest startMlModelTransformJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob"
     * >neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlModelTransformJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param startMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartMLModelTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException Raised when a request attempts to initiate an operation that is not
     *         supported.</li>
     *         <li>BadRequestException Raised when a request is submitted that cannot be processed.</li>
     *         <li>MlResourceNotFoundException Raised when a specified machine-learning resource could not be found.</li>
     *         <li>InvalidParameterException Raised when a parameter value is not valid.</li>
     *         <li>ClientTimeoutException Raised when a request timed out in the client.</li>
     *         <li>PreconditionsFailedException Raised when a precondition for processing a request is not satisfied.</li>
     *         <li>ConstraintViolationException Raised when a value in a request field did not satisfy required
     *         constraints.</li>
     *         <li>InvalidArgumentException Raised when an argument in a request has an invalid value.</li>
     *         <li>MissingParameterException Raised when a required parameter is missing.</li>
     *         <li>IllegalArgumentException Raised when an argument in a request is not supported.</li>
     *         <li>TooManyRequestsException Raised when the number of requests being processed exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptunedataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptunedataAsyncClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMlModelTransformJobResponse> startMLModelTransformJob(
            Consumer<StartMlModelTransformJobRequest.Builder> startMlModelTransformJobRequest) {
        return startMLModelTransformJob(StartMlModelTransformJobRequest.builder().applyMutation(startMlModelTransformJobRequest)
                .build());
    }

    @Override
    default NeptunedataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NeptunedataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptunedataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptunedataAsyncClient}.
     */
    static NeptunedataAsyncClientBuilder builder() {
        return new DefaultNeptunedataAsyncClientBuilder();
    }
}
