/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The payload for DeleteStatistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStatisticsValueMap implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteStatisticsValueMap.Builder, DeleteStatisticsValueMap> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(DeleteStatisticsValueMap::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<String> STATISTICS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statisticsId").getter(getter(DeleteStatisticsValueMap::statisticsId))
            .setter(setter(Builder::statisticsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticsId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD,
            STATISTICS_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private final String statisticsId;

    private DeleteStatisticsValueMap(BuilderImpl builder) {
        this.active = builder.active;
        this.statisticsId = builder.statisticsId;
    }

    /**
     * <p>
     * The current status of the statistics.
     * </p>
     * 
     * @return The current status of the statistics.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * The ID of the statistics generation run that is currently occurring.
     * </p>
     * 
     * @return The ID of the statistics generation run that is currently occurring.
     */
    public final String statisticsId() {
        return statisticsId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(statisticsId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStatisticsValueMap)) {
            return false;
        }
        DeleteStatisticsValueMap other = (DeleteStatisticsValueMap) obj;
        return Objects.equals(active(), other.active()) && Objects.equals(statisticsId(), other.statisticsId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStatisticsValueMap").add("Active", active()).add("StatisticsId", statisticsId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "statisticsId":
            return Optional.ofNullable(clazz.cast(statisticsId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStatisticsValueMap, T> g) {
        return obj -> g.apply((DeleteStatisticsValueMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteStatisticsValueMap> {
        /**
         * <p>
         * The current status of the statistics.
         * </p>
         * 
         * @param active
         *        The current status of the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * The ID of the statistics generation run that is currently occurring.
         * </p>
         * 
         * @param statisticsId
         *        The ID of the statistics generation run that is currently occurring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsId(String statisticsId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private String statisticsId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStatisticsValueMap model) {
            active(model.active);
            statisticsId(model.statisticsId);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getStatisticsId() {
            return statisticsId;
        }

        public final void setStatisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
        }

        @Override
        public final Builder statisticsId(String statisticsId) {
            this.statisticsId = statisticsId;
            return this;
        }

        @Override
        public DeleteStatisticsValueMap build() {
            return new DeleteStatisticsValueMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
