/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteGremlinQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ExecuteGremlinQueryRequest.Builder, ExecuteGremlinQueryRequest> {
    private static final SdkField<String> GREMLIN_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gremlinQuery").getter(getter(ExecuteGremlinQueryRequest::gremlinQuery))
            .setter(setter(Builder::gremlinQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()).build();

    private static final SdkField<String> SERIALIZER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serializer").getter(getter(ExecuteGremlinQueryRequest::serializer)).setter(setter(Builder::serializer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("accept").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREMLIN_QUERY_FIELD,
            SERIALIZER_FIELD));

    private final String gremlinQuery;

    private final String serializer;

    private ExecuteGremlinQueryRequest(BuilderImpl builder) {
        super(builder);
        this.gremlinQuery = builder.gremlinQuery;
        this.serializer = builder.serializer;
    }

    /**
     * <p>
     * Using this API, you can run Gremlin queries in string format much as you can using the HTTP endpoint. The
     * interface is compatible with whatever Gremlin version your DB cluster is using (see the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest"
     * >Tinkerpop client section</a> to determine which Gremlin releases your engine version supports).
     * </p>
     * 
     * @return Using this API, you can run Gremlin queries in string format much as you can using the HTTP endpoint. The
     *         interface is compatible with whatever Gremlin version your DB cluster is using (see the <a href=
     *         "https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest"
     *         >Tinkerpop client section</a> to determine which Gremlin releases your engine version supports).
     */
    public final String gremlinQuery() {
        return gremlinQuery;
    }

    /**
     * <p>
     * If non-null, the query results are returned in a serialized response message in the format specified by this
     * parameter. See the <a href="https://tinkerpop.apache.org/docs/current/reference/#_graphson">GraphSON</a> section
     * in the TinkerPop documentation for a list of the formats that are currently supported.
     * </p>
     * 
     * @return If non-null, the query results are returned in a serialized response message in the format specified by
     *         this parameter. See the <a
     *         href="https://tinkerpop.apache.org/docs/current/reference/#_graphson">GraphSON</a> section in the
     *         TinkerPop documentation for a list of the formats that are currently supported.
     */
    public final String serializer() {
        return serializer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gremlinQuery());
        hashCode = 31 * hashCode + Objects.hashCode(serializer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinQueryRequest)) {
            return false;
        }
        ExecuteGremlinQueryRequest other = (ExecuteGremlinQueryRequest) obj;
        return Objects.equals(gremlinQuery(), other.gremlinQuery()) && Objects.equals(serializer(), other.serializer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteGremlinQueryRequest").add("GremlinQuery", gremlinQuery()).add("Serializer", serializer())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gremlinQuery":
            return Optional.ofNullable(clazz.cast(gremlinQuery()));
        case "serializer":
            return Optional.ofNullable(clazz.cast(serializer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinQueryRequest, T> g) {
        return obj -> g.apply((ExecuteGremlinQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteGremlinQueryRequest> {
        /**
         * <p>
         * Using this API, you can run Gremlin queries in string format much as you can using the HTTP endpoint. The
         * interface is compatible with whatever Gremlin version your DB cluster is using (see the <a href=
         * "https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest"
         * >Tinkerpop client section</a> to determine which Gremlin releases your engine version supports).
         * </p>
         * 
         * @param gremlinQuery
         *        Using this API, you can run Gremlin queries in string format much as you can using the HTTP endpoint.
         *        The interface is compatible with whatever Gremlin version your DB cluster is using (see the <a href=
         *        "https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest"
         *        >Tinkerpop client section</a> to determine which Gremlin releases your engine version supports).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gremlinQuery(String gremlinQuery);

        /**
         * <p>
         * If non-null, the query results are returned in a serialized response message in the format specified by this
         * parameter. See the <a href="https://tinkerpop.apache.org/docs/current/reference/#_graphson">GraphSON</a>
         * section in the TinkerPop documentation for a list of the formats that are currently supported.
         * </p>
         * 
         * @param serializer
         *        If non-null, the query results are returned in a serialized response message in the format specified
         *        by this parameter. See the <a
         *        href="https://tinkerpop.apache.org/docs/current/reference/#_graphson">GraphSON</a> section in the
         *        TinkerPop documentation for a list of the formats that are currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serializer(String serializer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String gremlinQuery;

        private String serializer;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinQueryRequest model) {
            super(model);
            gremlinQuery(model.gremlinQuery);
            serializer(model.serializer);
        }

        public final String getGremlinQuery() {
            return gremlinQuery;
        }

        public final void setGremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
        }

        @Override
        public final Builder gremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
            return this;
        }

        public final String getSerializer() {
            return serializer;
        }

        public final void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        @Override
        public final Builder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteGremlinQueryRequest build() {
            return new ExecuteGremlinQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
