/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLoaderJobResponse extends NeptunedataResponse implements
        ToCopyableBuilder<StartLoaderJobResponse.Builder, StartLoaderJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartLoaderJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> PAYLOAD_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("payload")
            .getter(getter(StartLoaderJobResponse::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PAYLOAD_FIELD));

    private final String status;

    private final Map<String, String> payload;

    private StartLoaderJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The HTTP return code indicating the status of the load job.
     * </p>
     * 
     * @return The HTTP return code indicating the status of the load job.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Payload property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPayload() {
        return payload != null && !(payload instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains a <code>loadId</code> name-value pair that provides an identifier for the load operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayload} method.
     * </p>
     * 
     * @return Contains a <code>loadId</code> name-value pair that provides an identifier for the load operation.
     */
    public final Map<String, String> payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasPayload() ? payload() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLoaderJobResponse)) {
            return false;
        }
        StartLoaderJobResponse other = (StartLoaderJobResponse) obj;
        return Objects.equals(status(), other.status()) && hasPayload() == other.hasPayload()
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartLoaderJobResponse").add("Status", status()).add("Payload", hasPayload() ? payload() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartLoaderJobResponse, T> g) {
        return obj -> g.apply((StartLoaderJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartLoaderJobResponse> {
        /**
         * <p>
         * The HTTP return code indicating the status of the load job.
         * </p>
         * 
         * @param status
         *        The HTTP return code indicating the status of the load job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Contains a <code>loadId</code> name-value pair that provides an identifier for the load operation.
         * </p>
         * 
         * @param payload
         *        Contains a <code>loadId</code> name-value pair that provides an identifier for the load operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Map<String, String> payload);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private Map<String, String> payload = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartLoaderJobResponse model) {
            super(model);
            status(model.status);
            payload(model.payload);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getPayload() {
            if (payload instanceof SdkAutoConstructMap) {
                return null;
            }
            return payload;
        }

        public final void setPayload(Map<String, String> payload) {
            this.payload = StringValuedMapCopier.copy(payload);
        }

        @Override
        public final Builder payload(Map<String, String> payload) {
            this.payload = StringValuedMapCopier.copy(payload);
            return this;
        }

        @Override
        public StartLoaderJobResponse build() {
            return new StartLoaderJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
