/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The high-level properties of a TLS inspection configuration. This, along with the
 * <code>TLSInspectionConfiguration</code>, define the TLS inspection configuration. You can retrieve all objects for a
 * TLS inspection configuration by calling <code>DescribeTLSInspectionConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TLSInspectionConfigurationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TLSInspectionConfigurationResponse.Builder, TLSInspectionConfigurationResponse> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationArn")
            .getter(getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationArn))
            .setter(setter(Builder::tlsInspectionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn")
                    .build()).build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationName")
            .getter(getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationName))
            .setter(setter(Builder::tlsInspectionConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName")
                    .build()).build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationId")
            .getter(getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationId))
            .setter(setter(Builder::tlsInspectionConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationId")
                    .build()).build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationStatus")
            .getter(getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationStatusAsString))
            .setter(setter(Builder::tlsInspectionConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationStatus")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TLSInspectionConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TLSInspectionConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TLSInspectionConfigurationResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> NUMBER_OF_ASSOCIATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfAssociations").getter(getter(TLSInspectionConfigurationResponse::numberOfAssociations))
            .setter(setter(Builder::numberOfAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociations").build())
            .build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(TLSInspectionConfigurationResponse::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<List<TlsCertificateData>> CERTIFICATES_FIELD = SdkField
            .<List<TlsCertificateData>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(TLSInspectionConfigurationResponse::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TlsCertificateData> builder(MarshallingType.SDK_POJO)
                                            .constructor(TlsCertificateData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TlsCertificateData> CERTIFICATE_AUTHORITY_FIELD = SdkField
            .<TlsCertificateData> builder(MarshallingType.SDK_POJO).memberName("CertificateAuthority")
            .getter(getter(TLSInspectionConfigurationResponse::certificateAuthority))
            .setter(setter(Builder::certificateAuthority)).constructor(TlsCertificateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthority").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TLS_INSPECTION_CONFIGURATION_ARN_FIELD, TLS_INSPECTION_CONFIGURATION_NAME_FIELD,
            TLS_INSPECTION_CONFIGURATION_ID_FIELD, TLS_INSPECTION_CONFIGURATION_STATUS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            LAST_MODIFIED_TIME_FIELD, NUMBER_OF_ASSOCIATIONS_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CERTIFICATES_FIELD,
            CERTIFICATE_AUTHORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tlsInspectionConfigurationArn;

    private final String tlsInspectionConfigurationName;

    private final String tlsInspectionConfigurationId;

    private final String tlsInspectionConfigurationStatus;

    private final String description;

    private final List<Tag> tags;

    private final Instant lastModifiedTime;

    private final Integer numberOfAssociations;

    private final EncryptionConfiguration encryptionConfiguration;

    private final List<TlsCertificateData> certificates;

    private final TlsCertificateData certificateAuthority;

    private TLSInspectionConfigurationResponse(BuilderImpl builder) {
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
        this.tlsInspectionConfigurationId = builder.tlsInspectionConfigurationId;
        this.tlsInspectionConfigurationStatus = builder.tlsInspectionConfigurationStatus;
        this.description = builder.description;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.numberOfAssociations = builder.numberOfAssociations;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.certificates = builder.certificates;
        this.certificateAuthority = builder.certificateAuthority;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    public final String tlsInspectionConfigurationArn() {
        return tlsInspectionConfigurationArn;
    }

    /**
     * <p>
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     * configuration after you create it.
     * </p>
     * 
     * @return The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     *         configuration after you create it.
     */
    public final String tlsInspectionConfigurationName() {
        return tlsInspectionConfigurationName;
    }

    /**
     * <p>
     * A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and list
     * commands. You provide it to operations such as update and delete.
     * </p>
     * 
     * @return A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create
     *         and list commands. You provide it to operations such as update and delete.
     */
    public final String tlsInspectionConfigurationId() {
        return tlsInspectionConfigurationId;
    }

    /**
     * <p>
     * Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve this for a
     * TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and providing the TLS
     * inspection configuration name and ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tlsInspectionConfigurationStatus} will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #tlsInspectionConfigurationStatusAsString}.
     * </p>
     * 
     * @return Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve
     *         this for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and
     *         providing the TLS inspection configuration name and ARN.
     * @see ResourceStatus
     */
    public final ResourceStatus tlsInspectionConfigurationStatus() {
        return ResourceStatus.fromValue(tlsInspectionConfigurationStatus);
    }

    /**
     * <p>
     * Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve this for a
     * TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and providing the TLS
     * inspection configuration name and ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tlsInspectionConfigurationStatus} will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #tlsInspectionConfigurationStatusAsString}.
     * </p>
     * 
     * @return Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve
     *         this for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and
     *         providing the TLS inspection configuration name and ARN.
     * @see ResourceStatus
     */
    public final String tlsInspectionConfigurationStatusAsString() {
        return tlsInspectionConfigurationStatus;
    }

    /**
     * <p>
     * A description of the TLS inspection configuration.
     * </p>
     * 
     * @return A description of the TLS inspection configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The last time that the TLS inspection configuration was changed.
     * </p>
     * 
     * @return The last time that the TLS inspection configuration was changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The number of firewall policies that use this TLS inspection configuration.
     * </p>
     * 
     * @return The number of firewall policies that use this TLS inspection configuration.
     */
    public final Integer numberOfAssociations() {
        return numberOfAssociations;
    }

    /**
     * <p>
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
     * inspection configuration.
     * </p>
     * 
     * @return A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
     *         inspection configuration.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Certificates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the certificates associated with the TLS inspection configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificates} method.
     * </p>
     * 
     * @return A list of the certificates associated with the TLS inspection configuration.
     */
    public final List<TlsCertificateData> certificates() {
        return certificates;
    }

    /**
     * Returns the value of the CertificateAuthority property for this object.
     * 
     * @return The value of the CertificateAuthority property for this object.
     */
    public final TlsCertificateData certificateAuthority() {
        return certificateAuthority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLSInspectionConfigurationResponse)) {
            return false;
        }
        TLSInspectionConfigurationResponse other = (TLSInspectionConfigurationResponse) obj;
        return Objects.equals(tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn())
                && Objects.equals(tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName())
                && Objects.equals(tlsInspectionConfigurationId(), other.tlsInspectionConfigurationId())
                && Objects.equals(tlsInspectionConfigurationStatusAsString(), other.tlsInspectionConfigurationStatusAsString())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(numberOfAssociations(), other.numberOfAssociations())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && hasCertificates() == other.hasCertificates() && Objects.equals(certificates(), other.certificates())
                && Objects.equals(certificateAuthority(), other.certificateAuthority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TLSInspectionConfigurationResponse")
                .add("TLSInspectionConfigurationArn", tlsInspectionConfigurationArn())
                .add("TLSInspectionConfigurationName", tlsInspectionConfigurationName())
                .add("TLSInspectionConfigurationId", tlsInspectionConfigurationId())
                .add("TLSInspectionConfigurationStatus", tlsInspectionConfigurationStatusAsString())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("NumberOfAssociations", numberOfAssociations())
                .add("EncryptionConfiguration", encryptionConfiguration())
                .add("Certificates", hasCertificates() ? certificates() : null)
                .add("CertificateAuthority", certificateAuthority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TLSInspectionConfigurationArn":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationArn()));
        case "TLSInspectionConfigurationName":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationName()));
        case "TLSInspectionConfigurationId":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationId()));
        case "TLSInspectionConfigurationStatus":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationStatusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "NumberOfAssociations":
            return Optional.ofNullable(clazz.cast(numberOfAssociations()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "CertificateAuthority":
            return Optional.ofNullable(clazz.cast(certificateAuthority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TLSInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((TLSInspectionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TLSInspectionConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * </p>
         * 
         * @param tlsInspectionConfigurationArn
         *        The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn);

        /**
         * <p>
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
         * configuration after you create it.
         * </p>
         * 
         * @param tlsInspectionConfigurationName
         *        The descriptive name of the TLS inspection configuration. You can't change the name of a TLS
         *        inspection configuration after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName);

        /**
         * <p>
         * A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and
         * list commands. You provide it to operations such as update and delete.
         * </p>
         * 
         * @param tlsInspectionConfigurationId
         *        A unique identifier for the TLS inspection configuration. This ID is returned in the responses to
         *        create and list commands. You provide it to operations such as update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationId(String tlsInspectionConfigurationId);

        /**
         * <p>
         * Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve this
         * for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and providing the TLS
         * inspection configuration name and ARN.
         * </p>
         * 
         * @param tlsInspectionConfigurationStatus
         *        Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve
         *        this for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and
         *        providing the TLS inspection configuration name and ARN.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder tlsInspectionConfigurationStatus(String tlsInspectionConfigurationStatus);

        /**
         * <p>
         * Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve this
         * for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and providing the TLS
         * inspection configuration name and ARN.
         * </p>
         * 
         * @param tlsInspectionConfigurationStatus
         *        Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve
         *        this for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and
         *        providing the TLS inspection configuration name and ARN.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder tlsInspectionConfigurationStatus(ResourceStatus tlsInspectionConfigurationStatus);

        /**
         * <p>
         * A description of the TLS inspection configuration.
         * </p>
         * 
         * @param description
         *        A description of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The last time that the TLS inspection configuration was changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the TLS inspection configuration was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The number of firewall policies that use this TLS inspection configuration.
         * </p>
         * 
         * @param numberOfAssociations
         *        The number of firewall policies that use this TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociations(Integer numberOfAssociations);

        /**
         * <p>
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
         * inspection configuration.
         * </p>
         * 
         * @param encryptionConfiguration
         *        A complex type that contains the Amazon Web Services KMS encryption configuration settings for your
         *        TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
         * inspection configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * A list of the certificates associated with the TLS inspection configuration.
         * </p>
         * 
         * @param certificates
         *        A list of the certificates associated with the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<TlsCertificateData> certificates);

        /**
         * <p>
         * A list of the certificates associated with the TLS inspection configuration.
         * </p>
         * 
         * @param certificates
         *        A list of the certificates associated with the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(TlsCertificateData... certificates);

        /**
         * <p>
         * A list of the certificates associated with the TLS inspection configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData.Builder#build()} is called
         * immediately and its result is passed to {@link #certificates(List<TlsCertificateData>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(java.util.Collection<TlsCertificateData>)
         */
        Builder certificates(Consumer<TlsCertificateData.Builder>... certificates);

        /**
         * Sets the value of the CertificateAuthority property for this object.
         *
         * @param certificateAuthority
         *        The new value for the CertificateAuthority property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthority(TlsCertificateData certificateAuthority);

        /**
         * Sets the value of the CertificateAuthority property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TlsCertificateData.Builder} avoiding the
         * need to create one manually via {@link TlsCertificateData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsCertificateData.Builder#build()} is called immediately and its
         * result is passed to {@link #certificateAuthority(TlsCertificateData)}.
         * 
         * @param certificateAuthority
         *        a consumer that will call methods on {@link TlsCertificateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAuthority(TlsCertificateData)
         */
        default Builder certificateAuthority(Consumer<TlsCertificateData.Builder> certificateAuthority) {
            return certificateAuthority(TlsCertificateData.builder().applyMutation(certificateAuthority).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tlsInspectionConfigurationArn;

        private String tlsInspectionConfigurationName;

        private String tlsInspectionConfigurationId;

        private String tlsInspectionConfigurationStatus;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private Integer numberOfAssociations;

        private EncryptionConfiguration encryptionConfiguration;

        private List<TlsCertificateData> certificates = DefaultSdkAutoConstructList.getInstance();

        private TlsCertificateData certificateAuthority;

        private BuilderImpl() {
        }

        private BuilderImpl(TLSInspectionConfigurationResponse model) {
            tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
            tlsInspectionConfigurationId(model.tlsInspectionConfigurationId);
            tlsInspectionConfigurationStatus(model.tlsInspectionConfigurationStatus);
            description(model.description);
            tags(model.tags);
            lastModifiedTime(model.lastModifiedTime);
            numberOfAssociations(model.numberOfAssociations);
            encryptionConfiguration(model.encryptionConfiguration);
            certificates(model.certificates);
            certificateAuthority(model.certificateAuthority);
        }

        public final String getTlsInspectionConfigurationArn() {
            return tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final String getTlsInspectionConfigurationName() {
            return tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        public final String getTlsInspectionConfigurationId() {
            return tlsInspectionConfigurationId;
        }

        public final void setTlsInspectionConfigurationId(String tlsInspectionConfigurationId) {
            this.tlsInspectionConfigurationId = tlsInspectionConfigurationId;
        }

        @Override
        public final Builder tlsInspectionConfigurationId(String tlsInspectionConfigurationId) {
            this.tlsInspectionConfigurationId = tlsInspectionConfigurationId;
            return this;
        }

        public final String getTlsInspectionConfigurationStatus() {
            return tlsInspectionConfigurationStatus;
        }

        public final void setTlsInspectionConfigurationStatus(String tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus = tlsInspectionConfigurationStatus;
        }

        @Override
        public final Builder tlsInspectionConfigurationStatus(String tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus = tlsInspectionConfigurationStatus;
            return this;
        }

        @Override
        public final Builder tlsInspectionConfigurationStatus(ResourceStatus tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus(tlsInspectionConfigurationStatus == null ? null
                    : tlsInspectionConfigurationStatus.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getNumberOfAssociations() {
            return numberOfAssociations;
        }

        public final void setNumberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
        }

        @Override
        public final Builder numberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<TlsCertificateData.Builder> getCertificates() {
            List<TlsCertificateData.Builder> result = CertificatesCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<TlsCertificateData.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<TlsCertificateData> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(TlsCertificateData... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<TlsCertificateData.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> TlsCertificateData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TlsCertificateData.Builder getCertificateAuthority() {
            return certificateAuthority != null ? certificateAuthority.toBuilder() : null;
        }

        public final void setCertificateAuthority(TlsCertificateData.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        @Override
        public final Builder certificateAuthority(TlsCertificateData certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        @Override
        public TLSInspectionConfigurationResponse build() {
            return new TLSInspectionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
