/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capacity usage summary of the resources used by the <a>ReferenceSets</a> in a firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityUsageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityUsageSummary.Builder, CapacityUsageSummary> {
    private static final SdkField<CIDRSummary> CID_RS_FIELD = SdkField.<CIDRSummary> builder(MarshallingType.SDK_POJO)
            .memberName("CIDRs").getter(getter(CapacityUsageSummary::cidRs)).setter(setter(Builder::cidRs))
            .constructor(CIDRSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CID_RS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CIDRSummary cidRs;

    private CapacityUsageSummary(BuilderImpl builder) {
        this.cidRs = builder.cidRs;
    }

    /**
     * <p>
     * Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.
     * </p>
     * 
     * @return Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.
     */
    public final CIDRSummary cidRs() {
        return cidRs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidRs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUsageSummary)) {
            return false;
        }
        CapacityUsageSummary other = (CapacityUsageSummary) obj;
        return Objects.equals(cidRs(), other.cidRs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityUsageSummary").add("CIDRs", cidRs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CIDRs":
            return Optional.ofNullable(clazz.cast(cidRs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityUsageSummary, T> g) {
        return obj -> g.apply((CapacityUsageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityUsageSummary> {
        /**
         * <p>
         * Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.
         * </p>
         * 
         * @param cidRs
         *        Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidRs(CIDRSummary cidRs);

        /**
         * <p>
         * Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.
         * </p>
         * This is a convenience method that creates an instance of the {@link CIDRSummary.Builder} avoiding the need to
         * create one manually via {@link CIDRSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CIDRSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #cidRs(CIDRSummary)}.
         * 
         * @param cidRs
         *        a consumer that will call methods on {@link CIDRSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidRs(CIDRSummary)
         */
        default Builder cidRs(Consumer<CIDRSummary.Builder> cidRs) {
            return cidRs(CIDRSummary.builder().applyMutation(cidRs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CIDRSummary cidRs;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUsageSummary model) {
            cidRs(model.cidRs);
        }

        public final CIDRSummary.Builder getCidRs() {
            return cidRs != null ? cidRs.toBuilder() : null;
        }

        public final void setCidRs(CIDRSummary.BuilderImpl cidRs) {
            this.cidRs = cidRs != null ? cidRs.build() : null;
        }

        @Override
        public final Builder cidRs(CIDRSummary cidRs) {
            this.cidRs = cidRs;
            return this;
        }

        @Override
        public CapacityUsageSummary build() {
            return new CapacityUsageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
