/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a EULA resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eula implements SdkPojo, Serializable, ToCopyableBuilder<Eula.Builder, Eula> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(Eula::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Eula::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> EULA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("eulaId")
            .getter(getter(Eula::eulaId)).setter(setter(Builder::eulaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Eula::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(Eula::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            CREATED_AT_FIELD, EULA_ID_FIELD, NAME_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String content;

    private final Instant createdAt;

    private final String eulaId;

    private final String name;

    private final Instant updatedAt;

    private Eula(BuilderImpl builder) {
        this.content = builder.content;
        this.createdAt = builder.createdAt;
        this.eulaId = builder.eulaId;
        this.name = builder.name;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The EULA content.
     * </p>
     * 
     * @return The EULA content.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The EULA ID.
     * </p>
     * 
     * @return The EULA ID.
     */
    public final String eulaId() {
        return eulaId;
    }

    /**
     * <p>
     * The name for the EULA.
     * </p>
     * 
     * @return The name for the EULA.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was updated.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(eulaId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eula)) {
            return false;
        }
        Eula other = (Eula) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(eulaId(), other.eulaId()) && Objects.equals(name(), other.name())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Eula").add("Content", content()).add("CreatedAt", createdAt()).add("EulaId", eulaId())
                .add("Name", name()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "eulaId":
            return Optional.ofNullable(clazz.cast(eulaId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eula, T> g) {
        return obj -> g.apply((Eula) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eula> {
        /**
         * <p>
         * The EULA content.
         * </p>
         * 
         * @param content
         *        The EULA content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The EULA ID.
         * </p>
         * 
         * @param eulaId
         *        The EULA ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulaId(String eulaId);

        /**
         * <p>
         * The name for the EULA.
         * </p>
         * 
         * @param name
         *        The name for the EULA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix epoch timestamp in seconds for when the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private Instant createdAt;

        private String eulaId;

        private String name;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Eula model) {
            content(model.content);
            createdAt(model.createdAt);
            eulaId(model.eulaId);
            name(model.name);
            updatedAt(model.updatedAt);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEulaId() {
            return eulaId;
        }

        public final void setEulaId(String eulaId) {
            this.eulaId = eulaId;
        }

        @Override
        public final Builder eulaId(String eulaId) {
            this.eulaId = eulaId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Eula build() {
            return new Eula(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
