/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Launch Profile Initialization contains information required for a workstation or server to connect to a launch
 * profile.
 * </p>
 * <p>
 * This includes scripts, endpoints, security groups, subnets, and other configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchProfileInitialization implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchProfileInitialization.Builder, LaunchProfileInitialization> {
    private static final SdkField<LaunchProfileInitializationActiveDirectory> ACTIVE_DIRECTORY_FIELD = SdkField
            .<LaunchProfileInitializationActiveDirectory> builder(MarshallingType.SDK_POJO).memberName("activeDirectory")
            .getter(getter(LaunchProfileInitialization::activeDirectory)).setter(setter(Builder::activeDirectory))
            .constructor(LaunchProfileInitializationActiveDirectory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectory").build()).build();

    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ec2SecurityGroupIds")
            .getter(getter(LaunchProfileInitialization::ec2SecurityGroupIds))
            .setter(setter(Builder::ec2SecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(LaunchProfileInitialization::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()).build();

    private static final SdkField<String> LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchProfileProtocolVersion")
            .getter(getter(LaunchProfileInitialization::launchProfileProtocolVersion))
            .setter(setter(Builder::launchProfileProtocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersion")
                    .build()).build();

    private static final SdkField<String> LAUNCH_PURPOSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchPurpose").getter(getter(LaunchProfileInitialization::launchPurpose))
            .setter(setter(Builder::launchPurpose))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchPurpose").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LaunchProfileInitialization::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(LaunchProfileInitialization::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<LaunchProfileInitializationScript>> SYSTEM_INITIALIZATION_SCRIPTS_FIELD = SdkField
            .<List<LaunchProfileInitializationScript>> builder(MarshallingType.LIST)
            .memberName("systemInitializationScripts")
            .getter(getter(LaunchProfileInitialization::systemInitializationScripts))
            .setter(setter(Builder::systemInitializationScripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInitializationScripts")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchProfileInitializationScript> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchProfileInitializationScript::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchProfileInitializationScript>> USER_INITIALIZATION_SCRIPTS_FIELD = SdkField
            .<List<LaunchProfileInitializationScript>> builder(MarshallingType.LIST)
            .memberName("userInitializationScripts")
            .getter(getter(LaunchProfileInitialization::userInitializationScripts))
            .setter(setter(Builder::userInitializationScripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userInitializationScripts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchProfileInitializationScript> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchProfileInitializationScript::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_FIELD,
            EC2_SECURITY_GROUP_IDS_FIELD, LAUNCH_PROFILE_ID_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD, LAUNCH_PURPOSE_FIELD,
            NAME_FIELD, PLATFORM_FIELD, SYSTEM_INITIALIZATION_SCRIPTS_FIELD, USER_INITIALIZATION_SCRIPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LaunchProfileInitializationActiveDirectory activeDirectory;

    private final List<String> ec2SecurityGroupIds;

    private final String launchProfileId;

    private final String launchProfileProtocolVersion;

    private final String launchPurpose;

    private final String name;

    private final String platform;

    private final List<LaunchProfileInitializationScript> systemInitializationScripts;

    private final List<LaunchProfileInitializationScript> userInitializationScripts;

    private LaunchProfileInitialization(BuilderImpl builder) {
        this.activeDirectory = builder.activeDirectory;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersion = builder.launchProfileProtocolVersion;
        this.launchPurpose = builder.launchPurpose;
        this.name = builder.name;
        this.platform = builder.platform;
        this.systemInitializationScripts = builder.systemInitializationScripts;
        this.userInitializationScripts = builder.userInitializationScripts;
    }

    /**
     * <p>
     * A LaunchProfileInitializationActiveDirectory resource.
     * </p>
     * 
     * @return A LaunchProfileInitializationActiveDirectory resource.
     */
    public final LaunchProfileInitializationActiveDirectory activeDirectory() {
        return activeDirectory;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2SecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SecurityGroupIds() {
        return ec2SecurityGroupIds != null && !(ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SecurityGroupIds} method.
     * </p>
     * 
     * @return The EC2 security groups that control access to the studio component.
     */
    public final List<String> ec2SecurityGroupIds() {
        return ec2SecurityGroupIds;
    }

    /**
     * <p>
     * The launch profile ID.
     * </p>
     * 
     * @return The launch profile ID.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * <p>
     * The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".
     * </p>
     * 
     * @return The version number of the protocol that is used by the launch profile. The only valid version is
     *         "2021-03-31".
     */
    public final String launchProfileProtocolVersion() {
        return launchProfileProtocolVersion;
    }

    /**
     * <p>
     * The launch purpose.
     * </p>
     * 
     * @return The launch purpose.
     */
    public final String launchPurpose() {
        return launchPurpose;
    }

    /**
     * <p>
     * The name for the launch profile.
     * </p>
     * 
     * @return The name for the launch profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The platform of the launch platform, either WINDOWS or LINUX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link LaunchProfilePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the launch platform, either WINDOWS or LINUX.
     * @see LaunchProfilePlatform
     */
    public final LaunchProfilePlatform platform() {
        return LaunchProfilePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the launch platform, either WINDOWS or LINUX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link LaunchProfilePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the launch platform, either WINDOWS or LINUX.
     * @see LaunchProfilePlatform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * For responses, this returns true if the service returned a value for the SystemInitializationScripts property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSystemInitializationScripts() {
        return systemInitializationScripts != null && !(systemInitializationScripts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system initializtion scripts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystemInitializationScripts} method.
     * </p>
     * 
     * @return The system initializtion scripts.
     */
    public final List<LaunchProfileInitializationScript> systemInitializationScripts() {
        return systemInitializationScripts;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserInitializationScripts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserInitializationScripts() {
        return userInitializationScripts != null && !(userInitializationScripts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user initializtion scripts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserInitializationScripts} method.
     * </p>
     * 
     * @return The user initializtion scripts.
     */
    public final List<LaunchProfileInitializationScript> userInitializationScripts() {
        return userInitializationScripts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchPurpose());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSystemInitializationScripts() ? systemInitializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserInitializationScripts() ? userInitializationScripts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitialization)) {
            return false;
        }
        LaunchProfileInitialization other = (LaunchProfileInitialization) obj;
        return Objects.equals(activeDirectory(), other.activeDirectory())
                && hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds()
                && Objects.equals(ec2SecurityGroupIds(), other.ec2SecurityGroupIds())
                && Objects.equals(launchProfileId(), other.launchProfileId())
                && Objects.equals(launchProfileProtocolVersion(), other.launchProfileProtocolVersion())
                && Objects.equals(launchPurpose(), other.launchPurpose()) && Objects.equals(name(), other.name())
                && Objects.equals(platformAsString(), other.platformAsString())
                && hasSystemInitializationScripts() == other.hasSystemInitializationScripts()
                && Objects.equals(systemInitializationScripts(), other.systemInitializationScripts())
                && hasUserInitializationScripts() == other.hasUserInitializationScripts()
                && Objects.equals(userInitializationScripts(), other.userInitializationScripts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchProfileInitialization").add("ActiveDirectory", activeDirectory())
                .add("Ec2SecurityGroupIds", hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null)
                .add("LaunchProfileId", launchProfileId()).add("LaunchProfileProtocolVersion", launchProfileProtocolVersion())
                .add("LaunchPurpose", launchPurpose()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Platform", platformAsString())
                .add("SystemInitializationScripts", hasSystemInitializationScripts() ? systemInitializationScripts() : null)
                .add("UserInitializationScripts", hasUserInitializationScripts() ? userInitializationScripts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeDirectory":
            return Optional.ofNullable(clazz.cast(activeDirectory()));
        case "ec2SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupIds()));
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "launchProfileProtocolVersion":
            return Optional.ofNullable(clazz.cast(launchProfileProtocolVersion()));
        case "launchPurpose":
            return Optional.ofNullable(clazz.cast(launchPurpose()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "systemInitializationScripts":
            return Optional.ofNullable(clazz.cast(systemInitializationScripts()));
        case "userInitializationScripts":
            return Optional.ofNullable(clazz.cast(userInitializationScripts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitialization, T> g) {
        return obj -> g.apply((LaunchProfileInitialization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchProfileInitialization> {
        /**
         * <p>
         * A LaunchProfileInitializationActiveDirectory resource.
         * </p>
         * 
         * @param activeDirectory
         *        A LaunchProfileInitializationActiveDirectory resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectory(LaunchProfileInitializationActiveDirectory activeDirectory);

        /**
         * <p>
         * A LaunchProfileInitializationActiveDirectory resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchProfileInitializationActiveDirectory.Builder} avoiding the need to create one manually via
         * {@link LaunchProfileInitializationActiveDirectory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchProfileInitializationActiveDirectory.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #activeDirectory(LaunchProfileInitializationActiveDirectory)}.
         * 
         * @param activeDirectory
         *        a consumer that will call methods on {@link LaunchProfileInitializationActiveDirectory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectory(LaunchProfileInitializationActiveDirectory)
         */
        default Builder activeDirectory(Consumer<LaunchProfileInitializationActiveDirectory.Builder> activeDirectory) {
            return activeDirectory(LaunchProfileInitializationActiveDirectory.builder().applyMutation(activeDirectory).build());
        }

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds);

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds);

        /**
         * <p>
         * The launch profile ID.
         * </p>
         * 
         * @param launchProfileId
         *        The launch profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * The version number of the protocol that is used by the launch profile. The only valid version is
         * "2021-03-31".
         * </p>
         * 
         * @param launchProfileProtocolVersion
         *        The version number of the protocol that is used by the launch profile. The only valid version is
         *        "2021-03-31".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersion(String launchProfileProtocolVersion);

        /**
         * <p>
         * The launch purpose.
         * </p>
         * 
         * @param launchPurpose
         *        The launch purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPurpose(String launchPurpose);

        /**
         * <p>
         * The name for the launch profile.
         * </p>
         * 
         * @param name
         *        The name for the launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The platform of the launch platform, either WINDOWS or LINUX.
         * </p>
         * 
         * @param platform
         *        The platform of the launch platform, either WINDOWS or LINUX.
         * @see LaunchProfilePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfilePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the launch platform, either WINDOWS or LINUX.
         * </p>
         * 
         * @param platform
         *        The platform of the launch platform, either WINDOWS or LINUX.
         * @see LaunchProfilePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfilePlatform
         */
        Builder platform(LaunchProfilePlatform platform);

        /**
         * <p>
         * The system initializtion scripts.
         * </p>
         * 
         * @param systemInitializationScripts
         *        The system initializtion scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInitializationScripts(Collection<LaunchProfileInitializationScript> systemInitializationScripts);

        /**
         * <p>
         * The system initializtion scripts.
         * </p>
         * 
         * @param systemInitializationScripts
         *        The system initializtion scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInitializationScripts(LaunchProfileInitializationScript... systemInitializationScripts);

        /**
         * <p>
         * The system initializtion scripts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #systemInitializationScripts(List<LaunchProfileInitializationScript>)}.
         * 
         * @param systemInitializationScripts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemInitializationScripts(java.util.Collection<LaunchProfileInitializationScript>)
         */
        Builder systemInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder>... systemInitializationScripts);

        /**
         * <p>
         * The user initializtion scripts.
         * </p>
         * 
         * @param userInitializationScripts
         *        The user initializtion scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInitializationScripts(Collection<LaunchProfileInitializationScript> userInitializationScripts);

        /**
         * <p>
         * The user initializtion scripts.
         * </p>
         * 
         * @param userInitializationScripts
         *        The user initializtion scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInitializationScripts(LaunchProfileInitializationScript... userInitializationScripts);

        /**
         * <p>
         * The user initializtion scripts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #userInitializationScripts(List<LaunchProfileInitializationScript>)}.
         * 
         * @param userInitializationScripts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userInitializationScripts(java.util.Collection<LaunchProfileInitializationScript>)
         */
        Builder userInitializationScripts(Consumer<LaunchProfileInitializationScript.Builder>... userInitializationScripts);
    }

    static final class BuilderImpl implements Builder {
        private LaunchProfileInitializationActiveDirectory activeDirectory;

        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String launchProfileId;

        private String launchProfileProtocolVersion;

        private String launchPurpose;

        private String name;

        private String platform;

        private List<LaunchProfileInitializationScript> systemInitializationScripts = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchProfileInitializationScript> userInitializationScripts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitialization model) {
            activeDirectory(model.activeDirectory);
            ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            launchProfileId(model.launchProfileId);
            launchProfileProtocolVersion(model.launchProfileProtocolVersion);
            launchPurpose(model.launchPurpose);
            name(model.name);
            platform(model.platform);
            systemInitializationScripts(model.systemInitializationScripts);
            userInitializationScripts(model.userInitializationScripts);
        }

        public final LaunchProfileInitializationActiveDirectory.Builder getActiveDirectory() {
            return activeDirectory != null ? activeDirectory.toBuilder() : null;
        }

        public final void setActiveDirectory(LaunchProfileInitializationActiveDirectory.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        @Override
        public final Builder activeDirectory(LaunchProfileInitializationActiveDirectory activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = LaunchProfileSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = LaunchProfileSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds) {
            ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final String getLaunchProfileProtocolVersion() {
            return launchProfileProtocolVersion;
        }

        public final void setLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
        }

        @Override
        public final Builder launchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
            return this;
        }

        public final String getLaunchPurpose() {
            return launchPurpose;
        }

        public final void setLaunchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
        }

        @Override
        public final Builder launchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(LaunchProfilePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final List<LaunchProfileInitializationScript.Builder> getSystemInitializationScripts() {
            List<LaunchProfileInitializationScript.Builder> result = LaunchProfileInitializationScriptListCopier
                    .copyToBuilder(this.systemInitializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemInitializationScripts(
                Collection<LaunchProfileInitializationScript.BuilderImpl> systemInitializationScripts) {
            this.systemInitializationScripts = LaunchProfileInitializationScriptListCopier
                    .copyFromBuilder(systemInitializationScripts);
        }

        @Override
        public final Builder systemInitializationScripts(Collection<LaunchProfileInitializationScript> systemInitializationScripts) {
            this.systemInitializationScripts = LaunchProfileInitializationScriptListCopier.copy(systemInitializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInitializationScripts(LaunchProfileInitializationScript... systemInitializationScripts) {
            systemInitializationScripts(Arrays.asList(systemInitializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInitializationScripts(
                Consumer<LaunchProfileInitializationScript.Builder>... systemInitializationScripts) {
            systemInitializationScripts(Stream.of(systemInitializationScripts)
                    .map(c -> LaunchProfileInitializationScript.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchProfileInitializationScript.Builder> getUserInitializationScripts() {
            List<LaunchProfileInitializationScript.Builder> result = LaunchProfileInitializationScriptListCopier
                    .copyToBuilder(this.userInitializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserInitializationScripts(
                Collection<LaunchProfileInitializationScript.BuilderImpl> userInitializationScripts) {
            this.userInitializationScripts = LaunchProfileInitializationScriptListCopier
                    .copyFromBuilder(userInitializationScripts);
        }

        @Override
        public final Builder userInitializationScripts(Collection<LaunchProfileInitializationScript> userInitializationScripts) {
            this.userInitializationScripts = LaunchProfileInitializationScriptListCopier.copy(userInitializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userInitializationScripts(LaunchProfileInitializationScript... userInitializationScripts) {
            userInitializationScripts(Arrays.asList(userInitializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userInitializationScripts(
                Consumer<LaunchProfileInitializationScript.Builder>... userInitializationScripts) {
            userInitializationScripts(Stream.of(userInitializationScripts)
                    .map(c -> LaunchProfileInitializationScript.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LaunchProfileInitialization build() {
            return new LaunchProfileInitialization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
