/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLaunchProfilesRequest extends NimbleRequest implements
        ToCopyableBuilder<ListLaunchProfilesRequest.Builder, ListLaunchProfilesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLaunchProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLaunchProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(ListLaunchProfilesRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("principalId").build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(ListLaunchProfilesRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(ListLaunchProfilesRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PRINCIPAL_ID_FIELD, STATES_FIELD, STUDIO_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String principalId;

    private final List<String> states;

    private final String studioId;

    private ListLaunchProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.principalId = builder.principalId;
        this.states = builder.states;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * The max number of results to return in the response.
     * </p>
     * 
     * @return The max number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The principal ID. This currently supports a IAM Identity Center UserId.
     * </p>
     * 
     * @return The principal ID. This currently supports a IAM Identity Center UserId.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * Filter this request to launch profiles in any of the given states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return Filter this request to launch profiles in any of the given states.
     */
    public final List<LaunchProfileState> states() {
        return LaunchProfileStateListCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter this request to launch profiles in any of the given states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return Filter this request to launch profiles in any of the given states.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchProfilesRequest)) {
            return false;
        }
        ListLaunchProfilesRequest other = (ListLaunchProfilesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(principalId(), other.principalId()) && hasStates() == other.hasStates()
                && Objects.equals(statesAsStrings(), other.statesAsStrings()) && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLaunchProfilesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("PrincipalId", principalId()).add("States", hasStates() ? statesAsStrings() : null)
                .add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchProfilesRequest, T> g) {
        return obj -> g.apply((ListLaunchProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLaunchProfilesRequest> {
        /**
         * <p>
         * The max number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The max number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The principal ID. This currently supports a IAM Identity Center UserId.
         * </p>
         * 
         * @param principalId
         *        The principal ID. This currently supports a IAM Identity Center UserId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * Filter this request to launch profiles in any of the given states.
         * </p>
         * 
         * @param states
         *        Filter this request to launch profiles in any of the given states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * Filter this request to launch profiles in any of the given states.
         * </p>
         * 
         * @param states
         *        Filter this request to launch profiles in any of the given states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * Filter this request to launch profiles in any of the given states.
         * </p>
         * 
         * @param states
         *        Filter this request to launch profiles in any of the given states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<LaunchProfileState> states);

        /**
         * <p>
         * Filter this request to launch profiles in any of the given states.
         * </p>
         * 
         * @param states
         *        Filter this request to launch profiles in any of the given states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(LaunchProfileState... states);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String principalId;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchProfilesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            principalId(model.principalId);
            statesWithStrings(model.states);
            studioId(model.studioId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = LaunchProfileStateListCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = LaunchProfileStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<LaunchProfileState> states) {
            this.states = LaunchProfileStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(LaunchProfileState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLaunchProfilesRequest build() {
            return new ListLaunchProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
